(* fixedobj.mli: interface for fixed objects *)

type kind = BarsXY | BarsZY | BarsXZ | Step

type t = {
  kind: kind;
  hull: Collision.hull;
  mutable dmtimer: float;
}

(* create a new fixed object at given location *)
val newfixed: kind -> float -> float -> float -> t

(* initialize stuff before rendering *)
val init: unit -> unit

(* render the object (with true for textures on, greyscale on) *)
val render: t -> bool -> bool -> unit
