(* mouse.mli: interface for mouse handling for game mode *)

(* Hides the mouse cursor, restrains it to the Tk main window, and won't let it
 * move out. Assign callbacks, one for relative position changes in the mouse,
 * and one for button presses.
 *)
val game_mode_on: poscb:(int -> int -> unit) ->
                  butcb:(unit -> unit) -> unit

(* Turns game mode off: the pointer reappears and is no longer restrained, and
 * the callback registered before is no longer active. *)
val game_mode_off: unit -> unit

