/* mousehelp.c: OCAML-C interface for Xlib trickery */

#include <stdlib.h>
#include <X11/Xlib.h>
#include <tk.h>
#include <caml/mlvalues.h>


/* LablTk's main window */
extern Tk_Window cltk_mainWindow;

/* a blank cursor, created in grabmouse and freed in releasemouse */
#define blank_width 1
#define blank_height 1
static char blank_bits[] = {0x0};
Pixmap blankicon;
Cursor blankcursor;


/* Cause the pointer to be grabbed by the Tk root window */
value grabmouse (value unit)
{
  Display *disp = Tk_Display (cltk_mainWindow);
  Window tkwin = Tk_WindowId (cltk_mainWindow);
  XColor AnyColor;

  blankicon = XCreateBitmapFromData (disp, tkwin, blank_bits,
                                     blank_width, blank_height);
  blankcursor = XCreatePixmapCursor (disp, blankicon, blankicon,
                                     &AnyColor, &AnyColor, 0, 0);

  XGrabPointer (disp, tkwin, True, ButtonPressMask|ButtonReleaseMask|
                EnterWindowMask|LeaveWindowMask|PointerMotionMask|
                PointerMotionHintMask|Button1MotionMask|Button2MotionMask|
                Button3MotionMask|Button4MotionMask|Button5MotionMask|
                ButtonMotionMask|KeymapStateMask, GrabModeAsync, GrabModeAsync,
                tkwin, blankcursor, CurrentTime);

  return Val_unit;
}


/* Warp the pointer to the given coordinates, relative to the Tk root window */
value warpmouse (value x, value y)
{
  Display *disp = Tk_Display (cltk_mainWindow);
  Window tkwin = Tk_WindowId (cltk_mainWindow);

  XWarpPointer (disp, None, tkwin, 0, 0, 0, 0, Int_val(x), Int_val(y));

  return Val_unit;
}


/* Release the pointer (ungrab it) */
value releasemouse (value unit)
{
  Display *disp = Tk_Display (cltk_mainWindow);

  XUngrabPointer (disp, CurrentTime);
  XFreePixmap (disp, blankicon);
  XFreeCursor (disp, blankcursor);

  return Val_unit;
}

