(* tex.ml: helper functions for handling OpenGL textures *)

let setparam () =
  GlTex.parameter ~target:`texture_2d (`mag_filter `linear);
  GlTex.parameter ~target:`texture_2d (`min_filter `linear_mipmap_linear);
  GlTex.parameter ~target:`texture_2d (`wrap_s `repeat);
  GlTex.parameter ~target:`texture_2d (`wrap_t `repeat)

(* Attempt to load a 2d texture from the PPM file specified by argument,
 * auomatically building a full mipmap from it. Returns the id of a new
 * texture object containing it.
 *)
external loadPPM: string -> nativeint = "loadPPMTexture"

(* Bind the given texture object *)
external bind: nativeint -> unit = "bind2dTexture"

(* free the given texture object *)
external delete: nativeint -> unit = "deleteOnetexture"

