(* tex.mli: interface to helper functions for handling textures *)

(* sets the texture parameters *)
val setparam: unit -> unit

(* Attempt to load a 2d texture from the PPM file specified by argument,
 * auomatically building a full mipmap from it. Returns the id of a new
 * texture object containing it.
 *)
external loadPPM: string -> nativeint = "loadPPMTexture"

(* Bind the given texture object *)
external bind: nativeint -> unit = "bind2dTexture"

(* free the given texture object *)
external delete: nativeint -> unit = "deleteOnetexture"

