(* wall.mli: interface to rendering walls *)

type t = Stone | Blocks | Tiles | SlimePuddle

(* initialize walls (should be called before any rendering) *)
val init: unit -> unit

(* render the given wall in canonical coordinates: (-.5,-.5,0) to (.5,.5,0),
 * facing +z (if true is passed, use textures, otherwise don't, and similarly
 * for greyscale). Also pass in alpha *)
val render: t -> bool -> bool -> float -> unit

