/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Sun Dec 15 17:50:53 PST 2002
    copyright            : (C) 2002 by Chong Jiayi
    email                : jychong@stanford.edu
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iostream.h>
#include <stdlib.h>
#include <string>
#include "tinfrastructure.h"
#include "tplane.h"
#include "tmd2.h"
#include <GL/glu.h>

//global declarations, we are testing the engine so it's ok
char win_title[] = "Troodon Engine - Chong Jiayi";
TInfrastructure Infrastructure(640, 480, 0, 0, win_title);
TPlane myPlane(&Infrastructure);
TPlane myPlane2(&Infrastructure);
TMd2 myMd2(&Infrastructure);
TMd2 myMd2_2(&Infrastructure);
GLfloat angleY = 0.0f;
GLfloat distanceZ = -95.0f;

void DrawGLScene();
		
int main(int argc, char *argv[])
{
	if(argc < 5) {
   	exit(1);
	}
	Uint8* keys = NULL; // This variable will be used in the keyboard routine
	int done = false;
	Infrastructure.CreateGL();

	myMd2.SetLoadFlippedNormals(atoi(argv[4]));
	string loadname(argv[1]);
	string geofile(loadname + ".md2");
	string texfile(loadname + ".tga");
	string bumpfile(loadname + "_bump.tga");
	
	char *geofileChar = geofile.c_str();
	char *texfileChar = texfile.c_str();
	char *bumpfileChar = bumpfile.c_str();

	myMd2.LoadGeom(geofileChar);
	myMd2.LoadTexture(texfileChar, bumpfileChar, true, 1.0f);
	myMd2.SetCurrentAnimation(atoi(argv[2]), atoi(argv[3]));

	myMd2_2.LoadGeom(geofileChar);
	myMd2_2.LoadTexture(texfileChar, bumpfileChar, true, 1.0f);
	myMd2_2.SetCurrentAnimation(atoi(argv[2]), atoi(argv[3]));
	
	myPlane.LoadGeom(NULL);
	myPlane.LoadTexture("camo2.tga", "camo.tga", true, 0.5f);

	myPlane2.LoadGeom(NULL);
	myPlane2.LoadTexture("camo2.tga", "camo.tga", true, 0.5f);
  // This is the main loop for the entire program and it will run until done==TRUE
  while(!done)
  {
    // Draw the scene
    DrawGLScene();
    // And poll for events
    SDL_Event event;
    while ( SDL_PollEvent(&event) ) {
      switch (event.type) {
        // If a quit event was recieved
        case SDL_QUIT:
          // then we're done and we'll end this program
          done = true;
          break;
        default:
          break;
      }
    }

    // Get the state of the keyboard keys
    keys = SDL_GetKeyState(NULL);

    // and check if ESCAPE has been pressed. If so then quit
    if(keys[SDLK_ESCAPE]) done = true;

    SDL_GL_SwapBuffers( );
  }

  Infrastructure.KillGLWindow();
  return EXIT_SUCCESS;
}

void RenderMd2() {
	myMd2.PlayAnimation();
	myMd2.EnablePlainDecal();
	myMd2.SelectSingleDecalTexture();
	myMd2.SetupVertexArraysForRendering(DECAL_MODE);
	myMd2.Render();

	myMd2.SetLightPos(0, 5.0f, -4.0f);
	myMd2.SetEyePos(-30,0,600);
	myMd2.SetupLightVectorsForRendering();

	Infrastructure.PrepareStencilShadowing();
	myMd2.CastShadowDepthPass();
	Infrastructure.RenderShadowRect(0.0f, 0.0f, 0.0f, 0.4f);
	Infrastructure.EndStencilShadowing();

	myMd2.EnableDiffusePass(0.2f, 0.2f, 0.2f, 0.0f, 0.6f, 0.6f, 0.6f, 0.0f);
	myMd2.SelectCubeAndBumpTexture();
	myMd2.SetupVertexArraysForRendering(DIFFUSE_BUMP_MODE);
	myMd2.Render();

	myMd2.EnableSpecularPass();
	myMd2.SetupVertexArraysForRendering(SPECULAR_BUMP_MODE);
	myMd2.Render();
}

void RenderMd2PlainDecal(TMd2 *curMd2) {
	curMd2->PlayAnimation();
	curMd2->EnablePlainDecal();
	curMd2->SelectSingleDecalTexture();
	curMd2->SetupVertexArraysForRendering(DECAL_MODE);
	curMd2->Render();

	curMd2->SetLightPos(0, 5.0f, -4.0f);
	curMd2->SetEyePos(-30,0,600);
	curMd2->SetupLightVectorsForRendering();
}

void PrepareMd2Decal(TMd2 *curMd2) {
	curMd2->EnableShadowedDecal();
	curMd2->SelectSingleDecalTexture();
	curMd2->SetupVertexArraysForRendering(DECAL_MODE);

	curMd2->SetLightPos(0, 5.0f, -4.0f);
	curMd2->SetEyePos(-30,0,600);
}

void RenderMd2ShadowPass(TMd2 *curMd2) {
	Infrastructure.PrepareStencilShadowing();
	curMd2->CastShadowDepthPass();
	Infrastructure.RenderShadowRect(0.0f, 0.0f, 0.0f, 0.8f);
	Infrastructure.EndStencilShadowing();
}

void RenderMd2Diffuse(TMd2 *curMd2) {
	curMd2->SetLightPos(0, 5.0f, -4.0f);
	curMd2->SetEyePos(-30,0,600);
	curMd2->SetupLightVectorsForRendering();

	curMd2->EnableDiffusePass(0.2f, 0.2f, 0.2f, 0.0f, 0.6f, 0.6f, 0.6f, 0.0f);
	curMd2->SelectCubeAndBumpTexture();
	curMd2->SetupVertexArraysForRendering(DIFFUSE_BUMP_MODE);
	curMd2->Render();
}

void RenderMd2Specular(TMd2 *curMd2) {
	curMd2->SetLightPos(0, 5.0f, -4.0f);
	curMd2->SetEyePos(-30,0,600);
	curMd2->SetupLightVectorsForRendering();

	curMd2->EnableSpecularPass();
	curMd2->SetupVertexArraysForRendering(SPECULAR_BUMP_MODE);
	curMd2->Render();
}

void DrawGLScene() {
	/* Clear the color and depth buffers. */
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT | GL_STENCIL_BUFFER_BIT);

	distanceZ = distanceZ;
	myPlane.PrepareTransform();
	glTranslatef(0.0, -5.0f, distanceZ);
	glRotatef(0.0f, 1.0f, 0.0, 0.0);
	glScalef(30.0f, 30.0f, 1.0f);
	myPlane.EndTransform();

	myPlane.SetLightPos(0, 5.0f, -4.0f);
	myPlane.SetEyePos(-30,0,600);
	myPlane.SetupLightVectorsForRendering();

	myPlane.EnablePlainDecal();
	myPlane.SelectSingleDecalTexture();
	myPlane.SetupVertexArraysForRendering(DECAL_MODE);
	myPlane.Render();
	
	Infrastructure.PrepareStencilShadowing();
	myPlane.CastShadowDepthPass();
	Infrastructure.RenderShadowRect(0.0f, 0.0f, 0.0f, 0.4f);
	Infrastructure.EndStencilShadowing();

	myPlane.EnableDiffusePass(0.2f, 0.2f, 0.2f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f);
	myPlane.SelectCubeAndBumpTexture();
	myPlane.SetupVertexArraysForRendering(DIFFUSE_BUMP_MODE);
	myPlane.Render();

/*	myPlane2.PrepareTransform();
	angleY = angleY + 0.5f;
	glTranslatef(0.0, 0.0f, -35.0);
	glRotatef(angleY, 1.0f, 0.0f, 0.0);
	glScalef(4.0f, 4.0f, 1.0f);
	myPlane2.EndTransform();

	myPlane2.SetLightPos(0, 5.0f, -4.0f);
	myPlane2.SetEyePos(-30,0,600);
	myPlane2.SetupLightVectorsForRendering();

	myPlane2.EnablePlainDecal();
	myPlane2.SelectSingleDecalTexture();
	myPlane2.SetupVertexArraysForRendering(DECAL_MODE);
	myPlane2.Render();

	Infrastructure.PrepareStencilShadowing();
	myPlane2.CastShadowDepthPass();
	Infrastructure.RenderShadowRect(0.0f, 0.0f, 0.0f, 0.4f);
	Infrastructure.EndStencilShadowing();    

	myPlane2.EnableDiffusePass(0.2f, 0.2f, 0.2f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f);
	myPlane2.SelectCubeAndBumpTexture();
	myPlane2.SetupVertexArraysForRendering(DIFFUSE_BUMP_MODE);
	myPlane2.Render();             
*/
	angleY = angleY - 0.5f;


	myMd2.PrepareTransform();
		glLoadIdentity( );
		glTranslatef( 0.0, 0.0, -45.0 );
		glRotatef(angleY, 0.0f, 1.0f, 0.0f);
		glScalef(0.5f, 0.5f, 0.5f);
	myMd2.EndTransform();

	myMd2_2.PrepareTransform();
		glLoadIdentity( );
		glTranslatef( 5.0, 0.0, -20.0 );
		glRotatef(angleY, 0.0f, 1.0f, 0.0f);
		glScalef(0.3f, 0.3f, 0.3f);
	myMd2_2.EndTransform();

	RenderMd2PlainDecal(&myMd2);
	RenderMd2PlainDecal(&myMd2_2);

	RenderMd2ShadowPass(&myMd2);
	RenderMd2ShadowPass(&myMd2_2);

	PrepareMd2Decal(&myMd2);
	PrepareMd2Decal(&myMd2_2);
	
	RenderMd2Diffuse(&myMd2);
	RenderMd2Specular(&myMd2);
	RenderMd2Diffuse(&myMd2_2);
	RenderMd2Specular(&myMd2_2);

}
