/***************************************************************************
                          tinfrastructure.h  -  description
                             -------------------
    begin                : Sun Dec 15 2002
    copyright            : (C) 2002 by Chong Jiayi
    email                : jychong@stanford.edu
 ***************************************************************************/


#ifndef TINFRASTRUCTURE_H
#define TINFRASTRUCTURE_H


/**
  *@author Chong Jiayi
  */
#define GL_NV_register_combiner 1
#define GL_GLEXT_PROTOTYPES 1

#include <string>
#include <vector>
#include <iostream.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include <GL/glext.h>
#include <SDL/SDL.h>
#include "tga.h"
#include "vectorutils.h"



using namespace std;


const int UNDEFINED = -1;
const int ARRAY_STRIDE = 17 * sizeof(GLfloat);
const int ARRAY_STRIDE2 = 9 * sizeof(GLfloat);

typedef struct {
  Vector position;
  Vector tangentSpaceLightVector;
  Vector tangentSpaceHalfAngleVector;
  GLfloat s, t;
  //used internally at runtime
  Vector lightPos;
  Vector eyePos;
} Vertex;

typedef struct {
  int neighbourIndex;
  Plane plane;
  bool visible;
} Connective;

typedef struct {
  Vector tangent;
  Vector binormal;
  Vector normal;
} OrthoNormalBasis;

typedef struct {
	int decIndex;
	int bumpIndex;
} TextureInfo;

/*** NORMAL MAP TEXTURE CONSTRUCTION ***/

/* Structure to encode a normal like an 8-bit unsigned BGRA vector. */
typedef struct {
  /* Normalized tangent space peturbed surface normal.  The
     [0,1] range of (nx,ny,nz) gets expanded to the [-1,1]
     range in the combiners.  The (nx,ny,nz) is always a
     normalized vector. */
  GLubyte nz, ny, nx;

  /* A scaling factor for the normal.  Mipmap level 0 has a constant
     magnitude of 1.0, but downsampled mipmap levels keep track of
     the unnormalized vector sum length.  For diffuse per-pixel
     lighting, it is preferable to make N' be the _unnormalized_
     vector, but for specular lighting to work reasonably, the
     normal vector should be normalized.  In the diffuse case, we
     can multiply by the "mag" to get the possibly shortened
     unnormalized length. */
  GLubyte mag;

  /* Why does "mag" make sense for diffuse lighting?

     Because sum(L dot Ni)/n == (L dot sum(Ni))/n

     Think about a bumpy diffuse surface in the distance.  It should
     have a duller illumination than a flat diffuse surface in the
     distance. */

  /* On NVIDIA GPUs, the RGB8 internal format is just as memory
     efficient as the RGB8 internal texture format so keeping
     "mag" around is just as cheap as not having it. */

} Normal;

extern "C" gliGenericImage *readTGAImage(char *filename);

class TInfrastructure {

private:
	int width;
	int height;
	int posX;
	int posY;

	const GLuint TO_NORMALIZE_CUBE_MAP = 1;
	const int CUBE_SIZE = 32;
	char * title;
	void getCubeVector(int i, int cubesize, int x, int y, Vector *curVec);
	Normal * convertHeightFieldToNormalMap(GLubyte *pixels, int w, int h, int wr, int hr, float scale);
	void convertHeightFieldAndLoadNormalMapTexture(GLubyte *pixels, int w, int h, int wr, int hr, float scale);
	Normal * downSampleNormalMap(Normal *old, int w2, int h2, int w, int h);
	void makeNormalizeVectorCubeMap(int size);
	gliGenericImage * readImage(char *filename);
	void loadTextureDecalImage(char *filename, int mipmaps);
	void loadTextureNormalMap(char *filename, float scale);
	vector<TextureInfo> textureList;
	char *readShaderFile(const char* filename);
		
public: 
	TInfrastructure(int Width, int Height, int PosX, int PosY, char * Title);
	~TInfrastructure();
	int CreateGL();
	void ReSizeGLScene(GLsizei width, GLsizei height);
	void KillGLWindow();
	void PrepareStencilShadowing();
	void EndStencilShadowing();
	void RenderShadowRect(GLfloat r, GLfloat g, GLfloat b, GLfloat alpha) ;
	TextureInfo *LoadTexture(char *decalFile, int mipmaps, char *bumpFile, float scale);
	GLuint GetCubeMapName() { return TO_NORMALIZE_CUBE_MAP;}

};

#endif

