/***************************************************************************
                          tplane.cpp  -  basic class that builds a plane
                             -------------------
    begin                : Thu Dec 19 2002
    copyright            : (C) 2002 by Chong Jiayi
    email                : jychong@stanford.edu
 ***************************************************************************/


#include "tplane.h"

TPlane::TPlane(TInfrastructure *curInfrastructure) {
	Initialize(curInfrastructure);
}

TPlane::~TPlane() {
	//object memory clean up
	Cleanup();
}

bool TPlane::Loadable() {
	return false;
}

void TPlane::LoadGeom(char *filename) {
	//ignores filename and builds a plane
	 this->triangleNum = 2;
	 this->vertices = new Vertex[this->triangleNum * 3];
	 this->orthobasis = new OrthoNormalBasis[this->triangleNum * 3];
	 this->vertexConnect = new Connective[this->triangleNum * 3];

	 setVertexPos(0, -1.0f, 1.0f, 0.0f);
	 setTextureCoords(0, 0.0f, 1.0f);
	 setNormalCoords(0, 0.0f, 0.0f, 1.0f);
	 setVertexPos(1, 1.0f, 1.0f, 0.0f);
	 setTextureCoords(1, 1.0f, 1.0f);
	 setNormalCoords(1, 0.0f, 0.0f, 1.0f);
	 setVertexPos(2, 1.0f, -1.0f, 0.0f);
	 setTextureCoords(2, 1.0f, 0.0f);
	 setNormalCoords(2, 0.0f, 0.0f, 1.0f);

	 setVertexPos(4, 1.0f, -1.0f, 0.0f);
	 setTextureCoords(4, 1.0f, 0.0f);
	 setNormalCoords(4, 0.0f, 0.0f, 1.0f);
	 setVertexPos(5, -1.0f, -1.0f, 0.0f);
	 setTextureCoords(5, 0.0f, 0.0f);
	 setNormalCoords(5, 0.0f, 0.0f, 1.0f);
	 setVertexPos(3, -1.0f, 1.0f, 0.0f);
	 setTextureCoords(3, 0.0f, 1.0f);
	 setNormalCoords(3, 0.0f, 0.0f, 1.0f);

	this->CalculateSphericalOrthoBasis();
	memset(this->vertexConnect, 0, sizeof(Connective) * this->triangleNum * 3);
	this->SetConnectives();
	this->CalculatePlanes();
}
