/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Sun Dec 15 17:50:53 PST 2002
    copyright            : (C) 2002 by Chong Jiayi
    email                : jychong@stanford.edu
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iostream.h>
#include <stdlib.h>
#include <string>
#include "tinfrastructure.h"
#include "tplane.h"
#include "tmd2.h"
#include "tscene.h"
#include "tconsole.h"
#include "tlevelgen.h"
#include "tfps.h"
#include "fpsclient.h"

//global declarations, we are testing the engine so it's ok
char win_title[] = "Troodon Engine - Chong Jiayi";
TInfrastructure Infrastructure(800, 600, 0, 0, win_title);
FPSClient fpsObject(&Infrastructure);
GLfloat angleY = 0.0f;
GLfloat viewAngleY = 0.0f;
GLfloat viewAngleX = 0.0f;
GLfloat viewZ = 0.0f;
GLfloat viewX = 0.0f;
GLfloat distanceZ = -95.0f;
float viewZDisp = 0.0f, viewXDisp = 0.0f, viewYDisp = 0.0f;
bool showConsole = false;
bool leftDown = false, rightDown = false;

void DrawGLScene();
		
int main(int argc, char *argv[])
{

	Uint8* keys = NULL; // This variable will be used in the keyboard routine
	int done = false;
	Infrastructure.CreateGL(true);
	fpsObject.initialize(argv[1], "weapons.scn");
	

  // This is the main loop for the entire program and it will run until done==TRUE
  while(!done)
  {
    // Draw the scene
    fpsObject.renderAll();
    // And poll for events
    SDL_Event event;
    while ( SDL_PollEvent(&event) ) {
      
      fpsObject.processEvent(&event);
      
      switch (event.type) {
        // If a quit event was recieved
        case SDL_QUIT:
          // then we're done and we'll end this program
          done = true;
          break;
      }
    
    }

    // Get the state of the keyboard keys
    keys = SDL_GetKeyState(NULL);

    // and check if ESCAPE has been pressed. If so then quit
    if(keys[SDLK_ESCAPE]) done = true;

    SDL_GL_SwapBuffers( );
  }

	fpsObject.release();
	Infrastructure.KillGLWindow();
	SDL_ShowCursor(SDL_ENABLE);
  
	return EXIT_SUCCESS;
}


