/***************************************************************************
                          fpsclient.h  -  description
                             -------------------
    begin                : Sun Aug 24 2003
    copyright            : (C) 2003 by Chong Jiayi
    email                : jychong@stanford.edu
 ***************************************************************************/


#ifndef FPSCLIENT_H
#define FPSCLIENT_H

#include <iostream>
#include <stdlib.h>
#include <string>

#include "trts.h"
#include "twidgetmanager.h"
#include "twidgetwindow.h"
#include "tbutton.h"
#include "tconsole.h"

/**
  *@author Chong Jiayi
  */

class FPSClient {
protected:
	TInfrastructure *curInfrastructure;
	TRTS *myScene;
	TConsole *myConsole;
	TWidgetManager *myWidgetManager;
	TWidgetManager *myWidgetManager2;
	TButton *HealthWords;
	TButton *AmmoWords;
	TMd2 *HealthMd2;
	TMd2 *AmmoMd2;
	TPicButton *mousewin_Pic;
	TPicButton *humanwin_Pic;
	float viewZDisp, viewXDisp, viewYDisp, healthRot, ammoRot;
	bool showConsole;
	bool leftDown, rightDown;
	bool done;
	bool once;
	int prevAmmo, prevHealth;
	SDL_Event event;
	LoadCallEvent callBackFunc;
	int mode;
	bool firstDrawFrame;
	void *callBackObj;
	
	void updateDisplay();
	
public: 
	FPSClient(TInfrastructure *infrastructure);
	~FPSClient();
	void initialize(char *sceneFile, char *weaponFile, char *itemsFile);
	void release();
	void processEvent(SDL_Event *curEvent);
	void renderAll();
	void setCallBack(void *obj, LoadCallEvent curCall) { callBackFunc = curCall; callBackObj = obj; }
	void resetCallBack() { myScene->SetCallBack(NULL, NULL); }
	void setMode(int curMode) { mode = curMode; }
};

#endif
