/***************************************************************************
                          mainscreen.cpp  -  description
                             -------------------
    begin                : Wed Oct 29 2003
    copyright            : (C) 2003 by Chong Jiayi
    email                : jychong@stanford.edu
 ***************************************************************************/


#include "mainscreen.h"

const int MENU_BUTTON_WIDTH = 256;
const int MENU_BUTTON_HEIGHT = 128;
const float MAX_DIST = 50.0;

static void HostButtonPress(void *obj, int x, int y);
static void JoinButtonPress(void *obj, int x, int y);
static void ConfigButtonPress(void *obj, int x, int y);
static void ExitButtonPress(void *obj, int x, int y);
static void DoneButtonPress(void *obj, int x, int y);
static void renderRightPress(void *obj, int x, int y);
static void renderLeftPress(void *obj, int x, int y);
static void mouseRightPress(void *obj, int x, int y);
static void mouseLeftPress(void *obj, int x, int y);
static void JoinYesPress(void *obj, int x, int y);
static void JoinNoPress(void *obj, int x, int y);
static void joinNotifyCallBack(void *data);

MainScreen::MainScreen(TInfrastructure *infrastructure){
	curInfrastructure = infrastructure;
	myScene = NULL;
	myWidgetManager = NULL;
	curSelect = -1;
	curMode = NORMAL;
}

MainScreen::~MainScreen(){
}

void MainScreen::processEvent(SDL_Event *curEvent) {
      switch (curEvent->type) {
        // If a quit event was recieved
        case SDL_QUIT:
          // then we're done and we'll end this program
          done = true;
          break;

        case SDL_MOUSEMOTION:
	 break;
	   
	 case SDL_MOUSEBUTTONDOWN:
	 	myWidgetManager->mouseDownProcess(curEvent->motion.x, curInfrastructure->GetWinHeight() - curEvent->motion.y);
	 break;

	 case SDL_MOUSEBUTTONUP:
	 	myWidgetManager->mouseUpProcess(curEvent->motion.x, curInfrastructure->GetWinHeight() - curEvent->motion.y);
	 break;
	 	 
        case SDL_KEYUP:
	
        break;
	
        case SDL_KEYDOWN:
		if(curMode == JOIN_REQUEST) {
			char inputChar[2];
			inputChar[0] = curEvent->key.keysym.unicode;
			inputChar[1] = '\0';
			if(inputChar[0] != '\r') JoinText->AddInputChar(inputChar);
		}
	
	break;
	
        default:
          break;

        
      }
	
}

void MainScreen::renderAll() {
	int cnt = 0;
	for(int i = 0; i < myScene->GetObjectNum(); i++) {
		TObject *curObject = myScene->GetObject(i);
		if(curObject->GetType() == MD2_TYPE) {
			TMd2 *curMd2 = (TMd2 *)curObject;
			curMd2->PlayAnimation();
			
			Vadd(&transVec[cnt], &moveVec[cnt], &transVec[cnt]);
			rotateVal[cnt] = rotateVal[cnt] + 2.0;
			if(rotateVal[cnt] > 360.0) rotateVal[cnt] = rotateVal[cnt] - 360.0;
			curMd2->PrepareTransform();
				glTranslatef(transVec[cnt].x, transVec[cnt].y, transVec[cnt].z - 50.0);
				glRotatef(rotateVal[cnt], 0.0, 1.0, 1.0);
			curMd2->EndTransform();
		
			if(Vlength(&transVec[cnt]) > MAX_DIST) {
				float randX = (float)rand() / (float) RAND_MAX * 1.0 - 0.5;
				float randY = (float)rand() / (float) RAND_MAX * 1.0 - 0.5;
				float randZ = (float)rand() / (float) RAND_MAX * 1.0 - 0.5;
				Vset(&moveVec[cnt], randX, randY, randZ);
			}
			
			cnt++;
		}
		
	}
	
	myScene->PrepareSceneForCulling();
	myScene->RecalcSectorPos();
	myScene->ApplyViewerTransform();
	myScene->DoLightingCalc();
	myScene->PortalCull();
	myScene->FrustrumCull();
	myScene->RenderAll();
	myScene->GlowRender();
	
	myWidgetManager->renderWidgets();
	if(curMode == JOIN_REQUEST) {
		JoinText->Render();
	}
}

void MainScreen::initialize(char *filename) {
	myScene = new TRTS(curInfrastructure);
	myWidgetManager = new TWidgetManager(curInfrastructure);
	
	myScene->LoadSceneFile(filename);
	
	Logo = new TPicButton(curInfrastructure);
	HostButton = new TPicButton(curInfrastructure);
	JoinButton = new TPicButton(curInfrastructure);
	ConfigButton = new TPicButton(curInfrastructure);
	ExitButton = new TPicButton(curInfrastructure);
	MouseSlider = new TPicButton(curInfrastructure);
	MouseArrowLeft = new TPicButton(curInfrastructure);
	MouseArrowRight = new TPicButton(curInfrastructure);
	RenderSlider = new TPicButton(curInfrastructure);
	RenderArrowLeft = new TPicButton(curInfrastructure);
	RenderArrowRight = new TPicButton(curInfrastructure);
	MouseSensitiveLogo = new TPicButton(curInfrastructure);
	RenderLevelLogo = new TPicButton(curInfrastructure);
	DoneButton = new TPicButton(curInfrastructure);
	RenderKnob = new TPicButton(curInfrastructure);
	MouseKnob = new TPicButton(curInfrastructure);
	JoinYesButton = new TButton(curInfrastructure);
	JoinNoButton = new TButton(curInfrastructure);
	JoinDisplay = new TLabel(curInfrastructure);
//	JoinText = new TConsole(curInfrastructure->GetWinWidth() * 0.35, curInfrastructure->GetWinHeight() * 0.5, 
//						curInfrastructure->GetWinWidth() * 0.8, curInfrastructure->GetWinHeight() * 0.48, curInfrastructure);
	JoinText = new TConsole(curInfrastructure->GetWinWidth() * 0.35, curInfrastructure->GetWinHeight() * 0.47, 
						curInfrastructure->GetWinWidth() * 0.8, curInfrastructure->GetWinHeight() * 0.5, curInfrastructure);
	JoinText->SetVisibleLines(3);
	JoinText->SetBorder(true, 0.0, 0.7, 1.0, 0.7, 0.0, 0.0, 0.1, 1.0);
	JoinText->AddString("", 0 , true);
						
	Logo->setTexture("./ClientResource/game_logo.tga");
	Logo->setButtonUpColor(1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0);
	Logo->setButtonDownColor(1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0);
	Logo->setTitle("", 0);
	Logo->setDimensions(curInfrastructure->GetWinWidth() * 0.5 - MENU_BUTTON_WIDTH, 
						curInfrastructure->GetWinHeight() * 0.85 - MENU_BUTTON_HEIGHT * 0.5,
						MENU_BUTTON_WIDTH * 2.0, MENU_BUTTON_HEIGHT * 1.5);
	
	HostButton->setTexture("./ClientResource/host_game_pic.tga");
	HostButton->setButtonUpColor(1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0);
	HostButton->setButtonDownColor(1.0, 1.0, 1.0, 1.0, 1.0, 0.4, 0.4);
	HostButton->setTitle("", 0);
	HostButton->setDimensions(curInfrastructure->GetWinWidth() * 0.5 - MENU_BUTTON_WIDTH * 0.5, 
						curInfrastructure->GetWinHeight() * 0.7 - MENU_BUTTON_HEIGHT * 0.5,
						MENU_BUTTON_WIDTH, MENU_BUTTON_HEIGHT);
	HostButton->setMouseUpFunction(&HostButtonPress);
	HostButton->setWidgetCallObject((void *)this);


	JoinButton->setTexture("./ClientResource/join_game_pic.tga");
	JoinButton->setButtonUpColor(1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0);
	JoinButton->setButtonDownColor(1.0, 1.0, 1.0, 1.0, 1.0, 0.4, 0.4);
	JoinButton->setTitle("", 0);
	JoinButton->setDimensions(curInfrastructure->GetWinWidth() * 0.5 - MENU_BUTTON_WIDTH * 0.5, 
						curInfrastructure->GetWinHeight() * 0.5 - MENU_BUTTON_HEIGHT * 0.5,
						MENU_BUTTON_WIDTH, MENU_BUTTON_HEIGHT);
	JoinButton->setMouseUpFunction(&JoinButtonPress);
	JoinButton->setWidgetCallObject((void *)this);

	ConfigButton->setTexture("./ClientResource/configure_game_pic.tga");
	ConfigButton->setButtonUpColor(1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0);
	ConfigButton->setButtonDownColor(1.0, 1.0, 1.0, 1.0, 1.0, 0.4, 0.4);
	ConfigButton->setTitle("", 0);
	ConfigButton->setDimensions(curInfrastructure->GetWinWidth() * 0.5 - MENU_BUTTON_WIDTH * 0.5, 
						curInfrastructure->GetWinHeight() * 0.3 - MENU_BUTTON_HEIGHT * 0.5,
						MENU_BUTTON_WIDTH, MENU_BUTTON_HEIGHT);
	ConfigButton->setMouseUpFunction(&ConfigButtonPress);
	ConfigButton->setWidgetCallObject((void *)this);


	ExitButton->setTexture("./ClientResource/exit_game_pic.tga");
	ExitButton->setButtonUpColor(1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0);
	ExitButton->setButtonDownColor(1.0, 1.0, 1.0, 1.0, 1.0, 0.4, 0.4);
	ExitButton->setTitle("", 0);
	ExitButton->setDimensions(curInfrastructure->GetWinWidth() * 0.5 - MENU_BUTTON_WIDTH * 0.5, 
						curInfrastructure->GetWinHeight() * 0.1 - MENU_BUTTON_HEIGHT * 0.5,
						MENU_BUTTON_WIDTH, MENU_BUTTON_HEIGHT);
	ExitButton->setMouseUpFunction(&ExitButtonPress);
	ExitButton->setWidgetCallObject((void *)this);
	
	//now do config screen stuff
	RenderLevelLogo->setTexture("./ClientResource/render_level_text.tga");
	RenderLevelLogo->setButtonUpColor(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
	RenderLevelLogo->setButtonDownColor(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
	RenderLevelLogo->setTitle("", 0);
	RenderLevelLogo->setDimensions(curInfrastructure->GetWinWidth() * 0.35 - MENU_BUTTON_WIDTH, 
						curInfrastructure->GetWinHeight() * 0.7 - MENU_BUTTON_HEIGHT * 0.5,
						MENU_BUTTON_WIDTH, MENU_BUTTON_HEIGHT * 0.5);
	RenderLevelLogo->show(false);
						
	MouseSensitiveLogo->setTexture("./ClientResource/mouse_sensitive_text.tga");
	MouseSensitiveLogo->setButtonUpColor(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
	MouseSensitiveLogo->setButtonDownColor(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
	MouseSensitiveLogo->setTitle("", 0);
	MouseSensitiveLogo->setDimensions(curInfrastructure->GetWinWidth() * 0.35 - MENU_BUTTON_WIDTH, 
						curInfrastructure->GetWinHeight() * 0.5 - MENU_BUTTON_HEIGHT * 0.5,
						MENU_BUTTON_WIDTH, MENU_BUTTON_HEIGHT * 0.5);
	MouseSensitiveLogo->show(false);
	
	RenderArrowLeft->setTexture("./ClientResource/arrow_left.tga");
	RenderArrowLeft->setButtonUpColor(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
	RenderArrowLeft->setButtonDownColor(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
	RenderArrowLeft->setTitle("", 0);
	RenderArrowLeft->setDimensions(curInfrastructure->GetWinWidth() * 0.65 - MENU_BUTTON_WIDTH, 
						curInfrastructure->GetWinHeight() * 0.7 - MENU_BUTTON_HEIGHT * 0.5,
						MENU_BUTTON_WIDTH*0.5, MENU_BUTTON_HEIGHT *0.5);
	RenderArrowLeft->show(false);
	RenderArrowLeft->setMouseUpFunction(&renderLeftPress);
	RenderArrowLeft->setWidgetCallObject((void *)this);
	
	RenderArrowRight->setTexture("./ClientResource/arrow_right.tga");
	RenderArrowRight->setButtonUpColor(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
	RenderArrowRight->setButtonDownColor(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
	RenderArrowRight->setTitle("", 0);
	RenderArrowRight->setDimensions(curInfrastructure->GetWinWidth()  * 1.2 - MENU_BUTTON_WIDTH, 
						curInfrastructure->GetWinHeight() * 0.7 - MENU_BUTTON_HEIGHT * 0.5,
						MENU_BUTTON_WIDTH * 0.5, MENU_BUTTON_HEIGHT *0.5);
	RenderArrowRight->setMouseUpFunction(&renderRightPress);
	RenderArrowRight->setWidgetCallObject((void *)this);
	RenderArrowRight->show(false);
	
	RenderSlider->setTexture("./ClientResource/hrule.tga");
	RenderSlider->setButtonUpColor(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
	RenderSlider->setButtonDownColor(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
	RenderSlider->setTitle("", 0);
	RenderSlider->setDimensions(curInfrastructure->GetWinWidth() * 0.75 - MENU_BUTTON_WIDTH, 
						curInfrastructure->GetWinHeight() * 0.72 - MENU_BUTTON_HEIGHT * 0.5,
						MENU_BUTTON_WIDTH * 1.5, MENU_BUTTON_HEIGHT * 0.3); 
	RenderSlider->show(false);
	
	renderKnobVal = (float)(curInfrastructure->GetConfigKeys()).renderLevel;
	mouseKnobVal = (float)(curInfrastructure->GetConfigKeys()).moveXrot;
	
	RenderKnob->setTexture("./ClientResource/knob.tga");
	RenderKnob->setButtonUpColor(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
	RenderKnob->setButtonDownColor(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
	RenderKnob->setTitle("", 0);
	RenderKnob->setDimensions(curInfrastructure->GetWinWidth() * 0.75 - MENU_BUTTON_WIDTH + (renderKnobVal - 6.0) * 80.0, 
						curInfrastructure->GetWinHeight() * 0.72 - MENU_BUTTON_HEIGHT * 0.5,
						MENU_BUTTON_WIDTH * 0.4, MENU_BUTTON_HEIGHT * 0.3); 
	RenderKnob->show(false);
	
	MouseArrowLeft->setTexture("./ClientResource/arrow_left.tga");
	MouseArrowLeft->setButtonUpColor(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
	MouseArrowLeft->setButtonDownColor(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
	MouseArrowLeft->setTitle("", 0);
	MouseArrowLeft->setDimensions(curInfrastructure->GetWinWidth() * 0.65 - MENU_BUTTON_WIDTH, 
						curInfrastructure->GetWinHeight() * 0.50 - MENU_BUTTON_HEIGHT * 0.5,
						MENU_BUTTON_WIDTH * 0.5, MENU_BUTTON_HEIGHT * 0.5);
	MouseArrowLeft->show(false);
	MouseArrowLeft->setMouseUpFunction(&mouseLeftPress);
	MouseArrowLeft->setWidgetCallObject((void *)this);
	
	MouseArrowRight->setTexture("./ClientResource/arrow_right.tga");
	MouseArrowRight->setButtonUpColor(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
	MouseArrowRight->setButtonDownColor(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
	MouseArrowRight->setTitle("", 0);
	MouseArrowRight->setDimensions(curInfrastructure->GetWinWidth() * 1.2 - MENU_BUTTON_WIDTH, 
						curInfrastructure->GetWinHeight() * 0.50 - MENU_BUTTON_HEIGHT * 0.5,
						MENU_BUTTON_WIDTH  *0.5, MENU_BUTTON_HEIGHT *0.5);
	MouseArrowRight->show(false);
	MouseArrowRight->setMouseUpFunction(&mouseRightPress);
	MouseArrowRight->setWidgetCallObject((void *)this);
	
	MouseSlider->setTexture("./ClientResource/hrule.tga");
	MouseSlider->setButtonUpColor(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
	MouseSlider->setButtonDownColor(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
	MouseSlider->setTitle("", 0);
	MouseSlider->setDimensions(curInfrastructure->GetWinWidth() * 0.75 - MENU_BUTTON_WIDTH, 
						curInfrastructure->GetWinHeight() * 0.52 - MENU_BUTTON_HEIGHT * 0.5,
						MENU_BUTTON_WIDTH * 1.5, MENU_BUTTON_HEIGHT * 0.3); 
	MouseSlider->show(false);

	MouseKnob->setTexture("./ClientResource/knob.tga");
	MouseKnob->setButtonUpColor(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
	MouseKnob->setButtonDownColor(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
	MouseKnob->setTitle("", 0);
	MouseKnob->setDimensions(curInfrastructure->GetWinWidth() * 0.75 - MENU_BUTTON_WIDTH + (mouseKnobVal - 0.5) * 70.0,  
						curInfrastructure->GetWinHeight() * 0.52 - MENU_BUTTON_HEIGHT * 0.5,
						MENU_BUTTON_WIDTH * 0.4, MENU_BUTTON_HEIGHT * 0.3); 
	MouseKnob->show(false);
	
	DoneButton->setTexture("./ClientResource/done.tga");
	DoneButton->setButtonUpColor(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
	DoneButton->setButtonDownColor(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
	DoneButton->setTitle("", 0);
	DoneButton->setDimensions(curInfrastructure->GetWinWidth() * 0.95 - MENU_BUTTON_WIDTH * 0.5, 
						curInfrastructure->GetWinHeight() * 0.1 - MENU_BUTTON_HEIGHT * 0.5,
						MENU_BUTTON_WIDTH * 0.5, MENU_BUTTON_HEIGHT * 0.5);
	DoneButton->setMouseUpFunction(&DoneButtonPress);
	DoneButton->setWidgetCallObject((void *)this);
	
	DoneButton->show(false);
	
	JoinYesButton->setTitle("OK", 0);
	JoinYesButton->setTextColor(0.0, 0.0, 0.0, 0.0);
	JoinYesButton->setButtonUpColor(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
	JoinYesButton->setButtonDownColor(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
	JoinYesButton->setTextOffset(25, 20);
	JoinYesButton->setDimensions(curInfrastructure->GetWinWidth() * 0.5 - MENU_BUTTON_WIDTH * 0.5, 
						curInfrastructure->GetWinHeight() * 0.45 - MENU_BUTTON_HEIGHT * 0.5,
						MENU_BUTTON_WIDTH * 0.5, MENU_BUTTON_HEIGHT * 0.5);
	JoinYesButton->setWidgetCallObject((void *)this);
	JoinYesButton->setMouseUpFunction(&JoinYesPress);
	JoinYesButton->show(false);

	JoinNoButton->setTitle("CANCEL", 0);
	JoinNoButton->setTextColor(0.0, 0.0, 0.0, 0.0);
	JoinNoButton->setTextOffset(25, 20);
	JoinNoButton->setButtonUpColor(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
	JoinNoButton->setButtonDownColor(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
	JoinNoButton->setDimensions(curInfrastructure->GetWinWidth() * 0.8 - MENU_BUTTON_WIDTH * 0.5, 
						curInfrastructure->GetWinHeight() * 0.45 - MENU_BUTTON_HEIGHT * 0.5,
						MENU_BUTTON_WIDTH * 0.5, MENU_BUTTON_HEIGHT * 0.5);
	JoinNoButton->setWidgetCallObject((void *)this);
	JoinNoButton->setMouseUpFunction(&JoinNoPress);
	JoinNoButton->show(false);
			
	JoinDisplay->setFont(1, "Enter in Hostname/IP Address:");
	JoinDisplay->setColor(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
	JoinDisplay->setDimensions(curInfrastructure->GetWinWidth() * 0.5 - MENU_BUTTON_WIDTH * 0.5, 
						curInfrastructure->GetWinHeight() * 0.62 - MENU_BUTTON_HEIGHT * 0.5,
						MENU_BUTTON_WIDTH * 0.5, MENU_BUTTON_HEIGHT * 0.5);
	JoinDisplay->show(false);
	
	myWidgetManager->AttachWidget(Logo);
	myWidgetManager->AttachWidget(HostButton);
	myWidgetManager->AttachWidget(JoinButton);
	myWidgetManager->AttachWidget(ConfigButton);
	myWidgetManager->AttachWidget(ExitButton);
	myWidgetManager->AttachWidget(MouseSlider);
	myWidgetManager->AttachWidget(MouseArrowLeft);
	myWidgetManager->AttachWidget(MouseArrowRight);
	myWidgetManager->AttachWidget(RenderSlider);
	myWidgetManager->AttachWidget(RenderArrowLeft);
	myWidgetManager->AttachWidget(RenderArrowRight);
	myWidgetManager->AttachWidget(MouseSensitiveLogo);
	myWidgetManager->AttachWidget(RenderLevelLogo);
	myWidgetManager->AttachWidget(DoneButton);
	myWidgetManager->AttachWidget(MouseKnob);
	myWidgetManager->AttachWidget(RenderKnob);
	myWidgetManager->AttachWidget(JoinYesButton);
	myWidgetManager->AttachWidget(JoinNoButton);
	myWidgetManager->AttachWidget(JoinDisplay);
	
	SDL_EnableUNICODE(1);
	
	for(int i = 0; i < 10; i++) {
		float randX = (float)rand() / (float) RAND_MAX * 1.0 - 0.5;
		float randY = (float)rand() / (float) RAND_MAX * 1.0 - 0.5;
		float randZ = (float)rand() / (float) RAND_MAX * 1.0 - 0.5;
		Vset(&moveVec[i], randX, randY, randZ);
		Vset(&transVec[i], 0.0, 0.0, 0.0);
		rotateVal[i] = (float)rand() / (float) RAND_MAX * 360.0;
	}

	for(int i = 0; i < myScene->GetObjectNum(); i++) {
	TObject *curObject = myScene->GetObject(i);
		if(curObject->GetType() == MD2_TYPE) {
			TMd2 *curMd2 = (TMd2 *)curObject;
			curMd2->SetCurrentAnimation(1, 5);
		}
	}
	
	myScene->MoveViewerDelta(0.0, 0.0, 0.0, 0.0, 0.0, 0.0f);
	myScene->setMovement(0.7, 0.7, 1.7, 0.7, 0.7);
	myScene->extractBounds();
	myScene->presetObjectSelection();
}

void MainScreen::showMainScreen() {
	HostButton->show(true);
	JoinButton->show(true);
	ConfigButton->show(true);
	ExitButton->show(true);
	
	RenderSlider->show(false);
	RenderArrowLeft->show(false);
	RenderArrowRight->show(false);
	RenderSlider->show(false);
	MouseArrowLeft->show(false);
	MouseArrowRight->show(false);
	MouseSlider->show(false);
	MouseSensitiveLogo->show(false);
	RenderLevelLogo->show(false);
	DoneButton->show(false);
	MouseKnob->show(false);
	RenderKnob->show(false);

	JoinYesButton->show(false);
	JoinNoButton->show(false);
	JoinDisplay->show(false);
}

void MainScreen::setRenderKnobVal(bool flag) {
	if(flag) {
		int curLevel = (curInfrastructure->GetConfigKeys()).renderLevel;
		GameConfigKeys curKey = curInfrastructure->GetConfigKeys();
		if(curLevel < RENDER_LEVEL3) curLevel++;
		curKey.renderLevel = curLevel;
		curInfrastructure->SetConfigKeys(curKey);
	}
	else {
		int curLevel = (curInfrastructure->GetConfigKeys()).renderLevel;
		GameConfigKeys curKey = curInfrastructure->GetConfigKeys();
		if(curLevel > RENDER_LEVEL0) curLevel--;
		curKey.renderLevel = curLevel;
		curInfrastructure->SetConfigKeys(curKey);
	}

	renderKnobVal = (float)(curInfrastructure->GetConfigKeys()).renderLevel;
	mouseKnobVal = (float)(curInfrastructure->GetConfigKeys()).moveXrot;
	RenderKnob->setDimensions(curInfrastructure->GetWinWidth() * 0.75 - MENU_BUTTON_WIDTH + (renderKnobVal - 6.0) * 80.0, 
						curInfrastructure->GetWinHeight() * 0.72 - MENU_BUTTON_HEIGHT * 0.5,
						MENU_BUTTON_WIDTH * 0.4, MENU_BUTTON_HEIGHT * 0.3); 
}

void MainScreen::setMouseKnobVal(bool flag) {
	if(flag) {
		float curLevel = (curInfrastructure->GetConfigKeys()).moveXrot;
		GameConfigKeys curKey = curInfrastructure->GetConfigKeys();
		if(curLevel < 4.5) curLevel = curLevel + 0.1;
		curKey.moveXrot = curLevel;
		curKey.moveYrot = curLevel;
		curInfrastructure->SetConfigKeys(curKey);
	}
	else {
		float curLevel = (curInfrastructure->GetConfigKeys()).moveXrot;
		GameConfigKeys curKey = curInfrastructure->GetConfigKeys();
		if(curLevel > 0.5) curLevel = curLevel - 0.1;
		curKey.moveXrot = curLevel;
		curKey.moveYrot = curLevel;
		curInfrastructure->SetConfigKeys(curKey);
	}

	renderKnobVal = (float)(curInfrastructure->GetConfigKeys()).renderLevel;
	mouseKnobVal = (float)(curInfrastructure->GetConfigKeys()).moveXrot;
	MouseKnob->setDimensions(curInfrastructure->GetWinWidth() * 0.75 - MENU_BUTTON_WIDTH + (mouseKnobVal - 0.5) * 70.0, 
						curInfrastructure->GetWinHeight() * 0.52 - MENU_BUTTON_HEIGHT * 0.5,
						MENU_BUTTON_WIDTH * 0.4, MENU_BUTTON_HEIGHT * 0.3); 
}

void MainScreen::showConfigScreen() {
	
	HostButton->show(false);
	JoinButton->show(false);
	ConfigButton->show(false);
	ExitButton->show(false);

	RenderLevelLogo->setButtonUpColor(1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0);
	RenderLevelLogo->setButtonDownColor(1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0);
	MouseSensitiveLogo->setButtonUpColor(1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0);
	MouseSensitiveLogo->setButtonDownColor(1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0);
	
	RenderSlider->setButtonUpColor(1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0);
	RenderSlider->setButtonDownColor(1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0);
	RenderArrowLeft->setButtonUpColor(1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0);
	RenderArrowLeft->setButtonDownColor(0.5, 0.5, 0.5, 1.0, 1.0, 1.0, 1.0);
	RenderArrowRight->setButtonUpColor(1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0);
	RenderArrowRight->setButtonDownColor(0.5, 0.5, 0.5, 1.0, 1.0, 1.0, 1.0);
	
	MouseSlider->setButtonUpColor(1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0);
	MouseSlider->setButtonDownColor(1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0);
	MouseArrowLeft->setButtonUpColor(1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0);
	MouseArrowLeft->setButtonDownColor(0.5, 0.5, 0.5, 1.0, 1.0, 1.0, 1.0);
	MouseArrowRight->setButtonUpColor(1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0);
	MouseArrowRight->setButtonDownColor(0.5, 0.5, 0.5, 1.0, 1.0, 1.0, 1.0);
		
	DoneButton->setButtonUpColor(1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0);
	DoneButton->setButtonDownColor(0.5, 0.5, 0.5, 1.0, 1.0, 1.0, 1.0);
	
	MouseKnob->setButtonUpColor(1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0);
	MouseKnob->setButtonDownColor(0.5, 0.5, 0.5, 1.0, 1.0, 1.0, 1.0);
	RenderKnob->setButtonUpColor(1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0);
	RenderKnob->setButtonDownColor(0.5, 0.5, 0.5, 1.0, 1.0, 1.0, 1.0);
	
	RenderSlider->show(true);
	RenderArrowLeft->show(true);
	RenderArrowRight->show(true);
	
	MouseSlider->show(true);
	MouseArrowLeft->show(true);
	MouseArrowRight->show(true);
	
	MouseSensitiveLogo->show(true);
	RenderLevelLogo->show(true);
	
	DoneButton->show(true);

	MouseKnob->show(true);
	RenderKnob->show(true);
}

void MainScreen::showJoinScreen() {
	HostButton->show(false);
	JoinButton->show(false);
	ConfigButton->show(false);
	ExitButton->show(false);
	
	JoinYesButton->setTextColor(1.0, 1.0, 0.0, 1.0);
	JoinYesButton->setButtonUpColor(0.3, 0.5, 0.5, 0.0, 0.5, 0.5, 1.0);
	JoinYesButton->setButtonDownColor(1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0);

	JoinNoButton->setTextColor(1.0, 1.0, 0.0, 1.0);
	JoinNoButton->setButtonUpColor(0.3, 0.5, 0.5, 0.0, 0.5, 0.5, 1.0);
	JoinNoButton->setButtonDownColor(1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
	
	JoinDisplay->setColor(1.0, 1.0, 1.0, 0.5, 0.5, 0.5, 1.0);
	
	JoinYesButton->show(true);
	JoinNoButton->show(true);
	JoinDisplay->show(true);
}

void MainScreen::release() {
	if(myScene != NULL) delete myScene;
	if(myWidgetManager != NULL) delete myWidgetManager;
}

static void HostButtonPress(void *obj, int x, int y) {
	MainScreen *curMainScreen = (MainScreen *)obj;
	curMainScreen->setSelect(HOST_MODE_SELECTED);
	curMainScreen->playBeep();
}

static void JoinButtonPress(void *obj, int x, int y) {
	MainScreen *curMainScreen = (MainScreen *)obj;
	curMainScreen->showJoinScreen();
	curMainScreen->setMode(JOIN_REQUEST);
	curMainScreen->playBeep();
}

static void ConfigButtonPress(void *obj, int x, int y) {
	MainScreen *curMainScreen = (MainScreen *)obj;
//	curMainScreen->setSelect(CONFIG_MODE_SELECTED);
	curMainScreen->showConfigScreen();
	curMainScreen->playBeep();
}

static void DoneButtonPress(void *obj, int x, int y) {
	MainScreen *curMainScreen = (MainScreen *)obj;
//	curMainScreen->setSelect(MAIN_SELECTION_MODE);
	curMainScreen->showMainScreen();
	curMainScreen->playBeep();
}

static void ExitButtonPress(void *obj, int x, int y) {
	MainScreen *curMainScreen = (MainScreen *)obj;
	curMainScreen->setSelect(EXIT_MODE_SELECTED);
	curMainScreen->playBeep();
}


static void renderRightPress(void *obj, int x, int y) {
	MainScreen *curMainScreen = (MainScreen *)obj;
	curMainScreen->setRenderKnobVal(true);
}

static void renderLeftPress(void *obj, int x, int y) {
	MainScreen *curMainScreen = (MainScreen *)obj;
	curMainScreen->setRenderKnobVal(false);
}

static void mouseRightPress(void *obj, int x, int y) {
	MainScreen *curMainScreen = (MainScreen *)obj;
	curMainScreen->setMouseKnobVal(true);
}

static void mouseLeftPress(void *obj, int x, int y) {
	MainScreen *curMainScreen = (MainScreen *)obj;
	curMainScreen->setMouseKnobVal(false);
}

static void JoinYesPress(void *obj, int x, int y) {
	MainScreen *curMainScreen = (MainScreen *)obj;
	TNetwork *curNetworkObj = curMainScreen->grabNetwork();
	string curIP = curMainScreen->getIPString();
	cout << "User attempting to join game at: " << curIP << endl;

	curNetworkObj->joinServer((char *)curIP.c_str(), &joinNotifyCallBack, obj);
	
	curMainScreen->playBeep();
}

static void JoinNoPress(void *obj, int x, int y) {
	MainScreen *curMainScreen = (MainScreen *)obj;
	curMainScreen->showMainScreen();	
	curMainScreen->setMode(NORMAL);
	curMainScreen->playBeep();
}

static void joinNotifyCallBack(void *data) {
	MainScreen *curMainScreen = (MainScreen *)data;
	curMainScreen->setSelect(JOIN_MODE_SELECTED);
	
	
}
