/***************************************************************************
                          mainscreen.h  -  description
                             -------------------
    begin                : Wed Oct 29 2003
    copyright            : (C) 2003 by Chong Jiayi
    email                : jychong@stanford.edu
 ***************************************************************************/


#ifndef MAINSCREEN_H
#define MAINSCREEN_H

#include "trts.h"
#include "twidgetmanager.h"
#include "twidgetwindow.h"
#include "tpicbutton.h"
#include "tbutton.h"
#include "tconsole.h"
/**
  *@author Chong Jiayi
  */
  
const int HOST_MODE_SELECTED = 1;
const int JOIN_MODE_SELECTED = 2;
const int CONFIG_MODE_SELECTED = 3;
const int EXIT_MODE_SELECTED = 4;

const int JOIN_REQUEST = 1;
const int NORMAL = 0;

const int OFFSCREEN = 10000;

class MainScreen {
protected:
	TInfrastructure *curInfrastructure;
	TRTS *myScene;
	TWidgetManager *myWidgetManager;
	TPicButton *Logo;
	TPicButton *HostButton;
	TPicButton *JoinButton;
	TPicButton *ConfigButton;
	TPicButton *ExitButton;
	TPicButton *MouseSlider;
	TPicButton *MouseArrowLeft;
	TPicButton *MouseArrowRight;
	TPicButton *MouseKnob;
	TPicButton *RenderSlider;
	TPicButton *RenderArrowLeft;
	TPicButton *RenderArrowRight;
	TPicButton *RenderKnob;
	TPicButton *MouseSensitiveLogo;
	TPicButton *RenderLevelLogo;
	TPicButton *DoneButton;
	TButton *JoinYesButton;
	TButton *JoinNoButton;
	TConsole *JoinText;
	TLabel *JoinDisplay;
	bool done;
	int curSelect;
	int curMode;
	float rotateVal[10];
	Vector moveVec[10];
	Vector transVec[10];
	float renderKnobVal, mouseKnobVal;
	
public: 
	MainScreen(TInfrastructure *infrastructure);
	~MainScreen();
	void processEvent(SDL_Event *curEvent);
	
	void initialize(char *filename);
	void setSelect(int mode) {curSelect = mode; }
	void setMode(int mode) {curMode = mode; }
	int getSelect() { int retval = curSelect; curSelect = -1; return retval; }
	void playBeep() { curInfrastructure->PlaySound(FUTURE_BEEP_SOUND);}
	void showMainScreen();
	void showConfigScreen();
	void showJoinScreen();
	void renderAll();
	void release();
	void setRenderKnobVal(bool flag);
	void setMouseKnobVal(bool flag);
	TNetwork *grabNetwork() { return curInfrastructure->getNetwork(); }
	string getIPString() { return JoinText->GetString(JoinText->GetNumStrings() - 1); }
};

#endif
