/***************************************************************************
                          networkscreen.cpp  -  description
                             -------------------
    begin                : Mon Nov 3 2003
    copyright            : (C) 2003 by Chong Jiayi
    email                : jychong@stanford.edu
 ***************************************************************************/


#include "networkscreen.h"

const int MENU_BUTTON_WIDTH = 256;
const int MENU_BUTTON_HEIGHT = 128;

const int SELECTION_MODE = 0;
const int FPS_PLAY_MODE = 1;
const int RTS_PLAY_MODE = 2;
const int MAIN_SELECTION_MODE = 3;
const int NONE_SELECTED = -1;


static void cancelPress(void *obj, int x, int y);
static void startPress(void *obj, int x, int y);
static void factionPress(void *obj, int x, int y);
static void chatCallBack(void *obj, void *data, int size);

networkScreen::networkScreen(TInfrastructure *infrastructure){
	curInfrastructure = infrastructure;
	mode = NONE_SELECTED;
	myScene = NULL;
	myWidgetManager = NULL;
	active = false;
}

networkScreen::~networkScreen(){
	if(myScene != NULL) delete myScene;
	if(myWidgetManager != NULL) delete myWidgetManager;
}

void networkScreen::resetSelection() {
	mode = NONE_SELECTED;
}


void networkScreen::processEvent(SDL_Event *curEvent) {
      switch (curEvent->type) {
        // If a quit event was recieved
        case SDL_QUIT:
          // then we're done and we'll end this program
          break;

        case SDL_MOUSEMOTION:
	 break;
	   
	 case SDL_MOUSEBUTTONDOWN:
	 	myWidgetManager->mouseDownProcess(curEvent->motion.x, curInfrastructure->GetWinHeight() - curEvent->motion.y);
	 break;

	 case SDL_MOUSEBUTTONUP:
	 	myWidgetManager->mouseUpProcess(curEvent->motion.x, curInfrastructure->GetWinHeight() - curEvent->motion.y);
	 break;
	 	 
        case SDL_KEYUP:
	
        break;
	
        case SDL_KEYDOWN:
		char inputChar[2];
		inputChar[0] = curEvent->key.keysym.unicode;
		inputChar[1] = '\0';
		if(inputChar[0] != '\r') networkText->AddInputChar(inputChar);
		else if(inputChar[0] == '\r') { //hit return, so send network message
			cout << "Sending Network Chat Message: " << networkText->GetString(networkText->GetNumStrings() - 1) << endl;
			string inputString = "CHAT: " + networkText->GetString(networkText->GetNumStrings() - 1);
			TNetwork *networkManager = grabNetworkObj();
			if(mode == NETWORK_HOST_MODE) {
				cout << "Server Send:" << endl;
				networkManager->sendTextMessageFromServer((char *)inputString.c_str());
				addText2("");
			}
			else if(mode == NETWORK_JOIN_MODE) {
				cout << "Client Send:" << endl;
				networkManager->sendTextMessageFromClient((char *)inputString.c_str());
				addText((char *)inputString.c_str());
				addText2("");
			}
		}
	
	break;
	
        default:
          break;

        
      }
	
}

void networkScreen::makeActive(bool flag) {
	TNetwork *curNetwork = curInfrastructure->getNetwork();
	active = flag;
	if(active) {
		curNetwork->setNetworkParam(&chatCallBack, (void *)this);
	}
	else {
		curNetwork->setNetworkParam(NULL, NULL);
	}
}


void networkScreen::initialize(char *filename) {
	myScene = new TRTS(curInfrastructure);
//	myScene->LoadSceneFile(filename);
	
	myWidgetManager = new TWidgetManager(curInfrastructure);

	networkText =new TConsole(curInfrastructure->GetWinWidth() * 0.3, curInfrastructure->GetWinHeight() * 0.3, 
						curInfrastructure->GetWinWidth() * 0.7, curInfrastructure->GetWinHeight() * 0.7, curInfrastructure);
	playersText = new TConsole(curInfrastructure->GetWinWidth() * 0.75, curInfrastructure->GetWinHeight() * 0.4, 
						curInfrastructure->GetWinWidth() * 0.93, curInfrastructure->GetWinHeight() * 0.7, curInfrastructure);
	startBtn = new TButton(curInfrastructure);
	cancelBtn = new TButton(curInfrastructure);
	factionBtn = new TButton(curInfrastructure);
	factionLabel = new TLabel(curInfrastructure);
	Logo = new TPicButton(curInfrastructure);
	
	Logo->setTexture("./ClientResource/game_logo.tga");
	Logo->setButtonUpColor(1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0);
	Logo->setButtonDownColor(1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0);
	Logo->setTitle("", 0);
	Logo->setDimensions(curInfrastructure->GetWinWidth() * 0.5 - MENU_BUTTON_WIDTH, 
						curInfrastructure->GetWinHeight() * 0.85 - MENU_BUTTON_HEIGHT * 0.5,
						MENU_BUTTON_WIDTH * 2.0, MENU_BUTTON_HEIGHT * 1.5);
	
	networkText->SetVisibleLines(10);
	networkText->SetBorder(true, 0.0, 0.7, 1.0, 0.7, 0.0, 0.0, 0.1, 1.0);
	networkText->AddString("Mice and Men Multiplayer", 0, true);
	networkText->AddString("", 0, true);

	playersText->SetVisibleLines(10);
	playersText->SetBorder(true, 0.0, 0.7, 1.0, 0.7, 0.0, 0.0, 0.1, 1.0);
	
	
	startBtn->setTitle("Start", 0);
	startBtn->setTextColor(1.0, 1.0, 0.0, 1.0);
	startBtn->setButtonUpColor(1.0, 0.0, 0.0, 0.5, 0.0, 0.0, 1.0);
	startBtn->setButtonDownColor(0.2, 0.0, 1.0, 0.2, 0.0, 0.0, 1.0);
	startBtn->setTextOffset(25, 20);
	startBtn->setDimensions(curInfrastructure->GetWinWidth() * 0.9 - MENU_BUTTON_WIDTH * 0.5, 
						curInfrastructure->GetWinHeight() * 0.2 - MENU_BUTTON_HEIGHT * 0.5,
						MENU_BUTTON_WIDTH * 0.5, MENU_BUTTON_HEIGHT * 0.5);
	startBtn->setWidgetCallObject((void *)this);
	startBtn->setMouseUpFunction(&startPress);
	
	cancelBtn->setTitle("Cancel", 0);
	cancelBtn->setTextColor(1.0, 1.0, 0.0, 1.0);
	cancelBtn->setButtonUpColor(1.0, 0.0, 0.0, 0.5, 0.0, 0.0, 1.0);
	cancelBtn->setButtonDownColor(0.2, 0.0, 1.0, 0.2, 0.0, 0.0, 1.0);
	cancelBtn->setTextOffset(25, 20);
	cancelBtn->setDimensions(curInfrastructure->GetWinWidth() * 0.7 - MENU_BUTTON_WIDTH * 0.5, 
						curInfrastructure->GetWinHeight() * 0.2 - MENU_BUTTON_HEIGHT * 0.5,
						MENU_BUTTON_WIDTH * 0.5, MENU_BUTTON_HEIGHT * 0.5);
	cancelBtn->setWidgetCallObject((void *)this);
	cancelBtn->setMouseUpFunction(&cancelPress);

	factionBtn->setTitle("Faction:", 0);
	factionBtn->setTextColor(1.0, 1.0, 0.0, 1.0);
	factionBtn->setButtonUpColor(1.0, 0.0, 0.0, 0.5, 0.0, 0.0, 1.0);
	factionBtn->setButtonDownColor(0.2, 0.0, 1.0, 0.2, 0.0, 0.0, 1.0);
	factionBtn->setTextOffset(25, 20);
	factionBtn->setDimensions(curInfrastructure->GetWinWidth() * 0.3 - MENU_BUTTON_WIDTH * 0.5, 
						curInfrastructure->GetWinHeight() * 0.2 - MENU_BUTTON_HEIGHT * 0.5,
						MENU_BUTTON_WIDTH * 0.5, MENU_BUTTON_HEIGHT * 0.5);
	factionBtn->setWidgetCallObject((void *)this);
	factionBtn->setMouseUpFunction(&factionPress);
	
	factionLabel->setFont(1, "");
	factionLabel->setColor(1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0);
	factionLabel->setDimensions(curInfrastructure->GetWinWidth() * 0.45 - MENU_BUTTON_WIDTH * 0.5, 
						curInfrastructure->GetWinHeight() * 0.24 - MENU_BUTTON_HEIGHT * 0.5,
						MENU_BUTTON_WIDTH * 0.5, MENU_BUTTON_HEIGHT * 0.5);
	
		
	myWidgetManager->AttachWidget(startBtn);	
	myWidgetManager->AttachWidget(cancelBtn);	
	myWidgetManager->AttachWidget(factionBtn);	
	myWidgetManager->AttachWidget(factionLabel);
	myWidgetManager->AttachWidget(Logo);

	
	myScene->MoveViewerDelta(0.0, 0.0, 0.0, 0.0, 0.0, 0.0f);
	myScene->setMovement(0.7, 0.7, 1.7, 0.05, 0.05);
	myScene->extractBounds();
	myScene->presetObjectSelection();
}


void networkScreen::syncSettings() {
	switch(curFaction) {
		case FPS_PLAY_MODE:
			factionLabel->setFont(1, "HUMAN");
		break;
		
		case RTS_PLAY_MODE:
			factionLabel->setFont(1, "MOUSE");
		break;
	}

	curInfrastructure->loadSkyBox("./SkyBox/cm_galart.tga" , "./SkyBox/cm_galalf.tga" , "./SkyBox/cm_galaft.tga" , 
						"./SkyBox/cm_galabk.tga" , "./SkyBox/cm_galaup.tga" , "./SkyBox/cm_galadn.tga" ); 
}

void networkScreen::renderAll() {
	myScene->mouseInput(1.0, 1.0, false, false);
	myScene->PrepareSceneForCulling();
	myScene->ApplyMd2PhysicsTransform();
	myScene->RecalcSectorPos();
	myScene->ApplyUserInput();
	myScene->ApplyViewerTransform();
	myScene->DoLightingCalc();
	myScene->PortalCull();
	myScene->FrustrumCull();
	myScene->RenderAll();
	myScene->RenderSkyBox(1400.0);
	
	myWidgetManager->renderWidgets();
	networkText->Render();
	glColor4f(1.0, 1.0, 1.0, 1.0);
	playersText->Render();
}



static void cancelPress(void *obj, int x, int y) {
	networkScreen *curMainScreen = (networkScreen *)obj;
	curMainScreen->setMode(MAIN_SELECTION_MODE);
}

static void startPress(void *obj, int x, int y) {
	networkScreen *curMainScreen = (networkScreen *)obj;
	TNetwork *curNetwork = curMainScreen->grabNetworkObj();
	
	curMainScreen->setMode(curMainScreen->getFaction());
	
	for(int i = 0; i < 10; i++) {
		curNetwork->sendStartPacket();
	}
}

static void factionPress(void *obj, int x, int y) {

}

static void chatCallBack(void *obj, void *data, int size) {
	char chatMessage[1024];
	networkScreen *curObj = (networkScreen *)obj;
	TNetwork *curNetwork = curObj->grabNetworkObj();
	memset(chatMessage, '\0', 1024);
	
	curNetwork->getString(data, size, chatMessage);
	string printString = chatMessage;
	if(printString.length() > 0) {
		curObj->addText(printString);
		curObj->addText2("");
	}
	
	//see if it is a start packet
	if(size == 1) {
		if( *(char *)data == START_GAME_PACKET) {
			curObj->setMode(curObj->getFaction());
		}
	}
}
