/***************************************************************************
                          networkscreen.h  -  description
                             -------------------
    begin                : Mon Nov 3 2003
    copyright            : (C) 2003 by Chong Jiayi
    email                : jychong@stanford.edu
 ***************************************************************************/


#ifndef NETWORKSCREEN_H
#define NETWORKSCREEN_H

#include "trts.h"
#include "twidgetmanager.h"
#include "twidgetwindow.h"
#include "tpicbutton.h"
#include "tbutton.h"
#include "tconsole.h"

const int HOST_MODE = 1;
const int JOIN_MODE = 2;
const int NETWORK_HOST_MODE = 4;
const int NETWORK_JOIN_MODE = 5;

/**
  *@author Chong Jiayi
  */

class networkScreen {
protected:
	TPicButton *Logo;
	TRTS *myScene;
	TWidgetManager *myWidgetManager;
	TInfrastructure *curInfrastructure;
	TConsole *networkText;
	TConsole *playersText;
	TButton *cancelBtn;
	TButton *startBtn;
	TButton *factionBtn;
	TLabel *factionLabel;
	int mode;
	int curFaction;
	bool active;
	
public: 
	networkScreen(TInfrastructure *infrastructure);
	void setMode(int setMode) { mode = setMode; if(setMode == NETWORK_JOIN_MODE) startBtn->show(false);}
	void setFaction(int faction) { curFaction = faction; }
	int getFaction() { return curFaction; }
	void syncSettings();
	int getMode() { return mode; }
	void initialize(char *filename);
	~networkScreen();
	void processEvent(SDL_Event *curEvent);
	void resetSelection();
	void renderAll();
	void addText(string text) { networkText->AddString(text, 1, false); }
	void addText2(string text) { networkText->AddString(text, 0, true); }
	void addTextPlayers(string text) { playersText->AddString(text, 0, false); }
	void clearText() { networkText->Clear(); playersText->Clear(); }
	void makeActive(bool flag);
	TNetwork *grabNetworkObj() { return curInfrastructure->getNetwork(); }
};

#endif
