/***************************************************************************
                          rtsclient.cpp  -  description
                             -------------------
    begin                : Mon Aug 25 2003
    copyright            : (C) 2003 by Chong Jiayi
    email                : jychong@stanford.edu
 ***************************************************************************/


#include "rtsclient.h"

const int MENU_BUTTON_WIDTH = 256;
const int MENU_BUTTON_HEIGHT = 128;

RTSClient::RTSClient(TInfrastructure *infrastructure){
	curInfrastructure = infrastructure;
	myScene = NULL;
	myConsole = NULL;
	myWidgetManager = NULL;
	myWidgetManager2 = NULL;
	ResourceWords = NULL;
	showConsole = false;
	leftDown = false;
	rightDown = false;
	done = false;
	callBackFunc = NULL;
	callBackObj = NULL;
	mode = NORMAL_MODE;
	once = false;
}

RTSClient::~RTSClient(){
}

void RTSClient::initialize(char *sceneFile, char *weaponFile, char *itemsFile) {
	myScene = new TRTS(curInfrastructure);
	myConsole = new TConsole(0, 0.6 * curInfrastructure->GetWinHeight(), curInfrastructure->GetWinWidth(), curInfrastructure->GetWinHeight(), curInfrastructure);
	myScene->SetCallBack(callBackObj, callBackFunc);	
	
	myScene->LoadSceneFile(sceneFile);
	myScene->LoadWeaponsFromFile(weaponFile);
	myScene->LoadItemsFile(itemsFile);
	
	myConsole->AddString("Welcome to the Troodon Engine", 0, false);
	myConsole->AddString("Current Build: 001", 1, false);
	myConsole->AddString("", 0, true);
	myConsole->SetBorder(true, 0.5, 0.5, 0.5, 0.5, 0.0, 0.0, 0.0, 0.5);
	myConsole->SetVisibleLines(6);
	
	myWidgetManager = new TWidgetManager(curInfrastructure);
	myWidgetManager2 = new TWidgetManager(curInfrastructure);
	ResourceWords = new TButton(curInfrastructure);
	myScene->loadRTStoolBar("./toolbarRTS.des", myWidgetManager);
	myScene->LoadUnitInfoFile("units.des");
//	myScene->addMainRat();

	ResourceWords->setDimensions(curInfrastructure->GetWinWidth() - 150, 10, 140, 70);
	ResourceWords->setButtonUpColor(0.0, 0.0, 0.0, 1.0, 1.0, 0.1, 1.0);
	ResourceWords->setButtonDownColor(0.0, 0.0, 0.0, 1.0, 0.0, 0.1, 1.0);
	ResourceWords->setTextColor(1.0, 1.0, 1.0, 1.0);
	ResourceWords->setTitle("Energy:", 0);
	ResourceWords->setTextOffset(15, 25);
	
	mousewin_Pic = new TPicButton(curInfrastructure);
	humanwin_Pic = new TPicButton(curInfrastructure);
	
	mousewin_Pic->setTexture("./ClientResource/mouse_wins.tga");
	mousewin_Pic->setButtonUpColor(1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0);
	mousewin_Pic->setButtonDownColor(1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0);
	mousewin_Pic->setTitle("", 0);
	mousewin_Pic->setDimensions(curInfrastructure->GetWinWidth() * 0.5 - MENU_BUTTON_WIDTH, 
						curInfrastructure->GetWinHeight() * 0.85 - MENU_BUTTON_HEIGHT,
						MENU_BUTTON_WIDTH * 2.0, MENU_BUTTON_HEIGHT * 1.5);

	humanwin_Pic->setTexture("./ClientResource/human_wins.tga");
	humanwin_Pic->setButtonUpColor(1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0);
	humanwin_Pic->setButtonDownColor(1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0);
	humanwin_Pic->setTitle("", 0);
	humanwin_Pic->setDimensions(curInfrastructure->GetWinWidth() * 0.5 - MENU_BUTTON_WIDTH, 
						curInfrastructure->GetWinHeight() * 0.85 - MENU_BUTTON_HEIGHT,
						MENU_BUTTON_WIDTH * 2.0, MENU_BUTTON_HEIGHT * 1.5);
							
	myWidgetManager->AttachWidget(ResourceWords);
	
	SDL_EnableUNICODE(1);

	for(int i = 0; i < myScene->GetObjectNum(); i++) {
	TObject *curObject = myScene->GetObject(i);
		if(curObject->GetType() == MD2_TYPE) {
			TMd2 *curMd2 = (TMd2 *)curObject;
			curMd2->SetCurrentAnimation(0, 5);
		}
	}

	SDL_WarpMouse(0, 0);
	myScene->MoveViewerDelta(0.0, 0.0, 0.0, 0.0, 0.0, 0.0f);
	GameConfigKeys curConfig = curInfrastructure->GetConfigKeys();
	myScene->setKeyBindRTS(SDLK_LEFT, SDLK_RIGHT);
	myScene->MoveViewerDelta(0.0, 0.0, 0.0, 0.0, 0.0, 0.0f);
	myScene->setKeyBind(SDLK_a, SDLK_d, SDLK_w, SDLK_s, SDLK_SPACE);
	myScene->setMovement(curConfig.moveXVel + curConfig.moveXrot * 1.3, curConfig.moveYVel + curConfig.moveYrot * 1.3, curConfig.moveJVel, curConfig.moveXrot, curConfig.moveYrot);
	myScene->SetRenderLevel(curConfig.renderLevel);
	myScene->extractBounds();
	myScene->presetObjectSelection();
	SDL_WarpMouse(curInfrastructure->GetWinWidth() * 0.5, curInfrastructure->GetWinHeight() * 0.5);
	
	if(mode == SERVER_RTS_MODE || mode == SERVER_FPS_MODE || mode == CLIENT_RTS_MODE || mode == CLIENT_FPS_MODE) {
		myScene->setMultiPlayerMode(mode);
		myScene->prepareMultiplayerMode();
	}
	
	firstDrawFrame = true;	
}

void RTSClient::release() {
	myScene->endMultiplayerMode();
	if(myScene != NULL) delete myScene;
	if(myConsole != NULL) delete myConsole;
	if(myWidgetManager != NULL) delete myWidgetManager;
	if(myWidgetManager2 != NULL) delete myWidgetManager2;
}

void RTSClient::renderAll() {
	if(mode == CLIENT_RTS_MODE || mode == CLIENT_FPS_MODE) { myScene->syncToNetwork(); }
	else if(mode == SERVER_RTS_MODE) { myScene->RTSserverProcessFPSinputFrame(); }

	if(myScene->getGameEnd()) {
		if((myScene->getGameEnd() == 1) && !once) {
			myWidgetManager2->AttachWidget(mousewin_Pic);
			mousewin_Pic->show(true);
		}
		else if((myScene->getGameEnd() == 2) && ! once) {
			myWidgetManager2->AttachWidget(humanwin_Pic);
			humanwin_Pic->show(true);
		}
		
		once = true;
		
		myScene->renderEndGameSequence();
		myWidgetManager2->renderWidgets();
		return;
	}
	
//	myScene->PrepareSceneForCulling();       
	myScene->PrepareSceneForPortalCulling();

	myScene->RestoreSceneObjectsTransform();
	myScene->ApplyMd2PhysicsTransform();
	myScene->RecalcSectorPos();
	myScene->ApplyRTSUserInput();
	myScene->TryMoveRTSViewerPhysics();
	myScene->simulateGameObjects();
	myScene->simulateAmmo();
	myScene->simulateItemPickUp();

	myScene->ApplyViewerTransform();
	myScene->DoLightingCalc();
	myScene->PortalCull();
	myScene->FrustrumCull();
	
	for(int i = 0; i < myScene->GetObjectNum(); i++) {
		if(!myScene->GetObjectVisible(i) || firstDrawFrame) { firstDrawFrame = false; continue; }
		TObject *curObject = myScene->GetObject(i);
		if(curObject->GetType() == MD2_TYPE) {
			TMd2 *curMd2 = (TMd2 *)curObject;
			curMd2->PlayAnimation();
		}
	}
	
	myScene->AnimateItems();
	myScene->RenderAll();
	myScene->renderAmmo();
	
	myScene->GlowRender();

	myScene->incrementFrame();
	
	if(showConsole) {
		glColor4f(1.0, 1.0, 1.0, 1.0);
		myConsole->Render();
	}
	
	
	//render widgets
	char printBuffer[500];
	
	sprintf(printBuffer, "Energy: %d\n", myScene->getResource());
	ResourceWords->setTitle(printBuffer, 0);
	
	myWidgetManager->renderWidgets();
	glColor4f(1.0, 1.0, 1.0, 1.0);
	myScene->renderStatusText();
	myScene->renderSelection();
	myScene->renderStatusBars();
	myScene->renderRTSmap();
	
	if(mode == SERVER_RTS_MODE)
			myScene->sendServerRTSinfo();

}

void RTSClient::processEvent(SDL_Event *curEvent) {
      switch (curEvent->type) {
        // If a quit event was recieved
        case SDL_QUIT:
          // then we're done and we'll end this program
          done = true;
          break;

        case SDL_MOUSEMOTION:
		if(!myScene->canStart()) return;
		if(mode == CLIENT_RTS_MODE || mode == NORMAL_MODE || mode == SERVER_RTS_MODE) myScene->mouseRTSInput(1.0, 1.0, curEvent->motion.x, curEvent->motion.y, curInfrastructure->GetWinWidth(), curInfrastructure->GetWinHeight(), leftDown, rightDown);
	 break;
	   
	 case SDL_MOUSEBUTTONDOWN:
		if(!myScene->canStart()) return;
	 	if(curEvent->button.button == SDL_BUTTON_LEFT) leftDown = true;
	 	if(curEvent->button.button == SDL_BUTTON_RIGHT) rightDown = true;
		if(leftDown) myWidgetManager->mouseDownProcess(curEvent->motion.x,curInfrastructure->GetWinHeight() - curEvent->motion.y);
		if(mode == CLIENT_RTS_MODE || mode == NORMAL_MODE || mode == SERVER_RTS_MODE) myScene->mouseRTSInput(1.0, 1.0, curEvent->motion.x, curEvent->motion.y, curInfrastructure->GetWinWidth(), curInfrastructure->GetWinHeight(), leftDown, rightDown);
	 break;

	 case SDL_MOUSEBUTTONUP:
		if(!myScene->canStart()) return;
	 	if(curEvent->button.button == SDL_BUTTON_LEFT) leftDown = false;
	 	if(curEvent->button.button == SDL_BUTTON_RIGHT) rightDown = false;
		
		if(!leftDown) myWidgetManager->mouseUpProcess(curEvent->motion.x,curInfrastructure->GetWinHeight() - curEvent->motion.y);
		if(mode == CLIENT_RTS_MODE || mode == NORMAL_MODE || mode == SERVER_RTS_MODE) myScene->mouseRTSInput(1.0, 1.0, curEvent->motion.x, curEvent->motion.y, curInfrastructure->GetWinWidth(), curInfrastructure->GetWinHeight(), leftDown, rightDown);
	 break;
	 	 
        case SDL_KEYDOWN:
			if(showConsole == false) {
          switch( curEvent->key.keysym.sym ) {
				
				case SDLK_BACKQUOTE:
					showConsole = !showConsole;
				break;
				
				default:
					if(!myScene->canStart()) return;
					if(mode == CLIENT_RTS_MODE || mode == NORMAL_MODE || mode == SERVER_RTS_MODE) myScene->userRTSinput(curEvent->key.keysym.sym);
					myScene->clientFPSkeyDown(curEvent->key.keysym.sym);
				break;
			 }
		}
		else {
          switch( curEvent->key.keysym.sym ) {
				case SDLK_BACKQUOTE:
				showConsole = !showConsole;
				break;

				case SDLK_LSHIFT:
				break;

				case SDLK_RSHIFT:
				break;

				default:
				char inputChar[2];
				inputChar[0] = curEvent->key.keysym.unicode;
				inputChar[1] = '\0';
				int retval = myConsole->AddInputChar(inputChar);

				if(retval != NO_STRING) {
					if(myConsole->GetString(retval) == "quit") {done = true;}
					else if(myConsole->GetString(retval) == "set renderlevel 0") {myScene->SetRenderLevel(RENDER_LEVEL0);}
					else if(myConsole->GetString(retval) == "set renderlevel 1") {myScene->SetRenderLevel(RENDER_LEVEL1);}
					else if(myConsole->GetString(retval) == "set renderlevel 2") {myScene->SetRenderLevel(RENDER_LEVEL2);}
					else if(myConsole->GetString(retval) == "blur 0") {myScene->SetBlurSwitch(false);}
					else if(myConsole->GetString(retval) == "blur 1") {myScene->SetBlurSwitch(true);}
					else {myConsole->AddString("Invalid Command", 1, false); myConsole->AddString("", 0, true);}
				}
		
				break;
			  }
		}
		
          break;
        case SDL_KEYUP:
          switch( curEvent->key.keysym.sym ) {
				
				default:
					if(!myScene->canStart()) return;
					myScene->userRTSinputStop();
				break;
	  }
	
        break;

        default:
          break;

        
      }
}


