/***************************************************************************
                          selectclient.cpp  -  description
                             -------------------
    begin                : Tue Aug 26 2003
    copyright            : (C) 2003 by Chong Jiayi
    email                : jychong@stanford.edu
 ***************************************************************************/


#include "selectclient.h"
static void GoButtonPress(void *obj, int x, int y);
static void MouseButtonPress(void *obj, int x, int y);
static void ManButtonPress(void *obj, int x, int y);

selectClient::selectClient(TInfrastructure *infrastructure){
	curInfrastructure = infrastructure;
	myScene = NULL;
	myWidgetManager = NULL;
	rotY1 = 0.0;
	rotY2 = -80.0;
	done = false;
	changeSelect = -1;
	finalSelect = -1;
}

selectClient::~selectClient(){
}

void selectClient::initialize(char *filename) {
	myScene = new TRTS(curInfrastructure);
	
	myWidgetManager = new TWidgetManager(curInfrastructure);
	
	myScene->LoadSceneFile(filename);
	
	MouseButton = new TButton(curInfrastructure);
	ManButton = new TButton(curInfrastructure);
	GoButton = new TButton(curInfrastructure);
	SelectedButton1 = new TButton(curInfrastructure);
	SelectedButton2 = new TButton(curInfrastructure);
	LoadWords = new TButton(curInfrastructure);
	
	MouseButton->setDimensions(30, 30, 180, 70);
	MouseButton->setButtonUpColor(0.0, 0.0, 0.0, 0.0, 0.4, 0.8, 1.0);
	MouseButton->setButtonDownColor(0.0, 0.0, 0.0, 1.0, 0.0, 0.1, 1.0);
	MouseButton->setTextColor(1.0, 1.0, 1.0, 1.0);
	MouseButton->setTitle("Select Mouse", 0);
	MouseButton->setTextOffset(20, 25);
	MouseButton->setMouseUpFunction(&MouseButtonPress);
	MouseButton->setWidgetCallObject((void *)this);
	
	ManButton->setDimensions(480, 30, 180, 70);
	ManButton->setButtonUpColor(0.0, 0.0, 0.0, 0.0, 0.4, 0.8, 1.0);
	ManButton->setButtonDownColor(0.0, 0.0, 0.0, 1.0, 0.0, 0.1, 1.0);
	ManButton->setTextColor(1.0, 1.0, 1.0, 1.0);
	ManButton->setTitle("Select Human", 0);
	ManButton->setTextOffset(20, 25);
	ManButton->setMouseUpFunction(&ManButtonPress);
	ManButton->setWidgetCallObject((void *)this);
	
	GoButton->setDimensions(680, 10, 100, 100);
	GoButton->setButtonUpColor(0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0);
	GoButton->setButtonDownColor(0.0, 0.0, 0.0, 1.0, 0.0, 0.1, 1.0);
	GoButton->setTextColor(1.0, 1.0, 1.0, 1.0);
	GoButton->setTitle("GO!", 0);
	GoButton->setTextOffset(30, 40);
	GoButton->setMouseUpFunction(&GoButtonPress);
	GoButton->setWidgetCallObject((void *)this);
	
	SelectedButton1->setDimensions(260, 30, 180, 70);
	SelectedButton1->setButtonUpColor(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
	SelectedButton1->setButtonDownColor(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
	SelectedButton1->setTextColor(1.0, 1.0, 1.0, 1.0);
	SelectedButton1->setTitle("", 0);
	SelectedButton1->setTextOffset(20, 25);
	SelectedButton1->show(false);
	
	SelectedButton2->setDimensions(260, 30, 180, 70);
	SelectedButton2->setButtonUpColor(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
	SelectedButton2->setButtonDownColor(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
	SelectedButton2->setTextColor(1.0, 1.0, 1.0, 1.0);
	SelectedButton2->setTitle("", 0);
	SelectedButton2->setTextOffset(20, 25);
	SelectedButton2->show(false);
	
	LoadWords->setDimensions(260, 330, 180, 70);
	LoadWords->setButtonUpColor(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
	LoadWords->setButtonDownColor(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
	LoadWords->setTextColor(1.0, 1.0, 1.0, 1.0);
	LoadWords->setTitle("", 0);
	LoadWords->setTextOffset(20, 25);
	
	myWidgetManager->AttachWidget(ManButton);
	myWidgetManager->AttachWidget(MouseButton);
	myWidgetManager->AttachWidget(SelectedButton1);
	myWidgetManager->AttachWidget(SelectedButton2);
	myWidgetManager->AttachWidget(GoButton);
	myWidgetManager->AttachWidget(LoadWords);
	
	SDL_EnableUNICODE(1);

	for(int i = 0; i < myScene->GetObjectNum(); i++) {
	TObject *curObject = myScene->GetObject(i);
		if(curObject->GetType() == MD2_TYPE) {
			TMd2 *curMd2 = (TMd2 *)curObject;
			curMd2->SetCurrentAnimation(1, 5);
		}
	}
	
	myScene->MoveViewerDelta(0.0, 0.0, 0.0, 0.0, 0.0, 0.0f);
	myScene->setMovement(0.7, 0.7, 1.7, 0.7, 0.7);
	myScene->extractBounds();
	myScene->presetObjectSelection();
	SDL_WarpMouse(curInfrastructure->GetWinWidth() * 0.5, curInfrastructure->GetWinHeight() * 0.5);
}

void selectClient::release() {
	if(myScene != NULL) delete myScene;
	if(myWidgetManager != NULL) delete myWidgetManager;
}

void selectClient::renderAll() {
	float startX = -15.0;
	int cnt = 0;
	for(int i = 0; i < myScene->GetObjectNum(); i++) {
		TObject *curObject = myScene->GetObject(i);
		if(curObject->GetType() == MD2_TYPE) {
			TMd2 *curMd2 = (TMd2 *)curObject;
			curMd2->PlayAnimation();
			
			curMd2->PrepareTransform();
				glTranslatef(startX + i * (-startX * 2.0), 0.0, -40);
				if(i == 0) glRotatef(rotY1, 0.0, 1.0, 0.0);
				else glRotatef(rotY2, 0.0, 1.0, 0.0);
				glScalef(0.8, 0.8, 0.8);
			curMd2->EndTransform(); 
			cnt++;
		}
		
		if(cnt > 1) break;
	}
	
	if(changeSelect == MOUSE_SELECTED) rotY1 = rotY1 + 1.0;
	if(changeSelect == HUMAN_SELECTED) rotY2 = rotY2 + 1.0;
	
	myScene->PrepareSceneForCulling();       

//	myScene->RestoreSceneObjectsTransform();
	myScene->RecalcSectorPos();

	myScene->ApplyViewerTransform();
	myScene->DoLightingCalc();
	myScene->PortalCull();
	myScene->FrustrumCull();
	myScene->RenderAll();
	
	myWidgetManager->renderWidgets();
}

void selectClient::processEvent(SDL_Event *curEvent) {
      switch (curEvent->type) {
        // If a quit event was recieved
        case SDL_QUIT:
          // then we're done and we'll end this program
          done = true;
          break;

        case SDL_MOUSEMOTION:
	 break;
	   
	 case SDL_MOUSEBUTTONDOWN:
	 	myWidgetManager->mouseDownProcess(curEvent->motion.x, curInfrastructure->GetWinHeight() - curEvent->motion.y);
	 break;

	 case SDL_MOUSEBUTTONUP:
	 	myWidgetManager->mouseUpProcess(curEvent->motion.x, curInfrastructure->GetWinHeight() - curEvent->motion.y);
	 break;
	 	 
        case SDL_KEYUP:
	
        break;

        default:
          break;

        
      }
	
}

static void GoButtonPress(void *obj, int x, int y) {
	selectClient *curClient = (selectClient *)obj;
	curClient->finalizeSelect();
}

static void MouseButtonPress(void *obj, int x, int y) {
	selectClient *curClient = (selectClient *)obj;
	
	(curClient->getSelect1())->setTitle("MICE-CLAN SELECTED", 1);
	(curClient->getSelect1())->show(true);
	(curClient->getSelect2())->show(false);
	
	curClient->setChangeSelect(MOUSE_SELECTED);
	
}

static void ManButtonPress(void *obj, int x, int y) {
	selectClient *curClient = (selectClient *)obj;
	
	(curClient->getSelect2())->setTitle("HUMAN SELECTED", 1);
	(curClient->getSelect2())->show(true);
	(curClient->getSelect1())->show(false);
	
	curClient->setChangeSelect(HUMAN_SELECTED);
}


