/***************************************************************************
                          tinfrastructure.h  -  description
                             -------------------
    begin                : Sun Dec 15 2002
    copyright            : (C) 2002 by Chong Jiayi
    email                : jychong@stanford.edu
 ***************************************************************************/


#ifndef TINFRASTRUCTURE_H
#define TINFRASTRUCTURE_H


/**
  *@author Chong Jiayi
  */
//#define GL_NV_register_combiner 1
//#define GL_GLEXT_PROTOTYPES 1

//#include <windows.h>

#include <string>
#include <vector>
#include <string.h>

#ifdef _WINDOWS_
#include <slist>
#endif

#ifndef _WINDOWS_
#include <slist.h>
#endif

#include <list>
#include <iostream>
#include <fstream.h>
#include <string.h>
#include "extgl.h"
#include <GL/gl.h>
//#include <GL/glu.h>
//#include <GL/glext.h>
#include <SDL/SDL.h>
#include <SDL/SDL_thread.h>
#include <SDL/SDL_mixer.h>
#include "tga.h"
#include "vectorutils.h"
#include "tnetwork.h"


using namespace std;


const int UNDEFINED = -1;
const int ARRAY_STRIDE = 23 * sizeof(GLfloat);
const int ARRAY_STRIDE2 = 9 * sizeof(GLfloat);
const int NORMAL_SET = 0;
const int ITALIC_SET = 1;

const int SELECT_NO = 0;
const int SELECT_ONLY = 1;
const int SELECT_MOVE = 2;

const int SKYBOX_LEFT = 0;
const int SKYBOX_RIGHT = 1;
const int SKYBOX_FRONT = 2;
const int SKYBOX_BACK = 3;
const int SKYBOX_UP = 4;
const int SKYBOX_DOWN = 5;

const int NUM_WINDOW_TEXTURES = 10;
const int WINDOW_TEXTURE_SIZE = 256;

const float HUMAN_MOVE_X = 1.4;
const float HUMAN_MOVE_Y = 1.4;
const float HUMAN_MOVE_J = 1.7;

const int MAX_DEAD_FRAME = 130;

const int FUTURE_BEEP_SOUND = 0;
const int MICE_SOUND = 1;
const int MICE_SQUEAK_SOUND = 2;
const int ROBOT_ARM_SOUND = 3;
const int PIGEON_SOUND = 4;
const int HALLELUJAH_SOUND = 5;
const int EXPLODE_SOUND = 6;
const int LIQUID_BLAST_SOUND = 7;
const int OW_SOUND = 8;
const int LUGER_SOUND = 9;
const int SMASH_SOUND = 10;
const int BOTTLE_ROCKET_SOUND = 11;
const int CANNON_SOUND = 12;
const int GROAN_SOUND = 13;
const int HISS_SOUND = 14;
const int UGH_SOUND = 15;
const int LAUGH_CARTOON_SOUND = 16;
const int DRUMS_SOUND = 17;
const int CARTOON_CHARGE_SOUND = 4;
const int CLICKON_SOUND = 19;
const int UFO_SOUND = 20;
const int SHOTGUN_SOUND = 21;

const int TUNE1_MUSIC = 0;
const int TUNE2_MUSIC = 1;

typedef struct {
  Vector position;
  Vector tangentSpaceLightVector;
  Vector tangentSpaceHalfAngleVector;
  GLfloat s, t;
  //used internally at runtime
  Vector lightPos;
  Vector eyePos;
  Vector primaryVec;
  Vector secondaryVec;
} Vertex;

typedef struct {
  Vector position;
  GLfloat s, t;
} SmallVertex;

typedef struct {
  short neighbourIndex;
  Plane plane;
  short visible;
} Connective;

typedef struct {
  Vector tangent;
  Vector binormal;
  Vector normal;
} OrthoNormalBasis;


typedef struct {
	int decIndex;
	int bumpIndex;
	float scale;
	string decalFilename;
	string bumpFilename;
} TextureInfo;

typedef struct {
	GLuint index;
	int verticeNum;
} BufferInfo;

const int MAX_WEAPON_NUM = 10;
const int MAX_SWITCH_FRAME = 20;


struct GamerWeapon {
	int ammo;
	int damage;
	int type;
	int state;
};

struct GamerAmmo {
	int type;
	int frame;
	int owner;
	int ID;
	vector<int> colObjIndex;
	Vector loc;
	Vector prevLoc;
	Vector vel;
	Vector rotVec;
	Vector startVec;
};

struct GamerAction {
	int type;
	void *target;
	int frame;
	Vector dst;
};

struct GamerPacket {
	int selectLevel;
	int health;
	int type;
	int team;
	int resource;
	int deadFrameCnt;
	GamerWeapon weapons[MAX_WEAPON_NUM];
	int weaponNum;
	int weaponSelect;
	int oldweaponSelect;
	int weaponSwitchFrame;
	list<GamerAction> actionList;
	int state;
	GamerAction goal;
	list<Vector> waypointList;
};

struct GameType {
	string name;
	string md2_Filename;
	int type;
	int attackType;
	int damage;
	int buildtime;
	int health;
	float transVel;
	float rotVel;
	float range;
	int cost;
	//used internally
	int miscBuildTime;
	float size;
};

struct GameConfigKeys {
	char moveFront;
	char moveBack;
	char moveLeft;
	char moveRight;
	char moveJump;
	float moveXVel;
	float moveYVel;
	float moveJVel;
	float moveXrot;
	float moveYrot;
	int renderLevel;
};

const int SCORE_CAP = 5;

struct ScoreReport {
	int side1_score;
	int side2_score;
};

#include "tparticle.h"

/*** NORMAL MAP TEXTURE CONSTRUCTION ***/

/* Structure to encode a normal like an 8-bit unsigned BGRA vector. */
typedef struct {
  GLubyte nz, ny, nx;
  GLubyte mag;
} Normal;

const unsigned int TO_NORMALIZE_CUBE_MAP = 1;
const int CUBE_SIZE = 32;

extern "C" gliGenericImage *readTGAImage(char *filename);


class TInfrastructure {



private:
	int width;
	int height;
	int posX;
	int posY;
	char * title;
	int attenuateTexture2D;
	int attenuateTexture1D;
	int lensflareTexture[4];
	int textTexture;
	int cubeMapSelect;
	unsigned int timerVal, timerVal2;
	GLuint skyboxTexture[6];
	GLuint CubeMap32Texture[6];
	GLuint CubeMap64Texture[6];
	GLuint CubeMap128Texture[6];
	GLuint CubeMap256Texture[6];
	GLuint CubeMap32Ref;
	GLuint CubeMap64Ref;
	GLuint CubeMap128Ref;
	GLuint CubeMap256Ref;
	GLuint textRef;
	GameConfigKeys configKeys;
	TParticle *curParticle;
	int loadSingleSkyTexture(char *filename);
	void getCubeVector(int i, int cubesize, int x, int y, Vector *curVec);
	Normal * convertHeightFieldToNormalMap(GLubyte *pixels, int w, int h, int wr, int hr, float scale);
	void convertHeightFieldAndLoadNormalMapTexture(GLubyte *pixels, int w, int h, int wr, int hr, float scale);
	Normal * downSampleNormalMap(Normal *old, int w2, int h2, int width, int height);
	void makeNormalizeVectorCubeMap(int size);
	gliGenericImage * readImage(char *filename);
	void loadTextureDecalImage(char *filename, int mipmaps);
	void loadTextureNormalMap(char *filename, float scale);
	vector<TextureInfo> textureList;
	vector<TextureInfo> widgetTextureList;
	vector<BufferInfo> bufferList;
	vector<GLuint> windowTexture;
	vector<GLuint> vertexProgramList;
	unsigned char *readShaderFile(const char* filename, int *fileSize);
	void BuildFont();
	void createWindowTextures(int num, int width, int height);
	void createCubeMapTextures();
	void createCubeMapTextureSet(int size, int ID);

protected:
	TNetwork *curNetworkObj;
	vector<Mix_Chunk *> soundList;
	vector<Mix_Music *> musicList;
		
public: 
	TInfrastructure(int Width, int Height, int PosX, int PosY, char * Title);

	~TInfrastructure();
	int CreateGL(bool fullScreen);
	int GetAtten2D() { return attenuateTexture2D; }
	int GetAtten1D() { return attenuateTexture1D; }
	int GetWinWidth() { return width; }
	int GetWinHeight() { return height; }
	int GetLensFlareTexture(int index) { return lensflareTexture[index]; }
	int GetRefract_NV1_VP() { return vertexProgramList[0]; }
	int GetRefract_NV2_VP() { return vertexProgramList[1]; }
	int GetCurrentCubeMap();
	void iniProjectionMatrix();
	void iniCustomProjectionMatrix(float fov, int curWidth, int curHeight);
	void ReSizeGLScene(GLsizei width, GLsizei height);
	void KillGLWindow();
	void PrepareStencilShadowing();
	void EndStencilShadowing();
	void RenderShadowRect(GLfloat r, GLfloat g, GLfloat b, GLfloat alpha) ;
	void PrepareShadowFinalPass();
	void screenPrint(int x, int y, char *curString, int fontSet, GLfloat scaleX, GLfloat scaleY);
	void loadSkyBox(char *leftTexture, char *rightTexture, char *frontTexture, char *backTexture,
				char *upTexture, char *downTexture);
	void copyScreenToBuffer(int index);
	void setCubeMapRenderSize(int sizeFactor) { cubeMapSelect = sizeFactor; }
	void copyScreenToCubeMap(GLenum target);
	void timerDelay(int delay);
	bool timerDelay2(int delay);
	GLuint getWindowTexture(int num);
	GLuint getSkyBoxTexture(int index) { return skyboxTexture[index]; }
	TextureInfo *LoadTexture(char *decalFile, int mipmaps, char *bumpFile, float scale);
	TextureInfo *LoadWidgetTexture(char *decalFile);
	BufferInfo CreateBuffer(int numVertices);
	GLuint GetCubeMapName() { return TO_NORMALIZE_CUBE_MAP;}
	TParticle *GetParticle() { return curParticle; }
	int LoadVertexProgramNV(char *filename);
	void LoadConfigKeys(char *filename);
	GameConfigKeys GetConfigKeys() { return configKeys; }
	void SetConfigKeys(GameConfigKeys newKeys) {configKeys = newKeys; }
	void SaveConfigKeys(char *filename);
	int LoadMusic(char *filename);
	void PlayMusic(int index);
	int LoadSound(char *filename);
	int LoadSoundFileList(char *filename);
	void PlaySound(int index);
	TNetwork *getNetwork() { return curNetworkObj; }
};

#endif

