/***************************************************************************
                          tlevelgen.h  -  description
                             -------------------
    begin                : Tue Jul 8 2003
    copyright            : (C) 2003 by Chong Jiayi
    email                : jychong@stanford.edu
 ***************************************************************************/


#ifndef TLEVELGEN_H
#define TLEVELGEN_H

#include "tscene.h"
#include "tinfrastructure.h"

const int LEFT_SIDE = -1;
const int RIGHT_SIDE = -2;
const int FRONT_SIDE = -3;
const int BACK_SIDE = -4;

const int NO_CEILING = 0;
const int NO_CEILING_NO_END_WALLS = 1;
const int NO_CEILING_REFLECT = 2;
const int WITH_CEILING = 3;
const int WITH_CEILING_REFLECT = 4;

/**
  *@author Chong Jiayi
  */
  
struct BasicRoom {
	Vector bound1;
	Vector bound2;
	Vector lightPos;
	Vector eyePos;
	float lightR, lightG, lightB, brightness, alphaVal;
	int type;
	string groundTexture;
	string wallTexture;
	string ceilingTexture;
};

struct texturePacket {
	string name;
	string decalTexture;
	string bumpTexture;
	bool shadow;
	bool diffuse;
	bool specular;
	bool attenuate;
	float bumpScale;
	float tileFactor;
};

struct LinkRoom {
	int index1;
	int index2;
	float width;
	float height;
	float offsetRatio;
	int side;
	Vector bnd1;
	Vector bnd2;
};

struct SectionPacket {
	Vector Bnd1;
	Vector Bnd2;
	bool active;
};

class TLevelGen {
protected:
	TScene *curScene;
	vector <BasicRoom> BasicRooms;
	vector <LinkRoom> LinkList;
	vector <texturePacket> texPackList;
	vector <string> md2StringArray;
	vector <string> lightStringArray;
	
	vector<int> GetNumLinkedLeft(int index);
	vector<int> GetNumLinkedRight(int index);
	vector<int> GetNumLinkedFront(int index);
	vector<int> GetNumLinkedBack(int index);
	vector<SectionPacket> GetSectionPacketLeft(vector<int> sectionList, SectionPacket initial);
	vector<SectionPacket> GetSectionPacketRight(vector<int> sectionList, SectionPacket initial);
	vector<SectionPacket> GetSectionPacketFront(vector<int> sectionList, SectionPacket initial);
	vector<SectionPacket> GetSectionPacketBack(vector<int> sectionList, SectionPacket initial);
	
public: 
	TLevelGen(TScene *theScene);
	~TLevelGen();
	
	int AddRoom(float x1, float y1, float z1, float x2, float y2, float z2, int type, string groundTexture, string wallTexture, 
				string ceilingTexture, float alphaVal, float brightness, float lightR, float lightG, float lightB);
	void GenerateDefaultTextures();
	void LinkRooms(int index1, int index2, float width, float height, int side, float offsetRatio);
	int LoadTextureList(char *filename);
	int LoadRoomGen(char *filename);
	void AddTexturePacket(string name, string decalTexture, string bumpTexture, bool shadow, bool diffuse, bool specular, bool attenuate,
					float bumpScale, float tileFactor);
	texturePacket GetTexPacket(string name);
	int GenerateLevel(char *filename);
};

#endif
