/***************************************************************************
                          tmd2.cpp  -   loads an MD2 file. Also does animation
                             -------------------
                          with reference to :
                           Ben Humphrey (DigiBen), Game Programmer
                           DigiBen@GameTutorials.com
                           Co-Web Host of www.GameTutorials.com (ONLY for md2 file loading)
    begin                : Thu Dec 26 2002
    copyright            : (C) 2002 by Chong Jiayi
    email                : jychong@stanford.edu
 ***************************************************************************/


#include "tmd2.h"

#define NUMVERTEXNORMALS 162

float md2VertexNormals[NUMVERTEXNORMALS][3] = {
  {-0.525731f, 0.000000f, 0.850651f},
  {-0.442863f, 0.238856f, 0.864188f},
  {-0.295242f, 0.000000f, 0.955423f},
  {-0.309017f, 0.500000f, 0.809017f},
  {-0.162460f, 0.262866f, 0.951056f},
  {0.000000f, 0.000000f, 1.000000f},
  {0.000000f, 0.850651f, 0.525731f},
  {-0.147621f, 0.716567f, 0.681718f},
  {0.147621f, 0.716567f, 0.681718f},
  {0.000000f, 0.525731f, 0.850651f},
  {0.309017f, 0.500000f, 0.809017f},
  {0.525731f, 0.000000f, 0.850651f},
  {0.295242f, 0.000000f, 0.955423f},
  {0.442863f, 0.238856f, 0.864188f},
  {0.162460f, 0.262866f, 0.951056f},
  {-0.681718f, 0.147621f, 0.716567f},
  {-0.809017f, 0.309017f, 0.500000f},
  {-0.587785f, 0.425325f, 0.688191f},
  {-0.850651f, 0.525731f, 0.000000f},
  {-0.864188f, 0.442863f, 0.238856f},
  {-0.716567f, 0.681718f, 0.147621f},
  {-0.688191f, 0.587785f, 0.425325f},
  {-0.500000f, 0.809017f, 0.309017f},
  {-0.238856f, 0.864188f, 0.442863f},
  {-0.425325f, 0.688191f, 0.587785f},
  {-0.716567f, 0.681718f, -0.147621f},
  {-0.500000f, 0.809017f, -0.309017f},
  {-0.525731f, 0.850651f, 0.000000f},
  {0.000000f, 0.850651f, -0.525731f},
  {-0.238856f, 0.864188f, -0.442863f},
  {0.000000f, 0.955423f, -0.295242f},
  {-0.262866f, 0.951056f, -0.162460f},
  {0.000000f, 1.000000f, 0.000000f},
  {0.000000f, 0.955423f, 0.295242f},
  {-0.262866f, 0.951056f, 0.162460f},
  {0.238856f, 0.864188f, 0.442863f},
  {0.262866f, 0.951056f, 0.162460f},
  {0.500000f, 0.809017f, 0.309017f},
  {0.238856f, 0.864188f, -0.442863f},
  {0.262866f, 0.951056f, -0.162460f},
  {0.500000f, 0.809017f, -0.309017f},
  {0.850651f, 0.525731f, 0.000000f},
  {0.716567f, 0.681718f, 0.147621f},
  {0.716567f, 0.681718f, -0.147621f},
  {0.525731f, 0.850651f, 0.000000f},
  {0.425325f, 0.688191f, 0.587785f},
  {0.864188f, 0.442863f, 0.238856f},
  {0.688191f, 0.587785f, 0.425325f},
  {0.809017f, 0.309017f, 0.500000f},
  {0.681718f, 0.147621f, 0.716567f},
  {0.587785f, 0.425325f, 0.688191f},
  {0.955423f, 0.295242f, 0.000000f},
  {1.000000f, 0.000000f, 0.000000f},
  {0.951056f, 0.162460f, 0.262866f},
  {0.850651f, -0.525731f, 0.000000f},
  {0.955423f, -0.295242f, 0.000000f},
  {0.864188f, -0.442863f, 0.238856f},
  {0.951056f, -0.162460f, 0.262866f},
  {0.809017f, -0.309017f, 0.500000f},
  {0.681718f, -0.147621f, 0.716567f},
  {0.850651f, 0.000000f, 0.525731f},
  {0.864188f, 0.442863f, -0.238856f},
  {0.809017f, 0.309017f, -0.500000f},
  {0.951056f, 0.162460f, -0.262866f},
  {0.525731f, 0.000000f, -0.850651f},
  {0.681718f, 0.147621f, -0.716567f},
  {0.681718f, -0.147621f, -0.716567f},
  {0.850651f, 0.000000f, -0.525731f},
  {0.809017f, -0.309017f, -0.500000f},
  {0.864188f, -0.442863f, -0.238856f},
  {0.951056f, -0.162460f, -0.262866f},
  {0.147621f, 0.716567f, -0.681718f},
  {0.309017f, 0.500000f, -0.809017f},
  {0.425325f, 0.688191f, -0.587785f},
  {0.442863f, 0.238856f, -0.864188f},
  {0.587785f, 0.425325f, -0.688191f},
  {0.688191f, 0.587785f, -0.425325f},
  {-0.147621f, 0.716567f, -0.681718f},
  {-0.309017f, 0.500000f, -0.809017f},
  {0.000000f, 0.525731f, -0.850651f},
  {-0.525731f, 0.000000f, -0.850651f},
  {-0.442863f, 0.238856f, -0.864188f},
  {-0.295242f, 0.000000f, -0.955423f},
  {-0.162460f, 0.262866f, -0.951056f},
  {0.000000f, 0.000000f, -1.000000f},
  {0.295242f, 0.000000f, -0.955423f},
  {0.162460f, 0.262866f, -0.951056f},
  {-0.442863f, -0.238856f, -0.864188f},
  {-0.309017f, -0.500000f, -0.809017f},
  {-0.162460f, -0.262866f, -0.951056f},
  {0.000000f, -0.850651f, -0.525731f},
  {-0.147621f, -0.716567f, -0.681718f},
  {0.147621f, -0.716567f, -0.681718f},
  {0.000000f, -0.525731f, -0.850651f},
  {0.309017f, -0.500000f, -0.809017f},
  {0.442863f, -0.238856f, -0.864188f},
  {0.162460f, -0.262866f, -0.951056f},
  {0.238856f, -0.864188f, -0.442863f},
  {0.500000f, -0.809017f, -0.309017f},
  {0.425325f, -0.688191f, -0.587785f},
  {0.716567f, -0.681718f, -0.147621f},
  {0.688191f, -0.587785f, -0.425325f},
  {0.587785f, -0.425325f, -0.688191f},
  {0.000000f, -0.955423f, -0.295242f},
  {0.000000f, -1.000000f, 0.000000f},
  {0.262866f, -0.951056f, -0.162460f},
  {0.000000f, -0.850651f, 0.525731f},
  {0.000000f, -0.955423f, 0.295242f},
  {0.238856f, -0.864188f, 0.442863f},
  {0.262866f, -0.951056f, 0.162460f},
  {0.500000f, -0.809017f, 0.309017f},
  {0.716567f, -0.681718f, 0.147621f},
  {0.525731f, -0.850651f, 0.000000f},
  {-0.238856f, -0.864188f, -0.442863f},
  {-0.500000f, -0.809017f, -0.309017f},
  {-0.262866f, -0.951056f, -0.162460f},
  {-0.850651f, -0.525731f, 0.000000f},
  {-0.716567f, -0.681718f, -0.147621f},
  {-0.716567f, -0.681718f, 0.147621f},
  {-0.525731f, -0.850651f, 0.000000f},
  {-0.500000f, -0.809017f, 0.309017f},
  {-0.238856f, -0.864188f, 0.442863f},
  {-0.262866f, -0.951056f, 0.162460f},
  {-0.864188f, -0.442863f, 0.238856f},
  {-0.809017f, -0.309017f, 0.500000f},
  {-0.688191f, -0.587785f, 0.425325f},
  {-0.681718f, -0.147621f, 0.716567f},
  {-0.442863f, -0.238856f, 0.864188f},
  {-0.587785f, -0.425325f, 0.688191f},
  {-0.309017f, -0.500000f, 0.809017f},
  {-0.147621f, -0.716567f, 0.681718f},
  {-0.425325f, -0.688191f, 0.587785f},
  {-0.162460f, -0.262866f, 0.951056f},
  {0.442863f, -0.238856f, 0.864188f},
  {0.162460f, -0.262866f, 0.951056f},
  {0.309017f, -0.500000f, 0.809017f},
  {0.147621f, -0.716567f, 0.681718f},
  {0.000000f, -0.525731f, 0.850651f},
  {0.425325f, -0.688191f, 0.587785f},
  {0.587785f, -0.425325f, 0.688191f},
  {0.688191f, -0.587785f, 0.425325f},
  {-0.955423f, 0.295242f, 0.000000f},
  {-0.951056f, 0.162460f, 0.262866f},
  {-1.000000f, 0.000000f, 0.000000f},
  {-0.850651f, 0.000000f, 0.525731f},
  {-0.955423f, -0.295242f, 0.000000f},
  {-0.951056f, -0.162460f, 0.262866f},
  {-0.864188f, 0.442863f, -0.238856f},
  {-0.951056f, 0.162460f, -0.262866f},
  {-0.809017f, 0.309017f, -0.500000f},
  {-0.864188f, -0.442863f, -0.238856f},
  {-0.951056f, -0.162460f, -0.262866f},
  {-0.809017f, -0.309017f, -0.500000f},
  {-0.681718f, 0.147621f, -0.716567f},
  {-0.681718f, -0.147621f, -0.716567f},
  {-0.850651f, 0.000000f, -0.525731f},
  {-0.688191f, 0.587785f, -0.425325f},
  {-0.587785f, 0.425325f, -0.688191f},
  {-0.425325f, 0.688191f, -0.587785f},
  {-0.425325f, -0.688191f, -0.587785f},
  {-0.587785f, -0.425325f, -0.688191f},
  {-0.688191f, -0.587785f, -0.425325f}
};

TMd2::TMd2(TInfrastructure *curInfrastructure){
	Initialize(curInfrastructure);
	memset(&m_Header, 0, sizeof(tMd2Header));
	m_pSkins=NULL;
	m_pTexCoords=NULL;
	m_pTriangles=NULL;
	m_pFrames=NULL;
	numFrames = 0;
	flipNormals = false;
	curKeyFrame = 0;
	curTransitionFrame = 0;
	endKeyFrame = 0;
	interpolateNum = 0;
	startKeyFrame = 0;
	animateVertices = NULL;
	animateBasis = NULL;
	animateConnect = NULL;
	playedOnce = false;
	transitFlag = false;
	fileName = "";
	
	CubeMap32Ref = 0;
	CubeMap64Ref = 0;
	CubeMap128Ref = 0;
	CubeMap256Ref = 0;
	deathAnimationIndex = 0;
	animationCycle = true;
	
}

//makes a copy of another MD2 Object
void TMd2::Copy(TMd2 &CopyMd2) {

	triangleNum = CopyMd2.triangleNum;
	verticesList.clear();
	orthoList.clear();
	fileName = "";

	for(int i = 0; i < CopyMd2.verticesList.size(); i++) {
		SmallVertex *srcVertices =  CopyMd2.verticesList[i];
		SmallVertex *copyVertices = new SmallVertex[this->triangleNum * 3];
		memcpy(copyVertices, srcVertices, sizeof(SmallVertex) * this->triangleNum * 3);
		verticesList.push_back(copyVertices);
	}
	
	for(i = 0; i < CopyMd2.orthoList.size(); i++) {
		OrthoNormalBasis *srcOrtho = CopyMd2.orthoList[i];    
		OrthoNormalBasis *copyOrtho = new OrthoNormalBasis[this->triangleNum * 3];
		memcpy(copyOrtho, srcOrtho, sizeof(OrthoNormalBasis) * this->triangleNum * 3);
		orthoList.push_back(copyOrtho);
	}
	
	for(i = 0; i < CopyMd2.animList.size(); i++) {
		tMD2AnimationInfo srcAnim = CopyMd2.animList[i];
		tMD2AnimationInfo copyAnim = srcAnim;
		animList.push_back(copyAnim);
	}
	
	for(i = 0; i < CopyMd2.connectList.size(); i++) {
		Connective *srcConnect = CopyMd2.connectList[i];
		Connective *copyConnect = new Connective[this->triangleNum * 3];
		memcpy(copyConnect, srcConnect, sizeof(Connective) * this->triangleNum * 3);
		connectList.push_back(copyConnect);
	}
	
	numFrames = CopyMd2.numFrames;
	startKeyFrame = CopyMd2.startKeyFrame;
	curKeyFrame = CopyMd2.curKeyFrame;
	curTransitionFrame = CopyMd2.curTransitionFrame;
	endKeyFrame = CopyMd2.endKeyFrame;
	interpolateNum = CopyMd2.interpolateNum;
	flipNormals = CopyMd2.flipNormals;
	texInfo = CopyMd2.texInfo;
	Bound1 = CopyMd2.Bound1;
	Bound2 = CopyMd2.Bound2;
	
	animateVertices =new Vertex[this->triangleNum * 3];
	animateBasis = new OrthoNormalBasis[this->triangleNum * 3];
	animateConnect = NULL; 

	CubeMap32Ref = 0;
	CubeMap64Ref = 0;
	CubeMap128Ref = 0;
	CubeMap256Ref = 0;
	deathAnimationIndex = CopyMd2.deathAnimationIndex;
	animationCycle = true;
}


TMd2::~TMd2(){
	//object memory clean up
	cout << "Freeing Md2 Object: " << fileName << " where number of vertices: " << verticesList.size() << " and orthoList: " << orthoList.size() << endl;
	for(int i = 0; i < verticesList.size(); i++) 	{ if(verticesList[i] != NULL) delete [] verticesList[i]; verticesList[i] = NULL; }
	for(i = 0; i < orthoList.size(); i++) 	{ if(verticesList[i] != NULL)  delete [] orthoList[i]; orthoList[i] == NULL; }
	
	if(animateVertices != NULL) { delete [] animateVertices; animateVertices = NULL; }
	if(animateBasis != NULL) { delete [] animateBasis; animateBasis = NULL; }
	if(animateConnect != NULL) { delete [] animateConnect; animateConnect = NULL; }
	
	cout << "Successfully freed Md2 Object!" << endl;
	
	if(CubeMap32Ref > 0) {
		glDeleteTextures(1, (unsigned int*)(&CubeMap32Ref));
		glDeleteTextures(1, (unsigned int*)(&CubeMap64Ref));
		glDeleteTextures(1, (unsigned int*)(&CubeMap128Ref));
		glDeleteTextures(1, (unsigned int*)(&CubeMap256Ref));
	}
}

void TMd2::LoadGeom(char *filename) {
	char strMessage[255];
	memset(strMessage, '\0', 255);
	//Open the MD2 file in binary
	FILE *m_FilePointer = fopen(filename, "rb");

	if(!m_FilePointer) { //error in opening file
		cout << "Unable to open file: " << filename << endl;
		cerr << strMessage << endl;
		exit(1);
	}

	// Read the header data 
	fread(&m_Header, 1, sizeof(tMd2Header), m_FilePointer);
	// Make sure the version is this crazy number '8' 
	if(m_Header.version != 8)  { 	// Display an error message for bad file format, then stop loading
		cout << "Invalid file format for file: " << filename << endl;
		cerr << strMessage << endl;
		exit(1);
	}

	cout << "Loading " << filename << endl;

	fileName = filename;
	RetrieveMd2(m_FilePointer);
	EndFileIO(m_FilePointer);
}

/* now read in the stuff stored in the file*/
void TMd2::RetrieveMd2(FILE *filePtr) {
	//Create a larger buffer for the frames of animation (not fully used yet)
	unsigned char buffer[MD2_MAX_FRAMESIZE];

	//Allocate memory from the header's information
	m_pSkins     = new tMd2Skin [m_Header.numSkins];
	m_pTexCoords = new tMd2TexCoord [m_Header.numTexCoords];
	m_pTriangles = new tMd2Face [m_Header.numTriangles];
	m_pFrames    = new tMd2Frame [m_Header.numFrames];

	//Skin names offset
	//fseek(filePtr, m_Header.offsetSkins, SEEK_SET);

	//Read in each skin for this model
	//fread(m_pSkins, sizeof(tMd2Skin), m_Header.numSkins, filePtr);

	//Move the file pointer to the position in the file for texture coordinates
	fseek(filePtr, m_Header.offsetTexCoords, SEEK_SET);

	//The texture coordinates 
	fread(m_pTexCoords, sizeof(tMd2TexCoord), m_Header.numTexCoords, filePtr);

	//Move the file pointer to the triangles/face data offset
	fseek(filePtr, m_Header.offsetTriangles, SEEK_SET);

	//Face data for each triangle (vertex and texCoord indices)
	fread(m_pTriangles, sizeof(tMd2Face), m_Header.numTriangles, filePtr);

	//Move the file pointer to the vertices (frames)
	fseek(filePtr, m_Header.offsetFrames, SEEK_SET);

	for (int i=0; i < m_Header.numFrames; i++) {
		//Assign our alias frame to our buffer memory
		tMd2AliasFrame *pFrame = (tMd2AliasFrame *) buffer;
		//Allocate the memory for the first frame of animation's vertices
		m_pFrames[i].pVertices = new tMd2Triangle [m_Header.numVertices];
		//Read in the first frame of animation
		fread(pFrame, 1, m_Header.frameSize, filePtr);
		//Copy the name of the animation to our frames array
		strcpy(m_pFrames[i].strName, pFrame->name);
		//Store off a vertex array pointer to cut down large lines of code
		tMd2Triangle *pVertices = m_pFrames[i].pVertices;
		//Go through all of the number of vertices and assign the scale and translations.
		//Store the vertices in our current frame's vertex list array, while swapping Y and Z.
		//Notice we also negate the Z axis as well to make the swap correctly.
		for (int j=0; j < m_Header.numVertices; j++) {
			pVertices[j].vertex[0] = pFrame->aliasVertices[j].vertex[0] * pFrame->scale[0] + pFrame->translate[0];
			pVertices[j].vertex[2] = -1 * (pFrame->aliasVertices[j].vertex[1] * pFrame->scale[1] + pFrame->translate[1]);
			pVertices[j].vertex[1] = pFrame->aliasVertices[j].vertex[2] * pFrame->scale[2] + pFrame->translate[2];

			pVertices[j].normal[0] = md2VertexNormals[pFrame->aliasVertices[j].lightNormalIndex][0];
			pVertices[j].normal[2] = md2VertexNormals[pFrame->aliasVertices[j].lightNormalIndex][2];
			pVertices[j].normal[1] = md2VertexNormals[pFrame->aliasVertices[j].lightNormalIndex][1];
		}
		
	}
	
	

	ParseToInternalModel();

}

/* Goes through the data we read in and tries to parse the frames of animations*/
void TMd2::ExtractAnimations() {
	tMD2AnimationInfo animation;
	string strLastName = "";
	string empty = "";

	// Go through all of the frames of animation and parse each animation
	for(int i = 0; i < this->numFrames; i++) {
		// Assign the name of this frame of animation to a string object
		string strName  = m_pFrames[i].strName;
		int frameNum = 0;
		
		// Go through and extract the frame numbers and erase them from the name
		for(int j = 0; j < strName.length(); j++) {
			// If the current index is a number and it's one of the last 2 characters of the name
			if( isdigit(strName[j])) { // && j >= strName.length() - 2) {
				// Use a C function to convert the character to an integer.
				// Notice we use the address to pass in the current character and on
				frameNum = atoi(&strName[j]);
				// Erase the frame number from the name so we extract the animation name
//				strName.erase(j, strName.length() - (j - 1));
				strName.erase(j, 50);
//				cout << strName << endl;
				break;
			}
		}
		// Check if this animation name is not the same as the last frame,
		// or if we are on the last frame of animation for this model
		if(strName != strLastName || i == this->numFrames - 1) {
			 // If this animation frame is NOT the first frame
			if(strLastName != empty) {
				// Copy the last animation name into our new animation's name
				strcpy(animation.Name, strLastName.c_str());
				// Set the last frame of this animation to i

				if(i == this->numFrames - 1)
					animation.endFrame = i + 1;
				else
					animation.endFrame = i;
				
				// Add the animation to our list and reset the animation object for next time
				animList.push_back(animation);
				if(strName.length() >= 5 && deathAnimationIndex == 0) {
					char checkString[6]; memset(checkString, '\0', 6);
					memcpy(checkString, strName.c_str(), 5);
					if(strcmp(checkString, "death") == 0) {
						deathAnimationIndex = animList.size() - 1;
					}
				}
				
				memset(&animation, 0, sizeof(tMD2AnimationInfo));
			}
				// Set the starting frame number to the current frame number we just found,
				// minus 1 (since 0 is the first frame) and add 'i'.
				animation.startFrame = frameNum - 1 + i;
			}
			// Store the current animation name in the strLastName string to check it latter
			strLastName = strName;
		}
}

void TMd2::ParseToInternalModel() {
	Connective *firstConnective = NULL;
	this->numFrames = m_Header.numFrames;
	this->triangleNum = m_Header.numTriangles;
	ExtractAnimations();

	float flipVal = 1.0f;
	if(flipNormals) flipVal = -1.0f;

	animateVertices = new Vertex[this->triangleNum * 3];
	animateBasis = new OrthoNormalBasis[this->triangleNum * 3];
	Connective *curConnective = new Connective[this->triangleNum * 3];
	memset(curConnective, 0, sizeof(Connective) * this->triangleNum * 3);
		
	for(int i = 0; i < this->numFrames; i++) {
		 SmallVertex *curFrameVertices = new SmallVertex[this->triangleNum * 3];
		 OrthoNormalBasis *curFrameOrthoBasis = new OrthoNormalBasis[this->triangleNum * 3];
		 memset(curFrameVertices, 0, sizeof(SmallVertex) * this->triangleNum * 3);
		 memset(curFrameOrthoBasis, 0, sizeof(OrthoNormalBasis) * this->triangleNum * 3);

		SmallVertex *assignVertex = curFrameVertices;
		OrthoNormalBasis *assignBasis = curFrameOrthoBasis;
		 
		for(int j = 0; j < this->triangleNum; j++) {
			short vertIndex1 = m_pTriangles[j].vertexIndices[0];
			short vertIndex2 = m_pTriangles[j].vertexIndices[1];
			short vertIndex3 = m_pTriangles[j].vertexIndices[2];

			short texIndex1 = m_pTriangles[j].textureIndices[0];
			short texIndex2 = m_pTriangles[j].textureIndices[1];
			short texIndex3 = m_pTriangles[j].textureIndices[2];

			//first vertex
			assignVertex->position.x = m_pFrames[i].pVertices[vertIndex1].vertex[0];
			assignVertex->position.y = m_pFrames[i].pVertices[vertIndex1].vertex[1];
			assignVertex->position.z = m_pFrames[i].pVertices[vertIndex1].vertex[2];

			assignVertex->s = (GLfloat)(m_pTexCoords[texIndex1].u) / ((GLfloat)(m_Header.skinWidth));
			assignVertex->t = 1.0f - (GLfloat)(m_pTexCoords[texIndex1].v) / ((GLfloat)(m_Header.skinHeight));

			assignBasis->normal.x = m_pFrames[i].pVertices[vertIndex1].normal[0] * flipVal;
			assignBasis->normal.y = m_pFrames[i].pVertices[vertIndex1].normal[1] * flipVal;
			assignBasis->normal.z = m_pFrames[i].pVertices[vertIndex1].normal[2] * flipVal;
  
			assignVertex++;
			assignBasis++;

			//second vertex
			assignVertex->position.x = m_pFrames[i].pVertices[vertIndex2].vertex[0];
			assignVertex->position.y = m_pFrames[i].pVertices[vertIndex2].vertex[1];
			assignVertex->position.z = m_pFrames[i].pVertices[vertIndex2].vertex[2];

			assignVertex->s = (GLfloat)(m_pTexCoords[texIndex2].u) / ((GLfloat)(m_Header.skinWidth));
			assignVertex->t = 1.0f - (GLfloat)(m_pTexCoords[texIndex2].v) / ((GLfloat)(m_Header.skinHeight));

			assignBasis->normal.x = m_pFrames[i].pVertices[vertIndex2].normal[0] * flipVal;
			assignBasis->normal.y = m_pFrames[i].pVertices[vertIndex2].normal[1] * flipVal;
			assignBasis->normal.z = m_pFrames[i].pVertices[vertIndex2].normal[2] * flipVal;

			assignVertex++;
			assignBasis++;

			//third vertex
			assignVertex->position.x = m_pFrames[i].pVertices[vertIndex3].vertex[0];
			assignVertex->position.y = m_pFrames[i].pVertices[vertIndex3].vertex[1];
			assignVertex->position.z = m_pFrames[i].pVertices[vertIndex3].vertex[2];

			assignVertex->s = (GLfloat)(m_pTexCoords[texIndex3].u) / ((GLfloat)(m_Header.skinWidth));
			assignVertex->t = 1.0f - (GLfloat)(m_pTexCoords[texIndex3].v) / ((GLfloat)(m_Header.skinHeight));

			assignBasis->normal.x = m_pFrames[i].pVertices[vertIndex3].normal[0] * flipVal;
			assignBasis->normal.y = m_pFrames[i].pVertices[vertIndex3].normal[1] * flipVal;
			assignBasis->normal.z = m_pFrames[i].pVertices[vertIndex3].normal[2] * flipVal;

			assignVertex++;
			assignBasis++;
		}

		for(int k = 0; k < this->triangleNum * 3; k++) {
			(animateVertices + k)->position = (curFrameVertices + k)->position;
			(animateVertices + k)->s = (curFrameVertices + k)->s;
			(animateVertices + k)->t = (curFrameVertices + k)->t;
		}
		this->vertices = animateVertices;
		
		this->orthobasis = curFrameOrthoBasis;
		this->vertexConnect = curConnective;
		this->CalculateSphericalOrthoBasis();

		if(firstConnective == NULL) {
			this->SetConnectives();
		}
		else {
//			memcpy((void *)curConnective, (void *)firstConnective, sizeof(Connective) * this->triangleNum * 3);
		}
		this->CalculatePlanes();

		if(firstConnective == NULL) firstConnective = curConnective;
		
		this->verticesList.push_back(curFrameVertices);
		this->orthoList.push_back(curFrameOrthoBasis);
		this->connectList.push_back(firstConnective);


		delete [] m_pFrames[i].pVertices;
	}

   this->SetCurrentAnimation(0, 1);
   this->PlayAnimation();
	this->CalcBounds();

}

/*calculates the normal vectors for the model at each vertex, probably deprecated since we now
 * get normals directly from the models themselves
 */
void TMd2::CalculateNormals(SmallVertex *vertices, OrthoNormalBasis *basis, int verticeNum) {
	SmallVertex *curVertex = vertices;
	OrthoNormalBasis *curBasis = basis;

	//first calculate the normals per polygon
	for(int i = 0; i < (verticeNum / 3); i++) {
		Vector pnt1 = (curVertex->position);
		Vector pnt2 = (curVertex + 1)->position;
		Vector pnt3 = (curVertex + 2)->position;

		Vector vec1, vec2, vec3;
		Vsub(&pnt1, &pnt2, &vec1);
		Vsub(&pnt1, &pnt3, &vec2);
		Vcross(&vec1, &vec2, &vec3);
		Vnormal(&vec3);
		
		curBasis->normal = vec3;
		(curBasis + 1)->normal = vec3;
		(curBasis + 2)->normal = vec3;

		curVertex = curVertex + 3;
		curBasis = curBasis + 3;
	}


	//now find the shared vertices and find the normals per vertex
	curVertex = vertices;
	curBasis = basis;

	for(i = 0; i < verticeNum; i++) {
		Vector curVec = curVertex->position;
		Vector resultVec = curBasis->normal;
		
		SmallVertex *workVertex = vertices;
		OrthoNormalBasis *workBasis = basis;
		//find the shared vertices
		for(int j = 0; j < verticeNum; j++) {
			Vector workVec = workVertex->position;
			if(Vequal(&workVec, &curVec)) {
				Vector workNormal = workBasis->normal;
				Vadd(&resultVec, &workNormal, &resultVec);
			}
			workVertex++;
			workBasis++;
		}

		Vnormal(&resultVec);
		Vscale(&resultVec, -1.0f);
		curBasis->normal = resultVec;
			
		curVertex++;
		curBasis++;
	}

}

/* Sets the current vertices to be that by the specified keyframe*/
void TMd2::SetStaticKeyFrame(int keyFrame) {
	if(keyFrame > (numFrames - 1)) {
		cout << "Exceeded number of KeyFrames!" << endl;
		return;
	}

	for(int k = 0; k < this->triangleNum * 3; k++) {
		(this->vertices + k)->position = (this->verticesList[keyFrame] + k)->position;
		(this->vertices + k)->s = (this->verticesList[keyFrame] + k)->s;
		(this->vertices + k)->t = (this->verticesList[keyFrame] + k)->t;
	}

	this->orthobasis = this->orthoList[keyFrame];
	this->vertexConnect = this->connectList[keyFrame];
}

/* Clean up once we are done reading the file*/
void TMd2::EndFileIO(FILE *filePtr) {
	fclose(filePtr);
	if(m_pSkins)     delete [] m_pSkins;      
	if(m_pTexCoords) delete[] m_pTexCoords;    
	if(m_pTriangles) delete[] m_pTriangles;    
	if(m_pFrames)    delete[] m_pFrames;       
}

void TMd2::SetCurrentAnimation(int animationIndex, int smoothness) {
	if(animationIndex > (animList.size() - 1)) {
		cout << "Exceeded animation count!" << endl;
		return;
	}

	curAnimationIndex = animationIndex;
	curTransitionFrame = 0;
	startKeyFrame = (animList[animationIndex]).startFrame;
	
	if(!playedOnce) { curKeyFrame = (animList[animationIndex]).startFrame; playedOnce = true; }
	
	endKeyFrame = (animList[animationIndex]).endFrame;
	interpolateNum = smoothness;
	

}

void TMd2::PlayAnimation() {
	SmallVertex *fromVertices = NULL, *toVertices = NULL;
	OrthoNormalBasis *fromBasis = NULL, *toBasis = NULL;

	if(curKeyFrame >= endKeyFrame - 1 && !animationCycle) {
		curKeyFrame = endKeyFrame;
		curTransitionFrame--;	
		return;
	}
		
	if(curKeyFrame >= startKeyFrame && curKeyFrame <= endKeyFrame) {
		if(curKeyFrame >= (endKeyFrame - 1)) {
			fromVertices = verticesList[endKeyFrame - 1];
			fromBasis = orthoList[endKeyFrame - 1];

			toVertices = verticesList[startKeyFrame];
			toBasis = orthoList[startKeyFrame];
		}
		else {
			fromVertices = verticesList[curKeyFrame];
			fromBasis = orthoList[curKeyFrame];
		
			toVertices = verticesList[curKeyFrame + 1];
			toBasis = orthoList[curKeyFrame + 1];
		}
	}
	else {
		fromVertices = verticesList[curKeyFrame];
		fromBasis = orthoList[curKeyFrame];
		
		toVertices = verticesList[startKeyFrame];
		toBasis = orthoList[startKeyFrame];
		transitFlag  = true;
	}
		

	animateConnect = connectList[startKeyFrame];
	
	for(int i = 0; i < (this->triangleNum * 3); i++) {
		Vinterpolate(&((fromVertices + i)->position), &((toVertices + i)->position), &((animateVertices + i)->position), interpolateNum, curTransitionFrame); 
		Vinterpolate(&((fromBasis + i)->normal), &((toBasis + i)->normal), &((animateBasis + i)->normal), interpolateNum, curTransitionFrame);
		Vinterpolate(&((fromBasis + i)->binormal), &((toBasis + i)->binormal), &((animateBasis + i)->binormal), interpolateNum, curTransitionFrame);
		Vinterpolate(&((fromBasis + i)->tangent), &((toBasis + i)->tangent), &((animateBasis + i)->tangent), interpolateNum, curTransitionFrame);
		Vnormal(&((animateBasis + i)->normal));
		Vnormal(&((animateBasis + i)->binormal));
		Vnormal(&((animateBasis + i)->tangent));   

		(animateVertices + i)->s = (fromVertices + i)->s;
		(animateVertices + i)->t = (fromVertices + i)->t;

	}

	this->vertices = animateVertices;
	this->orthobasis = animateBasis;
	this->vertexConnect = animateConnect;
	this->CalculatePlanes();
	
	curTransitionFrame++;
	if(curTransitionFrame >= (interpolateNum - 1)) {
		curTransitionFrame = 0;
		if(curKeyFrame < startKeyFrame || curKeyFrame >= endKeyFrame) {
			curKeyFrame = startKeyFrame;
			transitFlag = false;
		}
		else curKeyFrame++;
	}
	
	if( (endKeyFrame - startKeyFrame) <= 2) animationCycle = false;
	
	if(curKeyFrame >= (endKeyFrame) && !transitFlag && animationCycle) {
		curKeyFrame = startKeyFrame;
		curTransitionFrame = 0;
	}
	

}
