/***************************************************************************
                          tobject.h  -  generic object that other classes should derive to create 3D objects
                             -------------------
    begin                : Tue Dec 17 2002
    copyright            : (C) 2002 by Chong Jiayi
    email                : jychong@stanford.edu
 ***************************************************************************/


#ifndef TOBJECT_H
#define TOBJECT_H

#include "tinfrastructure.h"
#include "vectorutils.h"
#include <stdio.h>

/**
  *@author Chong Jiayi
  */

static const int PLAIN_MODE = -2;
static const int DECAL_MODE = 0;
static const int DIFFUSE_BUMP_MODE = 1;
static const int SPECULAR_BUMP_MODE = 2;
static const int ATTENUATE_MODE = 3;
static const int REFRACT_MODE_1 = 4;
static const int REFRACT_MODE_2 = 5;
static const int PLANE_TYPE = 6;
static const int MD2_TYPE = 7;

static const int CUBE_RENDER_FRAME_LIMIT = 5;

struct TEdgeTrack {
	int index;
	Vertex v1;
	Vertex  v2;
	bool done;
};                                               
	
class TObject {

protected:
	//these data structures are all composed coordinates packed in triplets(basically
	//in the form of triangles)
	Vertex *vertices;
	OrthoNormalBasis *orthobasis;
	TInfrastructure *infrastructure;
	TextureInfo *texInfo;
	Connective *vertexConnect;
	int triangleNum;
	GLfloat lightBrightness;
	Vector eyePos;
	Vector lightPos;
	GLuint CubeMap32Ref;
	GLuint CubeMap64Ref;
	GLuint CubeMap128Ref;
	GLuint CubeMap256Ref;
	int cubeMapSelect;
	int cubeRenderFrame;

	Vector Bound1;
	Vector Bound2;
	Vector Bound3;
	Vector Bound4;
	Vector Bound5;
	Vector Bound6;
	Vector Bound7;
	Vector Bound8;

	Vector DstBound1;
	Vector DstBound2;
	Vector DstBound3;
	Vector DstBound4;
	Vector DstBound5;
	Vector DstBound6;
	Vector DstBound7;
	Vector DstBound8;

	GLfloat transformMatrix[16];
	GLfloat inverseTransformMatrix[16];
	GLfloat transformMatrix2[16];
	GLfloat inverseTransformMatrix2[16];
	void renderImmediateMode();
	void setVertexPos(int index, GLfloat x, GLfloat y, GLfloat z);
	void setTextureCoords(int index, GLfloat s, GLfloat t);
	void setNormalCoords(int index, GLfloat x, GLfloat y, GLfloat z);
	void setBinormalCoords(int index, GLfloat x, GLfloat y, GLfloat z);
	void setTangentCoords(int index, GLfloat x, GLfloat y, GLfloat z);
	void EnableNVRegCombinersDiffuse(GLfloat aRed, GLfloat aGreen, GLfloat aBlue, GLfloat aAlpha, GLfloat dRed, GLfloat dGreen, GLfloat dBlue, GLfloat dAlpha);
	void EnableNVRegCombinersSpecular();
	void EnableNVAttenuate(GLfloat r, GLfloat g, GLfloat b);
	void EnableNVRefract1();
	void EnableNVRefract2();
	void ShadowPass(Connective *curConnective, Vertex *curVertex, Connective *theConnectives, Vector *lightVec, bool flag);
	void CapShadowVolume(Connective *curConnective, Vertex *curVertex, Vector *lightVec);
	bool ShareEdge(Vertex *edge11, Vertex * edge12, Vertex *edge21, Vertex *edge22);
	float DiffEdge(Vertex *edge11, Vertex * edge12, Vertex *edge21, Vertex *edge22);
	bool SameTriangle(Vector *v11, Vector *v12, Vector *v13, Vector *v21, Vector *v22, Vector *v23);
	bool IsDegenerate(Vertex *curTriangle);
	int curRenderMode;
	void createCubeMapTextures();
	void createCubeMapTextureSet(int size, int ID);
	
public:
	//constructors/destructors of inherited objects should have these specifications
/*	virtual TObject(TInfrastructure * curInfrastructure) =0;
	virtual ~TObject() =0;      */
	void Initialize(TInfrastructure *curInfrastructure);
	void Cleanup();   
	
	void Render();
	void RenderWithMatrix(GLfloat *mat);
	void LoadTexture(char *decal_filename, char *bump_filename, int mipmaps, float scale);
	void CalculateOrthoBasis();
	void CalculateSphericalOrthoBasis();
	void CalculatePlanes();
	void SetConnectives();
	void SelectSingleDecalTexture();
	void SelectCubeAndBumpTexture();
	void SetupVertexArraysForRendering(int mode);
	void PrepareTransform();
	void EndTransform();
	void EnablePlainDecal();
	void EnableShadowedDecal();
	void EnableStencilDecal(GLfloat r, GLfloat g, GLfloat b);
	void EnableDiffusePass(GLfloat aRed, GLfloat aGreen, GLfloat aBlue, GLfloat aAlpha, GLfloat dRed, GLfloat dGreen, GLfloat dBlue, GLfloat dAlpha);
	void EnableSpecularPass();
	void EnableAttenuatePass(GLfloat r, GLfloat g, GLfloat b);
	void EnableAttenuatePass2(GLfloat r, GLfloat g, GLfloat b);
	void EnableRefractPass1(GLfloat *mat);
	void EnableRefractPass2(GLfloat *mat);
	void SetLightPos(GLfloat x, GLfloat y, GLfloat z);
	void SetEyePos(GLfloat x, GLfloat y, GLfloat z);
	void SetLightBrightness(GLfloat level) { lightBrightness = level; }
	void SetupLightVectorsForRendering();
	void CastShadowDepthPass(bool flag);
	void CalcBounds();
	void UpdateBounds();
	void MatrixMult(GLfloat *tMatrix);
	void SaveMatrix();
	void RestoreMatrix();
	void ApplyTransformPermanent();
	Vector *GetBounds1()  { return &Bound1; }
	Vector *GetBounds2()  { return &Bound2; }
	Vector *GetBounds3()  { return &Bound3; }
	Vector *GetBounds4()  { return &Bound4; }
	Vector *GetBounds5()  { return &Bound5; }
	Vector *GetBounds6()  { return &Bound6; }
	Vector *GetBounds7()  { return &Bound7; }
	Vector *GetBounds8()  { return &Bound8; }
	Vector *GetDstBounds1()  { return &DstBound1; }
	Vector *GetDstBounds2()  { return &DstBound2; }
	Vector *GetDstBounds3()  { return &DstBound3; }
	Vector *GetDstBounds4()  { return &DstBound4; }
	Vector *GetDstBounds5()  { return &DstBound5; }
	Vector *GetDstBounds6()  { return &DstBound6; }
	Vector *GetDstBounds7()  { return &DstBound7; }
	Vector *GetDstBounds8()  { return &DstBound8; }
	Vector GetMaxBounds();
	Vector GetMinBounds();
	Vector GetMaxOrgBounds();
	Vector GetMinOrgBounds();
	Vector GetBndMidPnt();
	Vector GetBndOrgMidPnt();
	Vector *GetLight() {return &lightPos; }
	void SetDstBounds1(float x, float y, float z) {DstBound1.x = x; DstBound1.y = y; DstBound1.z = z; }
	void SetDstBounds2(float x, float y, float z) {DstBound2.x = x; DstBound2.y = y; DstBound2.z = z; }
	void SetDstBounds3(float x, float y, float z) {DstBound3.x = x; DstBound3.y = y; DstBound3.z = z; }
	void SetDstBounds4(float x, float y, float z) {DstBound4.x = x; DstBound4.y = y; DstBound4.z = z; }
	void SetDstBounds5(float x, float y, float z) {DstBound5.x = x; DstBound5.y = y; DstBound5.z = z; }
	void SetDstBounds6(float x, float y, float z) {DstBound6.x = x; DstBound6.y = y; DstBound6.z = z; }
	void SetDstBounds7(float x, float y, float z) {DstBound7.x = x; DstBound7.y = y; DstBound7.z = z; }
	void SetDstBounds8(float x, float y, float z) {DstBound8.x = x; DstBound8.y = y; DstBound8.z = z; }
	
	void setCubeMapRenderSize(int sizeFactor) { if(cubeMapSelect == -1) createCubeMapTextures(); cubeMapSelect = sizeFactor; }
	void copyScreenToCubeMap(GLenum target);
	int GetCubeRenderFrameNum() { if(cubeRenderFrame > CUBE_RENDER_FRAME_LIMIT) cubeRenderFrame = -1; else cubeRenderFrame++; return cubeRenderFrame; }
	int GetCurrentCubeMap();
	string GetDecalName() { return texInfo->decalFilename; }
	string GetBumpName() { return texInfo->bumpFilename; }
	float GetBumpScale() const { return texInfo->scale; }
	virtual bool Loadable() =0;
	virtual void LoadGeom(char *filename) =0;
	virtual int GetType() const = 0;
};

#endif
