/***************************************************************************
                          toolbar.cpp  -  description
                             -------------------
    begin                : Fri Oct 10 2003
    copyright            : (C) 2003 by Chong Jiayi
    email                : jychong@stanford.edu
 ***************************************************************************/


#include "toolbar.h"
#include <execinfo.h>

void callBackClick(void *obj, int x, int y);
void callBackClickUp(void *obj, int x, int y);

static int is_Space(int c)
{
	if (c == ' ' || c == '\t' || c == '\n' || c == '\r') return true;
	else return false;
}

static char * is_fgets(char *buf, int n, FILE *fp)
{
	char *wbuf;
	int c, bcnt = 0;

	if (n <= 0) return (NULL);

	wbuf = buf; n = n - 1;                   

	c = '\t';
	while(is_Space(c)) { c = getc(fp); }

	while (n != 0) {
		if (c == '\n' || c == '\r') break;
		if (c == EOF) 
			if (bcnt == 0) return NULL; else break;
		buf[bcnt] = c; bcnt++;
		n = n - 1;
		c = getc(fp);
	}

	buf[bcnt] = '\0';
	return buf;
}


toolBar::toolBar(TInfrastructure *theInfrastructure){
	toolWindow = new TWidgetWindow(theInfrastructure);
	curInfrastructure = theInfrastructure;
	curSelect = -1;
	offsetX = 0;
	offsetY = 0;
	style = HORIZONTAL_STYLE;
	textR = 0.0; textG = 0.0; textB = 0.0;
	textOffsetX = 0.0; textOffsetY = 0.0;
	clickIndex = -1;
	btnOffsetX = 0;
	btnOffsetY = 0;
}

toolBar::~toolBar(){
	delete toolWindow;
	
	for(int i = 0; i < buttonList.size(); i++) {
		delete buttonList[i].instance;
	}
	
}

void toolBar::addButton(char *filename, char * text, int type, int status, float r0, float g0, float b0, float r1, float g1, float b1, float alpha) {
	toolButton newButton;
	newButton.type = type;
	newButton.status = status;
	newButton.instance = new TPicButton(curInfrastructure);
	newButton.filename = filename;
	newButton.instance->setTexture(filename);
	newButton.instance->setButtonUpColor(r0, g0, b0, r1, g1, b1, alpha);
	newButton.instance->setButtonDownColor(r0, g0, b0, r1, g1, b1, alpha * 0.5);
	newButton.instance->setTitle(text, 0);
	newButton.instance->setTextColor(textR, textG, textB, textAlpha);
	newButton.instance->setTextOffset(textOffsetX, textOffsetY);
	newButton.instance->setMiscVal(buttonList.size());
	newButton.instance->setMiscObj((void *)this);
	newButton.instance->setWidgetCallObject( (void *)newButton.instance );
	newButton.instance->setMouseDownFunction(callBackClick);
	newButton.instance->setMouseUpFunction(callBackClickUp);
	
	if(style == VERTICAL_STYLE) {
		newButton.instance->setDimensions(btnOffsetX, btnOffsetY + 100 +  (buttonList.size()) * (offsetY + btnHeight * 1.2), btnWidth * 1.5, btnHeight * 1.5);
	}
	else {
		newButton.instance->setDimensions(btnOffsetX + (buttonList.size()) * (offsetX + btnWidth * 1.2), btnOffsetY, btnWidth * 1.5, btnHeight * 1.5);
	}
	
	toolWindow->attachWidget(newButton.instance);
	buttonList.push_back(newButton);

}

string toolBar::getPicFilename(int type) {
	for(int i = 0; i < buttonList.size(); i++) {
		if(buttonList[i].type == type) return buttonList[i].filename;
	}
	
	string empty;
	return empty;
}


btnReturnInfo toolBar::getButtonClicked() {
	btnReturnInfo retval;
	retval.index = curSelect;
	if(curSelect != -1) retval.type = buttonList[curSelect].type;
	curSelect = -1;
	return retval;
}

void toolBar::setDimensions(int curX, int curY, int curWidth, int curHeight) {
	toolWindow->setDimensions(curX, curY, curWidth, curHeight);
}

void toolBar::render() {
	toolBarManager->renderWidgets();
}

int toolBar::LoadButtonList(char *filename) {
	FILE *file;
	char buf[256], *gotbuf;
	char name[256], texName[256];
	int status, type, matches = 0;
	float r0, g0, b0, r1, g1, b1, alpha;
	
	file = fopen(filename, "r");
	if (file == NULL) {
		cout << "Could not load " << filename << "." << endl;
		return -1;
 	 }
	 
	 	while (!feof(file)) {
			gotbuf = is_fgets(buf, sizeof(buf), file);
			if (gotbuf) {
				switch(buf[0]) {
					case '#':
					break;
					
					case 'T':
						/* TOOLBAR r0 g0 b0 r1 g1 b1 alpha*/
						matches = sscanf(buf, "TOOLBAR %g %g %g %g %g %g %g\n", &r0, &g0, &b0, &r1, &g1, &b1, &alpha);
						if(matches == 7) {
							toolWindow->setColor(r0, g0, b0, r1, g1, b1, alpha);
						} else {fclose(file); cout << "Bad Parse for BUTTON!" << endl; return -1;}
					break;

					case 'B':
						/* BUTTON filename text type status r0 g0 b0 r1 g1 b1 alpha*/
						matches = sscanf(buf, "BUTTON %s %s %d %d %g %g %g %g %g %g %g\n",
									texName, name, &type, &status, &r0, &g0, &b0, &r1, &g1, &b1, &alpha);
						if (matches == 11) {
							addButton(texName, name, type, status, r0, g0, b0, r1, g1, b1, alpha);
						} else {fclose(file); cout << "Bad Parse for BUTTON!" << endl; return -1;}
					break;
				}
			}
		}
		
		return true;

}

int toolBar::mouseDownProcess(int x, int y) {
//	toolBarManager->mouseDownProcess(x, y); 
	return clickIndex;
}


/* Callback function to send the messaging stuff back*/
void callBackClick(void *obj, int x, int y) {
	TWidget *curWidget = (TWidget *)obj;
	toolBar *curToolBar = (toolBar *)curWidget->getMiscObj();
	int index = curWidget->getMiscVal();
	curToolBar->setClickIndex(index);
}

void callBackClickUp(void *obj, int x, int y) {

}
