/***************************************************************************
                          toolbar.h  -  description
                             -------------------
    begin                : Fri Oct 10 2003
    copyright            : (C) 2003 by Chong Jiayi
    email                : jychong@stanford.edu
 ***************************************************************************/


#ifndef TOOLBAR_H
#define TOOLBAR_H

#include "tpicbutton.h"
#include "tbutton.h"
#include "twidgetwindow.h"
#include "twidgetmanager.h"

/**
  *@author Chong Jiayi
  */

const int DISABLED_STATE = 0;
const int ENABLED_STATE = 1;
const int VERTICAL_STYLE = 5;
const int HORIZONTAL_STYLE = 6;
  
struct toolButton {
	TPicButton *instance;
	int type;
	int status;
	string text;
	string filename;
};

struct btnReturnInfo {
	int index;
	int type;
};

class toolBar {
protected:
	vector<toolButton> buttonList;
	TWidgetWindow *toolWindow;
	int curSelect;
	TInfrastructure *curInfrastructure;
	int btnWidth, btnHeight, offsetX, offsetY, style;
	int btnOffsetX, btnOffsetY;
	float textR, textG, textB, textAlpha;
	int textOffsetX, textOffsetY;
	int clickIndex;
	TWidgetManager *toolBarManager;
public: 
	toolBar(TInfrastructure *theInfrastructure);
	~toolBar();
	void setWidgetManager(TWidgetManager *widgetManager) { toolBarManager = widgetManager; toolBarManager->AttachWidget(toolWindow); }
	void setBackgroundColor(float r0, float g0, float b0, float r1, float g1, float b1, float alpha) { toolWindow->setColor(r0, g0, b0, r1, g1, b1, alpha); }
	void addButton(char *filename, char * text, int type, int status, float r0, float g0, float b0, float r1, float g1, float b1, float alpha);
	btnReturnInfo getButtonClicked();
	int LoadButtonList(char *filename);
	string getPicFilename(int type);
	void setDimensions(int curX, int curY, int curWidth, int curHeight);
	void setBtnSize(int width, int height) {btnWidth = width; btnHeight = height; }
	void setOffset(int offX, int offY) { offsetX = offX; offsetY = offY; }
	void setBtnOffset(int offX, int offY) { btnOffsetX = offX; btnOffsetY = offY; }
	void setStyle(int inputStyle) { style = inputStyle; }
	void setTextOffset(int x, int y) { textOffsetX = x; textOffsetY = y; }
	void setTextColor(float r, float g, float b) { textR = r; textG = g; textB = b; }
	void setClickIndex(int index) { curSelect = index; }
	void render();
	int mouseDownProcess(int x, int y);
	void show(bool flag) { toolWindow->show(flag); }
};

#endif
