/***************************************************************************
                          tpicbutton.cpp  -  description
                             -------------------
    begin                : Sun Sep 28 2003
    copyright            : (C) 2003 by Chong Jiayi
    email                : jychong@stanford.edu
 ***************************************************************************/


#include "tpicbutton.h"

TPicButton::TPicButton(TInfrastructure *theInfrastructure){
	Initialize(theInfrastructure);
	title = new TLabel(theInfrastructure);
	curRender = new TWidgetRender(theInfrastructure);
	loaded = false;
	backLoaded = false;
	title->setColor(1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0);
	textOffsetX = 0;
	textOffsetY = 0;
	state = BTN_UP;
}

TPicButton::~TPicButton(){
	delete title;
	delete curRender;
}

void TPicButton::setTexture(char *texName) {
	textureName = texName;
}

void TPicButton::render(int X, int Y) {
	if(!visible) {
		if(renderAlpha > 0.0) {
			renderAlpha = renderAlpha - 0.1;
		}
	}
	else {
		if(renderAlpha < alpha) {
			renderAlpha = renderAlpha + 0.1;
		}
	}
	
	
	title->setDimensions(this->x + textOffsetX, this->y + textOffsetY, width, height);
	title->show(visible);
	
	if(renderAlpha <= 0.0) return;
	
//	if(!loaded) {
	curRender->loadTexture((char *)(textureName.c_str()) );
//		loaded = true;
//	}
	
	curRender->selectTexture();	
	curRender->renderRect(CLASSIC_STYLE, this->x + X, this->y + Y, this->width, this->height,
					r1, g1, b1, r2, g2, b2, renderAlpha); 
	
	title->render(X, Y);
}

void TPicButton::setTitle(char *curTitle, int fontSet) {
	title->setFont(fontSet, curTitle);
}

void TPicButton::setTextColor(GLfloat r, GLfloat g, GLfloat b, GLfloat alpha) {
	title->setColor(r, g, b, r, g, b, alpha);
}

void TPicButton::setTextOffset(int offsetX, int offsetY) {
	textOffsetX = offsetX;
	textOffsetY = offsetY;
}

void TPicButton::inputMouseDown(int x, int y) {
	callMouseDown(x, y);
	state = BTN_DOWN;
	setColor(red1[state], green1[state], blue1[state], red2[state], green2[state], blue2[state], curAlpha[state]);
}

void TPicButton::inputMouseUp(int x, int y) {
	callMouseUp(x, y);
	state = BTN_UP;
	setColor(red1[state], green1[state], blue1[state], red2[state], green2[state], blue2[state], curAlpha[state]);
}

void TPicButton::setButtonUpColor(GLfloat inred1, GLfloat ingreen1, GLfloat inblue1, 
					GLfloat inred2, GLfloat ingreen2, GLfloat inblue2, GLfloat inAlpha) {
	red1[0] = inred1;
	green1[0] = ingreen1;
	blue1[0] = inblue1;
	
	red2[0] = inred2;
	green2[0] = ingreen2;
	blue2[0] = inblue2;
	curAlpha[0] = inAlpha;
	setColor(red1[state], green1[state], blue1[state], red2[state], green2[state], blue2[state], curAlpha[state]);
}

void TPicButton::setButtonDownColor(GLfloat inred1, GLfloat ingreen1, GLfloat inblue1, 
					GLfloat inred2, GLfloat ingreen2, GLfloat inblue2, GLfloat inAlpha) {
	red1[1] = inred1;
	green1[1] = ingreen1;
	blue1[1] = inblue1;
	
	red2[1] = inred2;
	green2[1] = ingreen2;
	blue2[1] = inblue2;
	curAlpha[1] = inAlpha;
	setColor(red1[state], green1[state], blue1[state], red2[state], green2[state], blue2[state], curAlpha[state]);
}

void TPicButton::show(bool flag) { 
	visible = flag;
}
