/***************************************************************************
                          tplane.cpp  -  basic class that builds a plane
                             -------------------
    begin                : Thu Dec 19 2002
    copyright            : (C) 2002 by Chong Jiayi
    email                : jychong@stanford.edu
 ***************************************************************************/


#include "tplane.h"

TPlane::TPlane(TInfrastructure *curInfrastructure) {
	Initialize(curInfrastructure);
	tileFactor = 1.0f;
	sizeFactorX = 1.0f;
	sizeFactorY = 1.0f;
	sizeFactorZ = 1.0f;
}

TPlane::~TPlane() {
	//object memory clean up
	Cleanup();
}

bool TPlane::Loadable() {
	return false;
}

void TPlane::LoadGeom(char *filename) {
	//ignores filename and builds a plane
	 this->triangleNum = 2;
	 this->vertices = new Vertex[this->triangleNum * 3];
	 this->orthobasis = new OrthoNormalBasis[this->triangleNum * 3];
	 this->vertexConnect = new Connective[this->triangleNum * 3];

	 setVertexPos(0, -1.0f * sizeFactorX, 1.0f * sizeFactorY, 0.0f);
	 setTextureCoords(0, 0.0f, 1.0f * tileFactor);
	 setNormalCoords(0, 0.0f, 0.0f, 1.0f);
	 setBinormalCoords(0, 1.0f, 0.0, 0.0);
	 setTangentCoords(0, 0.0, 1.0f, 0.0);
	 
	 setVertexPos(1, 1.0f * sizeFactorX, 1.0f * sizeFactorY, 0.0f);
	 setTextureCoords(1, 1.0f * tileFactor, 1.0f * tileFactor);
	 setNormalCoords(1, 0.0f, 0.0f, 1.0f);
	 setBinormalCoords(1, 1.0f, 0.0, 0.0);
	 setTangentCoords(1, 0.0, 1.0f, 0.0);
	 
	 setVertexPos(2, 1.0f * sizeFactorX, -1.0f * sizeFactorY, 0.0f);
	 setTextureCoords(2, 1.0f * tileFactor, 0.0f * tileFactor);
	 setNormalCoords(2, 0.0f, 0.0f, 1.0f);
	 setBinormalCoords(2, 1.0f, 0.0, 0.0);
	 setTangentCoords(2, 0.0, 1.0f, 0.0);

	 setVertexPos(4, 1.0f * sizeFactorX, -1.0f * sizeFactorY, 0.0f);
	 setTextureCoords(4, 1.0f * tileFactor, 0.0f);
	 setNormalCoords(4, 0.0f, 0.0f, 1.0f);
	 setBinormalCoords(4, 1.0f, 0.0, 0.0);
	 setTangentCoords(4, 0.0, 1.0f, 0.0);
	 
	 setVertexPos(5, -1.0f * sizeFactorX, -1.0f * sizeFactorY, 0.0f);
	 setTextureCoords(5, 0.0f, 0.0f);
	 setNormalCoords(5, 0.0f, 0.0f, 1.0f);
	 setBinormalCoords(5, 1.0f, 0.0, 0.0);
	 setTangentCoords(5, 0.0, 1.0f, 0.0);
	 
	 setVertexPos(3, -1.0f * sizeFactorX, 1.0f * sizeFactorY, 0.0f);
	 setTextureCoords(3, 0.0f, 1.0f * tileFactor);
	 setNormalCoords(3, 0.0f, 0.0f, 1.0f);
	 setBinormalCoords(3, 1.0f, 0.0, 0.0);
	 setTangentCoords(3, 0.0, 1.0f, 0.0);

//	this->CalculateSphericalOrthoBasis();
	memset(this->vertexConnect, 0, sizeof(Connective) * this->triangleNum * 3);
	this->SetConnectives();
	this->CalculatePlanes();
	this->CalcBounds();
	this->CalculateSphericalOrthoBasis();

}

Vector TPlane::GetNormal() {
	Vector retVec;
	retVec.x = vertexConnect->plane.A; 
	retVec.y = vertexConnect->plane.B; 
	retVec.z = vertexConnect->plane.C; 
	
	return retVec;
}

Plane TPlane::GetPlane() {
	return vertexConnect->plane;
}

