/***************************************************************************
                          tplane.h  -  basic class that builds a plane
                             -------------------
    begin                : Thu Dec 19 2002
    copyright            : (C) 2002 by Chong Jiayi
    email                : jychong@stanford.edu
 ***************************************************************************/


#ifndef TPLANE_H
#define TPLANE_H

#include "tobject.h"

/**
  *@author Chong Jiayi
  */

class TPlane : public TObject {
protected:
	GLfloat tileFactor;
	GLfloat sizeFactorX;
	GLfloat sizeFactorY;
	GLfloat sizeFactorZ;
public: 
	TPlane(TInfrastructure * curInfrastructure);
	~TPlane();
	bool Loadable();
	void LoadGeom(char *filename);
	void SetTileFactor(GLfloat factor) { tileFactor = factor; }
	void SetSizeFactor(GLfloat factorX, GLfloat factorY, GLfloat factorZ) {sizeFactorX = factorX; sizeFactorY = factorY; sizeFactorZ = factorZ;}
	int GetType() const { return PLANE_TYPE; }
	Vector GetNormal();
	Plane GetPlane();
	GLfloat GetTileFactor() const { return tileFactor; }
};

#endif
