/***************************************************************************
                          tscene.h  -  description
                             -------------------
    begin                : Tue Jun 24 2003
    copyright            : (C) 2003 by Chong Jiayi
    email                : jychong@stanford.edu
 ***************************************************************************/


#ifndef TSCENE_H
#define TSCENE_H

#include "tobject.h"
#include "tplane.h"
#include "tmd2.h"
#include "nl.h"

const int IN_FLAG = 0;
const int OUT_FLAG = 1;
const int INTERSECT = 2;
const int LOAD_ERROR = 3;
const int BAD_PARSE = 4;
const int SAVE_ERROR = 5;
const int RENDER_LEVEL0 = 6;
const int RENDER_LEVEL1 = 7;
const int RENDER_LEVEL2 = 8;
const int RENDER_LEVEL3 = 9;

const int LEFT_CLIPPING = 0;
const int RIGHT_CLIPPING = 1;
const int TOP_CLIPPING = 2;
const int BOTTOM_CLIPPING = 3;
const int NEAR_CLIPPING = 4;
const int FAR_CLIPPING = 5;
const int CHROM_REFRACT_TRUE = -9;
const int GLOW_TRUE = 3;

const int FPS_PLAYER = 50;
const int NUM_JITTER_SAMPLES = 16;

const int PLAYER_TYPE = 100;
const int MAIN_RAT_TYPE = 8;
const int GAME_PILLAR_TYPE = 85;


const int ATTACK_MELEE = 0;
const int ATTACK_RANGE = 1;
const int ATTACK_FLAME = 2;

const float MELEE_REACH = 3.0;
const float OUT_OF_RANGE = 99999.0;
const float VIEWER_WIDTH_X = 15.0;
const float VIEWER_WIDTH_Y = 55.0;
const float VIEWER_WIDTH_Z = 15.0;

typedef void (*LoadCallEvent)(void *, char *text);

/**
  *@author Chong Jiayi
  */
struct ObjectPhysics {
	Vector loc;
	Vector vel;
	Vector accel;
	Vector velCap;
	Vector angle;
	Vector angleVel;
	Vector angleAccel;
	Vector angleVelCap;
	Vector resultVel;
};


struct SceneObjInfo {
	TObject * curObject;
	bool visible;
	bool portalCull;
	bool diffuse;
	bool specular;
	int shadow;
	bool attenuate;
	bool reflect;
	float alpha;
	int sectorIndex;
	int sectorLocked;
	int winX1, winY1, winX2, winY2;
	int loadedTObjIndex;
	Vector translate;
	Vector rotate;
	Vector scale;
	Vector rotOffset;
	vector <int> intersectIndex;
	ObjectPhysics physicsPacket;
	GamerPacket gamePacket;
};

struct PortalObj {
	Vector Bound1;
	Vector Bound2;
	Vector Bound3;
	Vector Bound4;
	Vector DstBound1;
	Vector DstBound2;
	Vector DstBound3;
	Vector DstBound4;
	vector <int>link;
	bool processed;
};

struct PortalWindow {
	Vector Bounds1;
	Vector Bounds2;
	Vector Bounds3;
	Vector Bounds4;
	Vector DstBounds1;
	Vector DstBounds2;
	Vector DstBounds3;
	Vector DstBounds4;
	int index1;
	int index2;
};

struct LightPacket {
	Vector LightVec;
	Vector EyeVec;
	Vector dstLightVec;
	Vector dstEyeVec;
	GLfloat r,g,b;
	GLfloat brightness;
	int sectorIndex;
};


struct PMatrix4x4 {
	GLfloat _11, _12, _13, _14;
	GLfloat _21, _22, _23, _24;
	GLfloat _31, _32, _33, _34;
	GLfloat _41, _42, _43, _44;
};


class TScene {

protected:
	TObject *dummyObj;
	float brightness, lightRed, lightGreen, lightBlue;
	int renderLevel;
	vector <TObject *> LoadedTObjects;
	vector <SceneObjInfo> ObjectList;
	vector <PortalObj> PortalList;
	vector <PortalWindow> PortalWindowList;
	vector <LightPacket> LightList;
	vector<GameType> gameObjectTypeList;
	Vector currentLightVec;
	Vector currentEyeVec;
	Vector viewerLoc;
	Vector viewerBounds[8];
	Vector dstViewerBounds[8];
	Vector jitterOffset[NUM_JITTER_SAMPLES];
	Vector spawnPt;
	ObjectPhysics viewerPhysics;
	GLfloat viewerMatrix[16];
	GLfloat inverseViewerMatrix[16];
	TInfrastructure *curInfrastructure;
	bool curPortalSwitch;
	bool reflectSwitch;
	bool blurSwitch;
	bool renderBlurFrame;
	bool portalScissor;
	bool cubeMapSwitch;
	int curSectorIndex;
	unsigned int renderFrameCnt;
	unsigned int frameCnt;
	Plane viewPlane[6];
	Vector nearPlaneCoords3D[4];
	void *callBackObj;
	LoadCallEvent callBackFunc;
	
	void makeSceneCopy();
	void PortalWindowRender();
	void DecalRender();
	void ShadowRender();
	void DiffuseRender();
	void SpecularRender();
	void AttenuateRender();
	void ChromaticRefractRender();
	void DecalSectorRender(int sectorIndex, GLfloat *mat);
	void DiffuseSectorRender(int sectorIndex, GLfloat *mat);
	void SpecularSectorRender(int sectorIndex, GLfloat *mat);
	void AttenuateSectorRender(int sectorIndex, GLfloat *mat);
	void ReflectorsRender();
	void BlurRender();
	void ExtractPlanes();
	void ExtractNearCoords(int cIndex, int index1, int index2, int index3);
	void SectorCull(int index, GLdouble winX1, GLdouble winY1, GLdouble winX2, GLdouble winY2);
	void ClipRect2D(GLdouble *x1, GLdouble *y1, GLdouble *x2, GLdouble *y2, GLdouble winX1, GLdouble winY1, GLdouble winX2, GLdouble winY2);
	void ClipLine2D(Vector *Pnt1, Vector *Pnt2);
	void GetProjectionCoords(TObject *curObject, GLdouble *minX, GLdouble *minY, GLdouble *maxX, GLdouble *maxY, GLdouble *modelMatrix, GLdouble *projMatrix, GLint *viewport);
	void GetWindowProjectionCoords(PortalWindow *curWindow, GLdouble *minX, GLdouble *minY, GLdouble *maxX, GLdouble *maxY, GLdouble *modelMatrix, GLdouble *projMatrix, GLint *viewport);
	void SetObjectPortalScissor(int index);
	int ContainsSphere(TObject *curObject);
	int ContainsBox(TObject *curObject);
	int WithinBounds(Vector *srcBound1, Vector *srcBound2, Vector *dstBound1, Vector *dstBound2);
	int WithinRect(GLdouble srcX, GLdouble srcY, GLdouble dstX1, GLdouble dstY1, GLdouble dstX2, GLdouble dstY2);
	int RectIntersectRect(GLdouble srcX1, GLdouble srcY1, GLdouble srcX2, GLdouble srcY2, GLdouble dstX1, GLdouble dstY1, GLdouble dstX2, GLdouble dstY2);
	float GetObjectDiffuseVal(TObject *curObject);
	void RenderCubeMapFaces(int size, TObject *curObject, int sector, int objIndex);
	void RenderFaceScene(GLenum target, float angle,Vector *midpnt, Vector *axis, int sector, int objIndex, bool flipHoriz);
	void RenderDecalGlow();
	void RenderDiffuseGlow();
	void RenderSpecularGlow();
	void RenderAttenuateGlow();
	void RenderGlowAll();
	void RenderGameSpiritEffects();
	bool GlowExist();
	
	//collision detection routines
	bool OBBIntersect(TObject *obj1, TObject *obj2);
	void UpdateViewerBounds();
	
	//shadow optimization routines
	bool isZpass(Vector *curLight, TObject *curObject);
	void castScissorsShadow(TObject *curObject, Vector *curLight, bool zPass, float brightness);
	
	//other routines
	TMd2 * LoadedMd2(char *filename);
	float getObjectSpawnY(TObject *curObject, float offset, float scale);
	Vector tryToSpawn(Vector curPt, TObject *curObject, float size, int index);
	Vector mustSpawnRandom(TObject *curObject, float size, int index);
	float getMinSpawnY();
	void cleanUpTObjects(int index);

	int pillarCnt;
		
private:
	NLmutex renderMutex;
	float itemsSpawnY;
	
public: 
	TScene(TInfrastructure *theInfrastructure);
	~TScene();
	void AttachObject(TObject *curObject, Vector translate, Vector scale, Vector rotate, int shadow, bool specular,
		 bool diffuse, bool attenuate, int sectorIndex, bool reflect, 
		 float alphaval, int gameType, Vector *rotOffset, int team);
	int GetObjectNum() const { return ObjectList.size(); }
	void SetLighting(Vector lightVec, Vector eyeVec, float brightlevel, float r, float g, float b);
	void RecalcSectorPos();
	void PrepareSceneForCulling();
	void PrepareSceneForPortalCulling();
	void FrustrumCull();
	void RenderAll();
	void GlowRender();
	void RestoreSceneObjectsTransform();
	void ApplyMd2PhysicsTransform();
	void PrepareViewerTransform();
	void EndViewerTransform();
	void ApplyViewerTransform();
	void MoveViewerDelta(GLfloat dispX, GLfloat dispY, GLfloat dispZ, GLfloat rotX, GLfloat rotY, GLfloat rotZ);
	void MoveViewerDelta2(GLfloat dispX, GLfloat dispY, GLfloat dispZ, GLfloat rotX, GLfloat rotY, GLfloat rotZ);
	void TryMoveViewerDelta(GLfloat dispX, GLfloat dispY, GLfloat dispZ, GLfloat rotX, GLfloat rotY, GLfloat rotZ);  
	void ApplyViewerAccel(GLfloat accelX, GLfloat accelY, GLfloat accelZ, GLfloat rotX, GLfloat rotY, GLfloat rotZ);
	Vector GetViewerMoveDelta(GLfloat dispX, GLfloat dispY, GLfloat dispZ, GLfloat rotX, GLfloat rotY, GLfloat rotZ);
	void StopViewerPhysics(bool xTrue, bool yTrue, bool zTrue);
	void TryMoveViewerPhysics();
	void DoLightingCalc();
	void LinkSector(int index1, int index2, int windowIndex);
	void PortalCull();
	void SetPortalScissor(bool flag) { portalScissor = flag; }
	void SetRenderLevel(int level) {renderLevel = level; }
	void SetViewerBounds(GLfloat width, GLfloat height, GLfloat depth);
	void RenderSkyBox(float scale);
	void SetBlurSwitch(bool flag) {blurSwitch = flag; }
	
	void SetLight(Vector lightVec, Vector eyeVec, float brightlevel, float r, float g, float b, int sectorIndex, int index);
	int AddLight(Vector lightVec, Vector eyeVec, float brightlevel, float r, float g, float b, int sectorIndex);
	
	int AddSector(Vector Bound1, Vector Bound2);
	int AddWindow(Vector Bound1, Vector Bound2);
	void AddGameUnitDefine(char * name, char * md2_Filename, int type, int attackType, int damage, int buildtime, int health,
						float moveVel, float turnVel, int cost, float size, float range);
	int LoadUnitInfoFile(char *filename);
	GameType GetUnitInfo(int type);
	
	int LoadItemsFile(char *filename);
	void ReSpawnItems();
	void SetItemsSpawnY(float y) { itemsSpawnY = y; }
	void AnimateItems();
						
	int LoadSceneFile(char *filename);
	int SaveSceneFile(char *filename);
	TObject *GetObject(int index) { return ObjectList[index].curObject; }
	bool GetObjectVisible(int index) {return ObjectList[index].visible; }
	Vector GetViewerMidPnt();
	
	void SetCallBack(void *obj, LoadCallEvent curCall) { callBackObj = obj; callBackFunc = curCall; }
};

#endif
