/***************************************************************************
                          twidget.h  -  description
                             -------------------
    begin                : Mon Jul 28 2003
    copyright            : (C) 2003 by Chong Jiayi
    email                : jychong@stanford.edu
 ***************************************************************************/


#ifndef TWIDGET_H
#define TWIDGET_H

#include "twidgetrender.h"

const int WINDOW_TYPE = 0;
const int BUTTON_TYPE = 1;
const int LABEL_TYPE = 2;
const int BTN_UP = 0;
const int BTN_DOWN = 1;

/**
  *@author Chong Jiayi
  */
typedef void (*WidgetMouseDownEvent)(void *, int, int);
typedef void (*WidgetMouseUpEvent)(void *, int, int);
  
class TWidget {
protected:
	int x, y, width, height;
	GLfloat r1, g1, b1, r2, g2, b2, alpha;
	GLfloat renderAlpha;
	TInfrastructure *curInfrastructure;
	bool visible;
	int miscVal;
	void *miscObj;
	WidgetMouseDownEvent mouseDownFuncPtr;
	WidgetMouseUpEvent mouseUpFuncPtr;
	void *WidgetCallObject;
	
	bool withinBoundary(int curX, int curY, int x1, int y1, int x2, int y2);


public: 
	void Initialize(TInfrastructure *theInfrastructure);
	
	void setDimensions(int curX, int curY, int curWidth, int curHeight);
	void setColor(GLfloat red1, GLfloat green1, GLfloat blue1, GLfloat red2, GLfloat green2, 
				GLfloat blue2, GLfloat curAlpha);
	virtual void show(bool flag) = 0;
	void setMouseDownFunction(WidgetMouseDownEvent f) { mouseDownFuncPtr = f;}
	void setMouseUpFunction(WidgetMouseUpEvent f) { mouseUpFuncPtr = f;}
	void setWidgetCallObject(void *obj) { WidgetCallObject = obj; }
	
	virtual void inputMouseDown(int x, int y) = 0;
	virtual void inputMouseUp(int x, int y) = 0;
	
	void callMouseDown(int clickX, int clickY);
	void callMouseUp(int clickX, int clickY);
	bool isVisible() { return visible; }
	
	void setMiscVal(int val) { miscVal = val; }
	int getMiscVal() { return miscVal; }
	void setMiscObj(void *obj) { miscObj = obj; }
	void * getMiscObj() { return miscObj; }
	
	int getX1() const { return x; }
	int getY1() const { return y; }
	int getX2() const { return x + width; }
	int getY2() const { return y + height; }
	
	virtual void render(int X, int Y) = 0;
	virtual int getType() = 0;
};

#endif
