/***************************************************************************
                          twidgetmanager.cpp  -  description
                             -------------------
    begin                : Mon Jul 28 2003
    copyright            : (C) 2003 by Chong Jiayi
    email                : jychong@stanford.edu
 ***************************************************************************/


#include "twidgetmanager.h"

TWidgetManager::TWidgetManager(TInfrastructure *theInfrastructure){
	curInfrastructure = theInfrastructure;
}

TWidgetManager::~TWidgetManager(){
}

void TWidgetManager::prepareRender() {
	glMatrixMode( GL_PROJECTION );
		glPushMatrix();
		glLoadIdentity();
		glOrtho(0, curInfrastructure->GetWinWidth(), 0, curInfrastructure->GetWinHeight(), -1, 1);
	
	glMatrixMode(GL_MODELVIEW);
		glPushMatrix();
		glLoadIdentity();
		glTranslated(0, 0, 0);

	glActiveTextureARB( GL_TEXTURE1_ARB );
	glDisable( GL_TEXTURE_CUBE_MAP_ARB );
	glDisable( GL_TEXTURE_2D );

	glActiveTextureARB( GL_TEXTURE0_ARB );
	glDisable( GL_TEXTURE_CUBE_MAP_ARB );

	glDisable(GL_REGISTER_COMBINERS_NV);
	glEnable(GL_TEXTURE_2D);
	glDepthFunc(GL_LEQUAL);

	glDisable(GL_LIGHTING);
	
	glDisable(GL_STENCIL_TEST);
	glDisable(GL_DEPTH_TEST);
	glDepthMask(GL_FALSE);
	
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_COLOR);
	glDisable(GL_CULL_FACE );
}

void TWidgetManager::endRender() {
	glMatrixMode(GL_PROJECTION);
	glPopMatrix();
	glMatrixMode(GL_MODELVIEW);
	glPopMatrix();
	glDisable(GL_BLEND);
	glDepthMask(GL_TRUE);
	glEnable(GL_DEPTH_TEST);
	glEnable(GL_CULL_FACE );
}

void TWidgetManager::AttachWidget(TWidget *curWidget) {
	widgetList.push_back(curWidget);
}

bool TWidgetManager::withinBoundary(int curX, int curY, int x1, int y1, int x2, int y2) {
	if(curX >= x1 && curX <= x2 && curY >= y1 && curY <= y2) return true;
	
	return false;
}


void TWidgetManager::renderWidgets() {
	prepareRender();
	
	for(int i = 0; i < widgetList.size(); i++) {
		widgetList[i]->render(0, 0);
	}
	
	endRender();
}

void TWidgetManager::mouseDownProcess(int x, int y) {
	
	for(int i = 0; i < widgetList.size(); i++) {
		if( withinBoundary(x, y, widgetList[i]->getX1(), widgetList[i]->getY1(), widgetList[i]->getX2(), 
						widgetList[i]->getY2() ) && widgetList[i]->isVisible()) {
			widgetList[i]->inputMouseDown(x, y);
		}
	}
}

void TWidgetManager::mouseUpProcess(int x, int y) {

	
	for(int i = 0; i < widgetList.size(); i++) {
		if( withinBoundary(x, y, widgetList[i]->getX1(), widgetList[i]->getY1(), widgetList[i]->getX2(), 
						widgetList[i]->getY2() ) && widgetList[i]->isVisible()) {
			widgetList[i]->inputMouseUp(x, y);
			return;
		}
	}
}


