/***************************************************************************
                          twidgetwindow.cpp  -  description
                             -------------------
    begin                : Mon Jul 28 2003
    copyright            : (C) 2003 by Chong Jiayi
    email                : jychong@stanford.edu
 ***************************************************************************/


#include "twidgetwindow.h"

TWidgetWindow::TWidgetWindow(TInfrastructure *theInfrastructure) {
	Initialize(theInfrastructure);
	
	curRender = new TWidgetRender(theInfrastructure);
	loaded = false;
}

TWidgetWindow::~TWidgetWindow(){
	delete curRender;
}

void TWidgetWindow::render(int X, int Y) {
	if(!loaded) {
		curRender->loadTexture("border1.tga");
		loaded = true;
	}
	
	if(!visible) {
		if(renderAlpha > 0.0) {
			renderAlpha = renderAlpha - 0.1;
		}
	}
	else {
		if(renderAlpha < alpha) {
			renderAlpha = renderAlpha + 0.1;
		}
	}

	curRender->selectTexture();	
	curRender->renderRect(CLASSIC_STYLE, this->x + X, this->y + Y, this->width, this->height,
					r1, g1, b1, r2, g2, b2, renderAlpha); 
		
	if(containList.size() > 0) {
		for(int i = 0; i < containList.size(); i++) {
			containList[i]->render(this->x + X, this->y + Y);
		}
	}
	

					
}

void TWidgetWindow::inputMouseDown(int x, int y) {
	for(int i = 0; i < containList.size(); i++) {
		if( withinBoundary(x - getX1(), y - getY1(), containList[i]->getX1(), containList[i]->getY1(), containList[i]->getX2(),
						containList[i]->getY2()) && containList[i]->isVisible()) {
			containList[i]->inputMouseDown(x- getX1(), y - getY1());
			return;
		}
	}
	
	callMouseDown(x, y);
}

void TWidgetWindow::inputMouseUp(int x, int y) {
	for(int i = 0; i < containList.size(); i++) {
		if( withinBoundary(x - getX1() , y - getY1(), containList[i]->getX1(), containList[i]->getY1(), 
		containList[i]->getX2(), containList[i]->getY2() )  && containList[i]->isVisible()) {
			containList[i]->inputMouseUp(x - getX1(), y - getY1());
			return;
		}
	}
	
	callMouseUp(x, y);
}

void TWidgetWindow::show(bool flag) { 
	visible = flag;
	
	for(int i = 0; i < containList.size(); i++) {
		containList[i]->show(flag);
	}
}



