/***************************************************************************
                          vectorutils.h  -  description
                             -------------------
    begin                : Tue Dec 17 2002
    copyright            : (C) 2002 by Chong Jiayi
    email                : jychong@stanford.edu
 ***************************************************************************/


#ifndef VECTORUTILS_H
#define VECTORUTILS_H

#include "math.h"
#include "extgl.h"

const float MATH_PI = 3.1415926535897932384626433832795;

/**
  *@author Chong Jiayi
  */

typedef struct _Vector {
	GLfloat x;
	GLfloat y;
	GLfloat z;

	bool operator== (const struct _Vector &v) const
	{
		return (x == v.x && y == v.y && z == v.z);
	}
} Vector;

typedef struct {
	GLfloat A;
	GLfloat B;
	GLfloat C;
	GLfloat D;
} Plane;

extern void Vzero(float *v);
extern void Vset(Vector *v, float x, float y, float z);
extern void Vsub(Vector *src1, Vector *src2, Vector *dst);
extern void Vcopy(const Vector *v1, Vector *v2);
extern void Vcross(Vector *v1, Vector *v2, Vector *cross);
extern float Vsqlength(const Vector *v);
extern float Vlength(const Vector *v);
extern void Vscale(Vector *v, float div);
extern void Vnormal(Vector *v);
extern float Vdot(const Vector *v1, const Vector *v2);
extern void Vadd(Vector *src1, Vector *src2, Vector *dst);
extern bool Vequal(const Vector *v1, const Vector *v2);
extern void Vinterpolate(Vector *from, Vector *to, Vector *result, int smoothness, int index);
extern float invSqrt(float x);
extern float Sqrt(float x);
extern void makeInverseSqrtLookupTable(void);
extern GLboolean invertMatrixf(GLfloat *out, const GLfloat *m);
extern void buildLookAtMatrix(GLdouble m[16], Vector eye, Vector center, Vector up);
extern void buildPerspectiveMatrix(GLdouble m[16], GLdouble fovy, GLdouble aspect, GLdouble zNear, GLdouble zFar);
extern void transformVector(Vector *out, Vector *in, float m[16]);
extern void makePlane(Vector *in1, Vector *in2, Vector *in3, Plane * outPlane);
extern void makeQuickPlane(Vector *in1, Vector *in2, Vector *in3, Plane * outPlane);
extern float vecPlaneOrientation(Vector *vec, Plane *plane);
extern void PlaneInterpolate(Plane *from, Plane *to, Plane *result, int smoothness, int index);
extern void normalizePlane(Plane *inPlane);
extern void printVector(Vector *vec, char *title);
extern float fast_sqrt(float n);

#endif
