// realistic.cc

#include "camera.h"
#include "paramset.h"
#include "film.h"


class RealisticCamera : public Camera {
public:
  RealisticCamera(const Transform &world2cam,
		  float hither, float yon, float sopen,
		  float sclose, float filmdistance, float aperture_diameter, string specfile,
		  float filmdiag, Film *film);
  float GenerateRay(const Sample &sample, Ray *) const;
  
private:
};

RealisticCamera::RealisticCamera(const Transform &world2cam,
				 float hither, float yon, 
				 float sopen, float sclose, 
				 float filmdistance, float aperture_diameter, string specfile, 
				 float filmdiag, Film *f)
	: Camera(world2cam, hither, yon, sopen, sclose, f) 
{
   // YOUR CODE HERE -- build and store datastructures representing the given lens
   // and film placement.
}

float RealisticCamera::GenerateRay(const Sample &sample, Ray *ray) const {
  // YOUR CODE HERE -- make that ray!
  
  // use sample->imageX and sample->imageY to get raster-space coordinates
  // of the sample point on the film.
  // use sample->lensU and sample->lensV to get a sample position on the lens
   return 0;
}


extern "C" DLLEXPORT Camera *CreateCamera(const ParamSet &params,
		const Transform &world2cam, Film *film) {
	// Extract common camera parameters from \use{ParamSet}
	float hither = params.FindOneFloat("hither", -1);
	float yon = params.FindOneFloat("yon", -1);
	float shutteropen = params.FindOneFloat("shutteropen", -1);
	float shutterclose = params.FindOneFloat("shutterclose", -1);

	// Realistic camera-specific parameters
	string specfile = params.FindOneString("specfile", "");
	float filmdistance = params.FindOneFloat("filmdistance", 70.0); // about 70 mm default to film
 	float fstop = params.FindOneFloat("aperture_diameter", 1.0);	
	float filmdiag = params.FindOneFloat("filmdiag", 35.0);

	Assert(hither != -1 && yon != -1 && shutteropen != -1 &&
		shutterclose != -1 && filmdistance!= -1);
	if (specfile == "") {
	    Severe( "No lens spec file supplied!\n" );
	}
	return new RealisticCamera(world2cam, hither, yon,
				   shutteropen, shutterclose, filmdistance, fstop, 
				   specfile, filmdiag, film);
}
