
#ifndef TRIMESH_H
#define TRIMESH_H
#include "primitives.h"

class TriangleMesh:public Primitive {
  public:

	TriangleMesh(int ntris, int nverts, int *vptr, Point * P,
				 PrimitiveAttributes * a, SurfaceFunction * v);
	~TriangleMesh();

	BBox BoundObjectSpace() const;

	BBox BoundWorldSpace() const;

	bool CanIntersect() const {
		return false;
	} void Refine(vector < Primitive * >*refined) const;

	friend class Triangle;

  protected:
	 int ntris;
	int nverts;
	int *vertexIndex;
	Point *p;

};

class Triangle:public Primitive { public:
	 Triangle(const TriangleMesh * m, int n)
	:Primitive(m->attributes, NULL) {
		attributes->Reference();
		mesh = m;
		triNum = n;
	} BBox BoundObjectSpace() const;
	BBox BoundWorldSpace() const;

	bool IntersectClosest(const Ray & ray, Float mint, Float * maxt,
						  HitInfo * hit) const;

  private:

	const TriangleMesh *mesh;
	int triNum;

};

#endif // TRIMESH_H
