
#ifndef ACCEL_H
#define ACCEL_H
#include "lrt.h"

class Accelerator {
  public:
	virtual ~ Accelerator();

	virtual bool IntersectClosest(const Ray & ray, Float mint,
								  Float * maxt, HitInfo * hit) = 0;

};

class ListAccelerator:public Accelerator {
  public:

	ListAccelerator(const vector < Primitive * >&primitives);
	bool IntersectClosest(const Ray & ray, Float mint,
						  Float * maxt, HitInfo * hit);

	 vector < Primitive * >primitives;

};

class GridAccelerator:public Accelerator {
  public:

	GridAccelerator(const vector < Primitive * >&primitives);

	int x2v(Float x) const {
		return int ((x - bbox.pMin.x) * InvXWidth);
	} int y2v(Float y) const {
		return int ((y - bbox.pMin.y) * InvYWidth);
	} int z2v(Float z) const {
		return int ((z - bbox.pMin.z) * InvZWidth);
	} Float v2x(int x) const {
		return x * XWidth + bbox.pMin.x;
	} Float v2y(int y) const {
		return y * YWidth + bbox.pMin.y;
	} Float v2z(int z) const {
		return z * ZWidth + bbox.pMin.z;
	} ~GridAccelerator();

	bool IntersectClosest(const Ray & ray, Float mint, Float * maxt,
						  HitInfo * hit);

  private:

	 BBox bbox;

	int XVoxels, YVoxels, ZVoxels;

	Float XWidth, YWidth, ZWidth;
	Float InvXWidth, InvYWidth, InvZWidth;

	 list < Primitive * >*cells;

	void addPrimitivesToVoxels(const vector < Primitive * >&primtives);


};

struct HBVNode {
	HBVNode(const pair < Primitive *, BBox * >&prim);
	 HBVNode(HBVNode * child1, HBVNode * child2);
	~HBVNode();
	BBox bounds;
	bool isLeaf;
	union {
		HBVNode *children[2];
		const Primitive *primitive;
	};
};


class HBVAccelerator:public Accelerator { public:
	 HBVAccelerator(const vector < Primitive * >&primitives);

	~HBVAccelerator();

	bool IntersectClosest(const Ray & ray, Float mint, Float * maxt,
						  HitInfo * hit);

  private:

	static HBVNode *BuildHBV(const vector < Primitive * >&primitives);

	static HBVNode *RecursiveBuild(const vector<pair<Primitive *, BBox *> > &primitives);

	static int XPartition(vector<pair<Primitive *, Point> > &prims, int start, int end);

	static bool RecursiveIntersect(HBVNode * &node, const Ray & ray,
								   Float mint, Float * maxt,
								   HitInfo * hit);

	HBVNode *root;

};

#endif // ACCEL_H
