/***************************************************************************
                          caustic.cc  -  description
                             -------------------
    begin                : Sun Sep 2 2001
    copyright            : (C) 2001 by root
    email                : emerald1101@home.com
 ***************************************************************************/
#include <stdio.h>
#include <malloc.h>
#include <stdlib.h>
#include "lrt.h"
#include "primitives.h"
#include "accel.h"
#include "color.h"
#include "light.h"
#include "scene.h"
#include "reflection.h"
#include "sampling.h"
#include "shading.h"
#include "transport.h"
#include "caustic.h"
#include "trimesh.h"

#define AREA_LIMIT 1000.
#define TOTAL_INTENSITY 350000

extern Normal curNormal;
extern Normal bumpNormal;
extern BRDF *curBRDF;
int areaReject;
int xReject;

Caustic::Caustic(){
	FILE *fn;
	int nr;
	
	PreProcFH = NULL;
	fn = fopen("caustic.def", "rb");
	if (!fn){
		printf("Can't open caustic.def.\n");
	  exit(0);
	}
	else{		// read the caustic file
		fread(&dw, sizeof(int), 1, fn);
		fread(&dh, sizeof(int), 1, fn);
		fread(&sw, sizeof(float), 1, fn);
		fread(&sh, sizeof(float), 1, fn);
		fread(&x, sizeof(float), 1, fn);
		fread(&y, sizeof(float), 1, fn);
		fread(&z, sizeof(float), 1, fn);
		fread(&howmany, sizeof(int), 1, fn);

		facetI = (TOTAL_INTENSITY*sw*sh)/((float)dw*(float)dh);
	
		bl = (beam *)malloc(howmany*sizeof(beam));
		nr = fread(bl, sizeof(beam), howmany, fn);
		if (nr < howmany){
			printf("caustic.def is short.  Beams not fully defined.\n");
			exit(0);
		}
		readPreProc = 1;
		fclose(fn);
	}
}

Caustic::~Caustic(){
	free(bl);
}

bool Caustic::PtInTri(Point &p, Point &t1, Point &t2, Point &t3){
	Vector v1, v2;
	Vector Np, N1, N2, N3;
	
	v1.x = t2.x-t1.x;
	v1.y = t2.y-t1.y;
	v1.z = t2.z-t1.z;
	v2.x = t3.x-t1.x;
	v2.y = t3.y-t1.y;
	v2.z = t3.z-t1.z;
	Np = Cross(v1, v2);
	Np.Normalize();

	v2.x = p.x-t1.x;
	v2.y = p.y-t1.y;
	v2.z = p.z-t1.z;
	v1.x = t2.x-t1.x;
	v1.y = t2.y-t1.y;
	v1.z = t2.z-t1.z;
	N1 = Cross(v1, v2);
	N1.Normalize();
	
	if (Dot(N1, Np) < 0.95) return false;

	
	v2.x = p.x-t2.x;
	v2.y = p.y-t2.y;
	v2.z = p.z-t2.z;
	v1.x = t3.x-t2.x;
	v1.y = t3.y-t2.y;
	v1.z = t3.z-t2.z;
	N2 = Cross(v1, v2);
	N2.Normalize();
	
	if (Dot(N2, Np) < 0.95) return false;

	v2.x = p.x-t3.x;
	v2.y = p.y-t3.y;
	v2.z = p.z-t3.z;
	v1.x = t1.x-t3.x;
	v1.y = t1.y-t3.y;
	v1.z = t1.z-t3.z;
	N3 = Cross(v1, v2);
	N3.Normalize();
	
	if (Dot(N3, Np) < 0.95) return false;

	return true;
}

bool Caustic::SegCross(Point &O1, Point &D1, Point &O2, Point &D2){
	float t1, t2;
	
	t2 = (D1.x*O1.y+D1.y*O2.x-D1.y*O1.x-D1.x*O2.y)/(D1.x*D2.y-D1.y*D2.x);
	
	if ((t2 < 0)||(t2 > 1)) return false;
	
	t1 = (O2.x+D2.x*t2-O1.x)/D1.x;

	if ((t1 < 0)||(t1 > 1)) return false;
	
	return true;
}

Point *Caustic::BeamTriIntersect(beam *bm, Point &p1, Point &p2, Point &p3){
	Point *bt=NULL;

	Vector v1(p1.x-p2.x, p1.y-p2.y, p1.z-p2.z);
	Vector v2(p3.x-p2.x, p3.y-p2.y, p3.z-p2.z);
	Vector N = Cross(v1, v2);
	
	float ND1 = bm->D1[0]*N.x + bm->D1[1]*N.y + bm->D1[2]*N.z;
	if (ND1 == 0) return NULL;	// infinitely large triangle = no light contrib

	float ND2 = bm->D2[0]*N.x + bm->D2[1]*N.y + bm->D2[2]*N.z;
	if (ND2 == 0) return NULL;
	
	float ND3 = bm->D3[0]*N.x + bm->D3[1]*N.y + bm->D3[2]*N.z;
	if (ND3 == 0) return NULL;
	
	float d = -N.x*p1.x - N.y*p1.y - N.z*p1.z;
	
	// t = -(d+dot(N,O))/dot(N,D)
	float t1 = -(N.x*bm->O1[0]+N.y*bm->O1[1]+N.z*bm->O1[2]+d)/ND1;
	float t2 = -(N.x*bm->O2[0]+N.y*bm->O2[1]+N.z*bm->O2[2]+d)/ND2;
	float t3 = -(N.x*bm->O3[0]+N.y*bm->O3[1]+N.z*bm->O3[2]+d)/ND3;
	
	bt = (Point *)malloc(3*sizeof(Point));

	// calc beam triangle points	
	bt[0].x = bm->O1[0] + t1*bm->D1[0];
	bt[0].y = bm->O1[1] + t1*bm->D1[1];
	bt[0].z = bm->O1[2] + t1*bm->D1[2];
	
	bt[1].x = bm->O2[0] + t2*bm->D2[0];
	bt[1].y = bm->O2[1] + t2*bm->D2[1];
	bt[1].z = bm->O2[2] + t2*bm->D2[2];
	
	bt[2].x = bm->O3[0] + t3*bm->D3[0];
	bt[2].y = bm->O3[1] + t3*bm->D3[1];
	bt[2].z = bm->O3[2] + t3*bm->D3[2];
	
	// check if beam triangle in triangle	
	if (PtInTri(bt[0], p1, p2, p3)) return bt;
	if (PtInTri(bt[1], p1, p2, p3)) return bt;
	if (PtInTri(bt[2], p1, p2, p3)) return bt;
	
	// check for segments crossing
	if (SegCross(bt[0], bt[1], p1, p2)) return bt;
	if (SegCross(bt[0], bt[1], p2, p3)) return bt;
	if (SegCross(bt[0], bt[1], p3, p1)) return bt;
	
	// triangle points in beam triangle?
	if (PtInTri(p1, bt[0], bt[1], bt[2])) return bt;
	if (PtInTri(p2, bt[0], bt[1], bt[2])) return bt;
	if (PtInTri(p3, bt[0], bt[1], bt[2])) return bt;
	
	// check for segments crossing
	if (SegCross(bt[1], bt[2], p1, p2)) return bt;
	if (SegCross(bt[1], bt[2], p2, p3)) return bt;
	if (SegCross(bt[1], bt[2], p3, p1)) return bt;
	
	if (SegCross(bt[2], bt[0], p2, p3)) return bt;
	if (SegCross(bt[2], bt[0], p1, p2)) return bt;
	if (SegCross(bt[2], bt[0], p3, p1)) return bt;
	
	free(bt);
	return NULL;
}

Point *Caustic::getBeamList(Point &p1, Point &p2, Point &p3, int *numInt,
														int **outbl){
	int i, j;
	Point *o_b = NULL;
	int *o_ob = NULL;
	Point *retP;
	Vector v1, v2, v3;
	float dotP;
	
	if (readPreProc){
		if (!PreProcFH)
			PreProcFH = fopen("preproc.bin", "rb");
		if (!PreProcFH){
			printf("Unable to open caustic definition files.\n");
			exit(0);
		}
		fread(numInt, sizeof(int), 1, PreProcFH);
		o_ob = (int *)malloc(sizeof(int)*(*numInt));
		o_b = (Point *)malloc(3*sizeof(Point)*(*numInt));
		fread(o_ob, sizeof(int), *numInt, PreProcFH);
		fread(o_b, sizeof(Point), 3*(*numInt), PreProcFH);		
		*outbl = o_ob;
		
		return o_b;
	}
	*numInt=0;
	areaReject = 0;
	xReject = 0;
	for (i = 0; i < howmany; i++){
		// if beam and triangle don't face each other then move on to next beam
		v1.x = p2.x - p1.x;
		v1.y = p2.y - p1.y;
		v1.z = p2.z - p1.z;
		v2.x = p3.x - p1.x;
		v2.y = p3.y - p1.y;
		v2.z = p3.z - p1.z;
		v3 = Cross(v1, v2);
		dotP = bl[i].D1[0]*v3.x + bl[i].D1[1]*v3.y + bl[i].D1[2]*v3.z;
		if (dotP >= 0) {
			xReject++;
			continue;
		}
		
		retP=BeamTriIntersect(bl+i, p1, p2, p3);
		if (retP){
			v1.x = retP[0].x - retP[1].x;
			v1.y = retP[0].y - retP[1].y;
			v1.z = retP[0].z - retP[1].z;
			v2.x = retP[2].x - retP[1].x;
			v2.y = retP[2].y - retP[1].y;
			v2.z = retP[2].z - retP[1].z;
			v3 = Cross(v1, v2);
			if (v3.Length() > AREA_LIMIT){	// forget it.. projected area too big
				areaReject++;
				continue;
			}
			(*numInt)++;
			o_b = (Point *)realloc(o_b, 3*(*numInt)*sizeof(Point));
			o_ob = (int *)realloc(o_ob, (*numInt)*sizeof(int));
			o_ob[(*numInt)-1] = i;
			o_b[3*((*numInt)-1)].x = retP[0].x;
			o_b[3*((*numInt)-1)].y = retP[0].y;
			o_b[3*((*numInt)-1)].z = retP[0].z;
			o_b[3*((*numInt)-1)+1].x = retP[1].x;
			o_b[3*((*numInt)-1)+1].y = retP[1].y;
			o_b[3*((*numInt)-1)+1].z = retP[1].z;
			o_b[3*((*numInt)-1)+2].x = retP[2].x;
			o_b[3*((*numInt)-1)+2].y = retP[2].y;
			o_b[3*((*numInt)-1)+2].z = retP[2].z;
			free(retP);
		}
	}
	
	// append to the current file
	PreProcFH = fopen("preproc.bin", "ab");
	if (!PreProcFH){
		printf("Unable to open caustic definition file to write results.\n");
		exit(0);
	}
	fwrite(numInt, sizeof(int), 1, PreProcFH);
	fwrite(o_ob, sizeof(int), *numInt, PreProcFH);
	fwrite(o_b, sizeof(Point), 3*(*numInt), PreProcFH);
	fclose(PreProcFH);
	
	*outbl = o_ob;

	return o_b;
}

Spectrum Caustic::getC(Triangle *tri, HitInfo *hit, Point *pl, int numB){
	int i, nB;
	Spectrum contrib(0.);
	Point *b;
	Point centroid;
	int *o_bl;	// original beam list indicies
	Vector wi;
	
	b = tri->bl;
	o_bl = tri->beaml;
	nB = 0;
	// for each beam that hits the primitive
	for (i = 0; i < numB; i++){
		if (PtInTri(hit->Pobj, b[3*i], b[3*i+1], b[3*i+2])){
	
			// for now choose the center of the triangle
			centroid.x = (bl[o_bl[i]].O1[0] + bl[o_bl[i]].O2[0] +
										bl[o_bl[i]].O3[0])/3.0;	
			centroid.y = (bl[o_bl[i]].O1[1] + bl[o_bl[i]].O2[1] +
										bl[o_bl[i]].O3[1])/3.0;	
			centroid.z = (bl[o_bl[i]].O1[2] + bl[o_bl[i]].O2[2] +
										bl[o_bl[i]].O3[2])/3.0;

			if (!scene->Unoccluded(hit->Pobj, centroid))
				continue;
			// if no shadow ray

			Vector wi;

 			wi.x = centroid.x - hit->Pobj.x;	
 			wi.y = centroid.y - hit->Pobj.y;	
 			wi.z = centroid.z - hit->Pobj.z;
			float distance = wi.Length();
			wi = wi.Hat();

			int n = tri->triNum;
			int p1 = tri->mesh->vertexIndex[3*n];
			int p2 = tri->mesh->vertexIndex[3*n+1];
			int p3 = tri->mesh->vertexIndex[3*n+2];

#ifdef TEST
			Vector x1(tri->mesh->p[p2].x - tri->mesh->p[p1].x, 
				  tri->mesh->p[p2].y - tri->mesh->p[p1].y,
				  tri->mesh->p[p2].z - tri->mesh->p[p1].z);
			Vector x2(tri->mesh->p[p3].x - tri->mesh->p[p1].x, 
				  tri->mesh->p[p3].y - tri->mesh->p[p1].y,
				  tri->mesh->p[p3].z - tri->mesh->p[p1].z);
			Vector x3 = Cross(x1, x2); 

			Normal Nw;
			Nw.x = x3.x;
			Nw.y = x3.y;
			Nw.z = x3.z;
			Nw = Nw.Hat();
#endif
			bumpNormal = bumpNormal.Hat();
			Vector v1(b[3*i].x-b[3*i+1].x, b[3*i].y-b[3*i+1].y,
								b[3*i].z-b[3*i+1].z);		
			Vector v2(b[3*i+2].x-b[3*i+1].x, b[3*i+2].y-b[3*i+1].y,
								b[3*i+2].z-b[3*i+1].z);	
			Vector v3 = Cross(v1, v2);
	
			nB++;
			distance = (7.5-distance)/7.5;
			if (distance < 0) distance = 0;
			contrib += distance*curBRDF->fr(wi)*Dot(wi, bumpNormal)*facetI/(v3.Length());

//		if ((contrib.s[0] >= 1)&&
//			(contrib.s[1] >= 1)&&
//			(contrib.s[2] >= 1))
//			break;
		}
	}
			
	return contrib;
}
