/***************************************************************************
                          caustic.h  -  description
                             -------------------
    begin                : Sun Sep 2 2001
    copyright            : (C) 2001 by root
    email                : emerald1101@home.com
 ***************************************************************************/
#ifndef CAUSTIC_H
#define CAUSTIC_H

class Triangle;

typedef struct bm{
	float O1[3];		// origin of vertex1
	float O2[3];		// origin of vertex2
	float O3[3];		// origin of vertex3
	float D1[3];		// vector of vertex1
	float D2[3];		// vector of vertex2
	float D3[3];		// vector of vertex3
} beam;

class Caustic {
public:
	Caustic();
	~Caustic();
	Point *getBeamList(Point &, Point &, Point &, int *, int **);
	Spectrum getC(Triangle *, HitInfo *, Point *, int);

private:
	int readPreProc;
	int dw;					// number of divisions
	int dh;
	float sw, sh;		// scale factor
	float x, y, z;	// location of lower left of caustic field
	float facetI;		// light intensity at each facet
	int howmany;		// how many beams in the file
	beam *bl;				// list of the beams created by the hf
	FILE *PreProcFH;
	
	bool Caustic::PtInTri(Point &, Point &, Point &, Point &);
	bool Caustic::SegCross(Point &, Point &, Point &, Point &);
	Point *BeamTriIntersect(beam *, Point &, Point &, Point &);
};
#endif

