#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <math.h>

typedef struct bm{
	float O1[3];		// origin of vertex1
	float O2[3];		// origin of vertex2
	float O3[3];		// origin of vertex3
	float D1[3];		// vector of vertex1
	float D2[3];		// vector of vertex2
	float D3[3];		// vector of vertex3
} beam;

#define SCALE_H 1
#define TPI 2*M_PI
#define pointNorms

void calcHeights(int, int, float *);
void calcNorms(int, int, float *, float *);
beam *calcBeams(int, int, float *, float *);

float sx = 0.20;
float sy = 0.20;
float tx = 8;
float ty = -15;
float tz = 0;
int howmany = 0;

void main(void){
	int dw = 150;
	int dh = 150;
	float x = 0;
	float y = 0;
	float z = 0;
	float *hf;
	float *n;
	beam *bl;
	FILE *fn;

	hf = (float *)malloc(dw*dh*sizeof(float));
	printf("calculating heights\n");
	calcHeights(dw, dh, hf);
	printf("Heights calculated.\n\n");
	n = (float *)malloc(3*dw*dh*sizeof(float));
	printf("calculating normals\n");
	calcNorms(dw, dh, hf, n);
	printf("Normals calculated.\n\n");
	bl = (beam *)malloc(2*(dw-1)*(dh-1)*sizeof(beam));
	printf("calculating beams\n");
	bl = calcBeams(dw, dh, hf, n);
	printf("Beams calculated.  %d found.\n\n", howmany);

	printf("writing file\n");
	fn = fopen("caustic.def", "wb");
	fwrite(&dw, sizeof(int), 1, fn);	
	fwrite(&dh, sizeof(int), 1, fn);	
	fwrite(&sx, sizeof(float), 1, fn);	
	fwrite(&sy, sizeof(float), 1, fn);	
	fwrite(&x, sizeof(float), 1, fn);	
	fwrite(&y, sizeof(float), 1, fn);	
	fwrite(&z, sizeof(float), 1, fn);	
	fwrite(&howmany, sizeof(int), 1, fn);	
//	fwrite(hf, sizeof(float), dw*dh, fn);
//	fwrite(n, sizeof(float), 3*dw*dh, fn);
	fwrite(bl, sizeof(beam), howmany, fn);

	fclose(fn);
	printf("file written\n");
}

void calcHeights(int dx, int dy, float *h){
	int i;
	int j;
	float fx, fy;
	float maxh = 0;

	for (i = 0; i < dy; i++){
		fy = (float)i/dy;
		for (j = 0; j < dx; j++){
			fx = (float)j/dx;
			h[dx*i + j] = sin(37.0*fx*TPI);
			h[dx*i + j] += 2.7*cos(24.6*fx*TPI+0.13);
			h[dx*i + j] += sin(17.0*(fx+fy)*TPI+0.8);
			h[dx*i + j] += 2.0*sin(11.5*(0.2312*fx+0.241*fy)*TPI+0.51);
			h[dx*i + j] += sin(17.0*(1.9*fx+2.52*fy)*TPI+0.4);
			h[dx*i + j] += cos(22.0*(0.7*fy+1.72*fy)*TPI+1.2);
			h[dx*i + j] += 3.2*sin(14.0*(1.2*fx+3.22*fy)*TPI+3.4);
			h[dx*i + j] += cos(73.4*(0.3*fy+0.12*fy)*TPI+2.5);
			h[dx*i + j] += 1.5*cos(27.2*(2.5*fx+1.92*fy)*TPI+1.6);
			h[dx*i + j] += sin(33.3*(3.3*fy+2.82*fy)*TPI+2.7);
			h[dx*i + j] += random()/RAND_MAX/10.0;
			if (maxh < fabs(h[dx*i + j]))
				maxh = fabs(h[dx*i + j]);
		}
	}

	// normalize and scale 
	for (i = 0; i < dy; i++)
		for (j = 0; j < dx; j++){
			h[dx*i + j] /= maxh;
			h[dx*i + j] *= SCALE_H;
		}
}

float tn(int i, int j, int xyz, int dx, float *n){
	return n[(3*2*(i*(dx-1)+j))+xyz];
}

void calcNorms(int dx, int dy, float *h, float *n){
	float *triN;
	float a, b, c;
	int i, j;

	// calculate the triangular normals
	triN = (float *)malloc(3*2*(dx-1)*(dy-1)*sizeof(float));
	for (i = 0; i < (dy-1); i++)
		for (j = 0; j < (dx-1); j++){
			a = h[dx*(i+1)+j+1]-h[dx*i+j];
			b = h[dx*(i+1)+j]-h[dx*i+j];
			c = h[dx*i+j+1]-h[dx*i+j];
			triN[6*(i*(dx-1)+j)] = b-a;
			triN[6*(i*(dx-1)+j)+1] = -b;
			triN[6*(i*(dx-1)+j)+2] = 1;
			
			triN[6*(i*(dx-1)+j)+3] = -c;
			triN[6*(i*(dx-1)+j)+4] = c-a;
			triN[6*(i*(dx-1)+j)+5] = 1;
		}

#ifdef pointNorms
	// calculate the point normals
	for (i = 0; i < dy; i++)
		for (j = 0; j < dx; j++){
			if (i == 0){
				if (j == 0){	// lower left corner
					n[0] = (tn(i, j, 0, dx, triN)+
						tn(i, j, 3, dx, triN))/2.0; 
					n[1] = (tn(i, j, 1, dx, triN)+
						tn(i, j, 4, dx, triN))/2.0; 
					n[2] = (tn(i, j, 2, dx, triN)+
						tn(i, j, 5, dx, triN))/2.0; 
					continue;
				}
				if (j == (dx-1)){	// lower right corner
					n[3*j] = tn(i, j-1, 3, dx, triN);
					n[3*j+1] = tn(i, j-1, 3, dx, triN);
					n[3*j+2] = tn(i, j-1, 3, dx, triN);
					continue;
				}
				// bottom row
				n[3*j] = (tn(i, j-1, 3, dx, triN)+
					  tn(i, j, 0, dx, triN)+
					  tn(i, j, 3, dx, triN))/3.0;
				n[3*j+1] = (tn(i, j-1, 4, dx, triN)+
					    tn(i, j, 1, dx, triN)+
					    tn(i, j, 4, dx, triN))/3.0;
				n[3*j+2] = (tn(i, j-1, 5, dx, triN)+
				 	    tn(i, j, 2, dx, triN)+
					    tn(i, j, 5, dx, triN))/3.0;
				continue;
			}
			if (i == (dy-1)){
				if (j == 0){	// upper left corner
					n[3*(dx*i+j)] = tn(i-1, j, 0, dx, triN);
					n[3*(dx*i+j)+1] = tn(i-1, j, 1, dx, triN);
					n[3*(dx*i+j)+2] = tn(i-1, j, 2, dx, triN);
					continue;
				}
				if (j == (dx-1)){	// upper right corner
					n[3*(dx*i+j)] = (tn(i-1, j-1, 0, dx, triN)+
					                 tn(i-1, j-1, 3, dx, triN))/2.0;
					n[3*(dx*i+j)+1] = (tn(i-1, j-1, 1, dx, triN)+
					                   tn(i-1, j-1, 4, dx, triN))/2.0;
					n[3*(dx*i+j)+2] = (tn(i-1, j-1, 2, dx, triN)+
					                   tn(i-1, j-1, 5, dx, triN))/2.0;
					continue;
				}
				// top row
				n[3*(dx*i+j)] = (tn(i-1, j-1, 0, dx, triN)+
				                 tn(i-1, j-1, 3, dx, triN)+
				                 tn(i-1, j, 0, dx, triN))/3.0;
				n[3*(dx*i+j)+1] = (tn(i-1, j-1, 1, dx, triN)+
				                   tn(i-1, j-1, 4, dx, triN)+
				                   tn(i-1, j, 1, dx, triN))/3.0;
				n[3*(dx*i+j)+2] = (tn(i-1, j-1, 2, dx, triN)+
				                   tn(i-1, j-1, 5, dx, triN)+
				                   tn(i-1, j, 2, dx, triN))/3.0;
				continue;
			}
			if (j == 0){
				// left column
				n[3*(dx*i+j)] = (tn(i-1, j, 0, dx, triN)+
				                 tn(i, j, 0, dx, triN)+
				                 tn(i, j, 3, dx, triN))/3.0;
				n[3*(dx*i+j)+1] = (tn(i-1, j, 1, dx, triN)+
				                   tn(i, j, 1, dx, triN)+
				                   tn(i, j, 4, dx, triN))/3.0;
				n[3*(dx*i+j)+2] = (tn(i-1, j, 2, dx, triN)+
				                   tn(i, j, 2, dx, triN)+
				                   tn(i, j, 4, dx, triN))/3.0;
				continue;
			}
			if (j == (dx-1)){
				// right column
				n[3*(dx*i+j)] = (tn(i-1, j-1, 0, dx, triN)+   
				                 tn(i-1, j-1, 3, dx, triN)+
				                 tn(i, j-1, 3, dx, triN))/3.0;
				n[3*(dx*i+j)+1] = (tn(i-1, j-1, 1, dx, triN)+   
				                 tn(i-1, j-1, 4, dx, triN)+
				                 tn(i, j-1, 4, dx, triN))/3.0;
				n[3*(dx*i+j)+2] = (tn(i-1, j-1, 1, dx, triN)+   
				                 tn(i-1, j-1, 4, dx, triN)+
				                 tn(i, j-1, 4, dx, triN))/3.0;
				continue;
			}
			// average all normals
			n[3*(dx*i+j)] = (tn(i-1, j-1, 0, dx, triN)+      
			                 tn(i-1, j-1, 3, dx, triN)+      
			                 tn(i-1, j, 0, dx, triN)+     
			                 tn(i-1, j, 3, dx, triN)+     
			                 tn(i, j-1, 0, dx, triN)+     
			                 tn(i, j-1, 3, dx, triN)+     
			                 tn(i, j, 0, dx, triN)+     
			                 tn(i, j, 3, dx, triN))/8.0;
			n[3*(dx*i+j)+1] = (tn(i-1, j-1, 1, dx, triN)+      
			                   tn(i-1, j-1, 4, dx, triN)+      
			                   tn(i-1, j, 1, dx, triN)+     
			                   tn(i-1, j, 4, dx, triN)+     
			                   tn(i, j-1, 1, dx, triN)+     
			                   tn(i, j-1, 4, dx, triN)+     
			                   tn(i, j, 1, dx, triN)+     
			                   tn(i, j, 4, dx, triN))/8.0;
			n[3*(dx*i+j)+2] = (tn(i-1, j-1, 2, dx, triN)+      
			                   tn(i-1, j-1, 5, dx, triN)+      
			                   tn(i-1, j, 2, dx, triN)+     
			                   tn(i-1, j, 5, dx, triN)+     
			                   tn(i, j-1, 2, dx, triN)+     
			                   tn(i, j-1, 5, dx, triN)+     
			                   tn(i, j, 2, dx, triN)+     
			                   tn(i, j, 5, dx, triN))/8.0;
		}
#endif
	// normalize the point normals
	float len;
	for (i = 0; i < dy; i++)
		for (j = 0; j < dx; j++){
			len = n[3*(dx*i+j)]*n[3*(dx*i+j)] + 
			      n[3*(dx*i+j)+1]*n[3*(dx*i+j)+1] +
			      n[3*(dx*i+j)+2]*n[3*(dx*i+j)+2];
			len = sqrt(len);
			n[3*(dx*i+j)] /= len;
			n[3*(dx*i+j)+1] /= len;
			n[3*(dx*i+j)+2] /= len;
		}
}

beam *calcBeams(int dw, int dh, float *h, float *n){
	int i, j;
	float ai, ar, x, y, z;
	float rA[3], rN[3], tot;
	double s;
	double c;
	float *ni;
	int *nf;

	beam *b=NULL;
	float m[4][4];

	ni = (float *)malloc(3*dw*dh*sizeof(float));
	nf = (int *)malloc(dw*dh*sizeof(int));
	for (i = 0; i < dh; i++)
		for (j = 0; j < dw; j++){
			ai = acos(n[3*(dw*i+j)+2]);
			ar = asin(sin(ai)/1.333); 

			// TODO internal reflection

			rA[0] = n[3*(dw*i+j)+1];
			rA[1] = -n[3*(dw*i+j)];
			rA[2] = 0;
			tot = sqrt(rA[0]*rA[0] + rA[1]*rA[1] + rA[2]*rA[2]);
			if (tot == 0){
				nf[dw*i+j] = 0;
				continue;
			}
			nf[dw*i+j] = 1;
			rA[0] /= tot;
			rA[1] /= tot;
			rA[2] /= tot;

			s = sin(-ar);
			c = cos(-ar);
			m[0][0] = rA[0] * rA[0] + (1. - rA[0] * rA[0]) * c;
			m[0][1] = rA[0] * rA[1] * (1 - c) - rA[2] * s;
			m[0][2] = rA[0] * rA[2] * (1 - c) + rA[1] * s;
			m[0][3] = 0;

			m[1][0] = rA[0] * rA[1] * (1 - c) + rA[2] * s;
			m[1][1] = rA[1] * rA[1] + (1 - rA[1] * rA[1]) * c;
			m[1][2] = rA[1] * rA[2] * (1 - c) - rA[0] * s;
			m[1][3] = 0;

			m[2][0] = rA[0] * rA[2] * (1 - c) - rA[1] * s;
			m[2][1] = rA[1] * rA[2] * (1 - c) + rA[0] * s;
			m[2][2] = rA[2] * rA[2] + (1 - rA[2] * rA[2]) * c;
			m[2][3] = 0;

			m[3][0] = 0;
			m[3][1] = 0;
			m[3][2] = 0;
			m[3][3] = 1;

			x = -n[3*(dw*i+j)];
 		        y = -n[3*(dw*i+j)+1];
 			z = -n[3*(dw*i+j)+2];

			ni[3*(dw*i+j)] = m[0][0]*x + m[0][1]*y + m[0][2]*z;	
			ni[3*(dw*i+j)+1] = m[1][0]*x + m[1][1]*y + m[1][2]*z;	
			ni[3*(dw*i+j)+2] = m[2][0]*x + m[2][1]*y + m[2][2]*z;	
		}
	for (i = 0; i < (dh-1); i++)
		for (j = 0; j < (dw-1); j++){
		   if (nf[dw*i+j]&&nf[dw*(i+1)+j]&&nf[dw*(i+1)+j+1]){
			howmany++;
			b = (beam *)realloc(b, howmany*sizeof(beam));
			// top triangle
			b[howmany-1].O1[0] = sx*((float)j)+tx; 
			b[howmany-1].O1[1] = sy*((float)i+1.0)+ty; 
			b[howmany-1].O1[2] = h[dw*(i+1)+j]+tz; 
			b[howmany-1].O2[0] = sx*((float)j)+tx; 
			b[howmany-1].O2[1] = sy*((float)i)+ty; 
			b[howmany-1].O2[2] = h[dw*i+j]+tz; 
			b[howmany-1].O3[0] = sx*((float)j+1.0)+tx; 
			b[howmany-1].O3[1] = sy*((float)i+1.0)+ty; 
			b[howmany-1].O3[2] = h[dw*(i+1)+j+1]+tz; 
			b[howmany-1].D1[0] = ni[3*(dw*(i+1)+j)]; 
			b[howmany-1].D1[1] = ni[3*(dw*(i+1)+j)+1]; 
			b[howmany-1].D1[2] = ni[3*(dw*(i+1)+j)+2]; 
			b[howmany-1].D2[0] = ni[3*(dw*i+j)]; 
			b[howmany-1].D2[1] = ni[3*(dw*i+j)+1]; 
			b[howmany-1].D2[2] = ni[3*(dw*i+j)+2]; 
			b[howmany-1].D3[0] = ni[3*(dw*(i+1)+(j+1))]; 
			b[howmany-1].D3[1] = ni[3*(dw*(i+1)+(j+1))+1]; 
			b[howmany-1].D3[2] = ni[3*(dw*(i+1)+(j+1))+2]; 
		   }

		   if (nf[dw*i+j]&&nf[dw*i+j+1]&&nf[dw*(i+1)+j+1]){
			howmany++;
			b = (beam *)realloc(b, howmany*sizeof(beam));
			// bottom triangle
			b[howmany-1].O1[0] = sx*((float)j+1.0)+tx; 
			b[howmany-1].O1[1] = sy*((float)i+1.0)+ty; 
			b[howmany-1].O1[2] = h[dw*(i+1)+j+1]+tz; 
			b[howmany-1].O2[0] = sx*((float)j)+tx; 
			b[howmany-1].O2[1] = sy*((float)i)+ty; 
			b[howmany-1].O2[2] = h[dw*i+j]+tz; 
			b[howmany-1].O3[0] = sx*((float)j+1.0)+tx; 
			b[howmany-1].O3[1] = sy*((float)i)+ty; 
			b[howmany-1].O3[2] = h[dw*i+j+1]+tz; 
			b[howmany-1].D1[0] = ni[3*(dw*(i+1)+(j+1))]; 
			b[howmany-1].D1[1] = ni[3*(dw*(i+1)+(j+1))+1]; 
			b[howmany-1].D1[2] = ni[3*(dw*(i+1)+(j+1))+2]; 
			b[howmany-1].D2[0] = ni[3*(dw*i+j)]; 
			b[howmany-1].D2[1] = ni[3*(dw*i+j)+1]; 
			b[howmany-1].D2[2] = ni[3*(dw*i+j)+2]; 
			b[howmany-1].D3[0] = ni[3*(dw*i+(j+1))]; 
			b[howmany-1].D3[1] = ni[3*(dw*i+(j+1))+1]; 
			b[howmany-1].D3[2] = ni[3*(dw*i+(j+1))+2]; 
		   }
		}
	free(ni);

	return b;
}
