
#include "heightfield.h"
#include "trimesh.h"

Heightfield::Heightfield(int x, int y, float *zs, PrimitiveAttributes * a,
						 SurfaceFunction * sf)
:Primitive(a, sf)
{
	nx = x;
	ny = y;
	z = new float[nx * ny];
	memcpy(z, zs, nx * ny * sizeof(float));
}

Heightfield::~Heightfield()
{
	delete[]z;
}

BBox Heightfield::BoundObjectSpace() const
{
	float minz = z[0], maxz = z[0];
	for (int i = 1; i < nx * ny; ++i) {
		if (z[i] < minz)
			minz = z[i];
		if (z[i] > maxz)
			maxz = z[i];
	}
	return BBox(Point(0, 0, minz), Point(1, 1, maxz));
}

bool Heightfield::CanIntersect() const
{
	return false;
}

void Heightfield::Refine(vector < Primitive * >*refined) const
{
	int ntris = 2 * (nx - 1) * (ny - 1);
	int *verts = new int[3 * ntris];
	Point *P = new Point[nx * ny];
	int x, y;

	P = new Point[nx * ny];
	int pos = 0;
	for (y = 0; y < ny; ++y) {
		for (x = 0; x < nx; ++x) {
			P[pos].x = (float) x / (float) (nx - 1);
			P[pos].y = (float) y / (float) (ny - 1);
			P[pos].z = z[pos];
			++pos;
		}
	}

	int *vp = verts;
	for (y = 0; y < ny - 1; ++y) {
		for (x = 0; x < nx - 1; ++x) {
#define VERT(x,y) ((x)+(y)*nx)
			*vp++ = VERT(x, y);
			*vp++ = VERT(x + 1, y);
			*vp++ = VERT(x + 1, y + 1);

			*vp++ = VERT(x, y);
			*vp++ = VERT(x + 1, y + 1);
			*vp++ = VERT(x, y + 1);
		}
#undef VERT
	}

	refined->push_back(new TriangleMesh(ntris, nx * ny, verts, P,
										attributes,
										new
										SurfaceFunction
										(*surfaceFunction)));
	delete[]P;
	delete[]verts;
}
