
#ifndef IMAGE_H
#define IMAGE_H
#include "lrt.h"
#include "color.h"

class Image {
  public:

	Image();

	void FinalizeValues();

	~Image();

	void AddSampleBasic(const Point & PRaster, const Spectrum & radiance,
						Float alpha);

	void Write() const;

	void AddSample(const Point & PRaster, const Spectrum & radiance,
				   Float alpha);

	int XResolution, YResolution;

	Float CropLeft, CropRight, CropBottom, CropTop;

	RtToken DisplayMode;

	Float Gain, Gamma;

	RtToken Imager;

	int ColorQuantOne, ColorQuantMin, ColorQuantMax;
	Float ColorQuantDither;

	int DepthQuantOne, DepthQuantMin, DepthQuantMax;
	Float DepthQuantDither;

	RtToken DisplayType, DisplayName;

	char *ImageViewer;

	Float SampleCropLeft, SampleCropRight;
	Float SampleCropTop, SampleCropBottom;

	Float PixelAspectRatio, FrameAspectRatio;

  private:
	 static void scaleAndDither(Float one, Float min, Float max, Float dither,
								Float * pixels, int nPixels);

	int XBase, YBase, XWidth, YWidth;

	Spectrum *Pixels;
	Float *Alphas, *Depths;
	Float *WeightSums;

};

#endif // IMAGE_H
