
#include "lrt.h"

void ParseEnableDebug()
{
	extern int yydebug;
	yydebug = 1;
}

bool ParseRIB(const char *filename)
{
	extern FILE *yyin;
	extern void yyparse(void);

	if (strcmp(filename, "-") == 0)
		yyin = stdin;
	else
		yyin = fopen(filename, "r");
	if (yyin == NULL)
		return false;
	else {
		yyparse();
		if (yyin != stdin)
			fclose(yyin);
	}
	return true;
}
