
#ifndef TRIMESH_H
#define TRIMESH_H
#include "primitives.h"
#include "caustic.h"

extern Caustic *caustic;
extern int areaReject;
extern int xReject;

class Triangle;

class TriangleMesh:public Primitive {
  public:

	TriangleMesh(int ntris, int nverts, int *vptr, Point * P,
				 PrimitiveAttributes * a, SurfaceFunction * v);
	~TriangleMesh();

	BBox BoundObjectSpace() const;

	BBox BoundWorldSpace() const;

	bool CanIntersect() const {return false;};
	
	void Refine(vector < Primitive * >*refined) const;
		
	friend class Triangle;
	friend class Caustic;

  protected:
	int ntris;
	int nverts;
	int *vertexIndex;
	Point *p;
};

class Triangle:public Primitive { public:
	 Triangle(const TriangleMesh * m, int n)
	:Primitive(m->attributes, NULL) {
	
		int v1, v2, v3;
		
		attributes->Reference();
		mesh = m;
		triNum = n;
		v1 = mesh->vertexIndex[3*n];
		v2 = mesh->vertexIndex[3*n+1];
		v3 = mesh->vertexIndex[3*n+2];
		bl = caustic->getBeamList(mesh->p[v1], mesh->p[v2], mesh->p[v3],
															&numBeams, &beaml);
printf("triangle %d/%d gets %d/%d/%d adequately sized projected beams\n",
				triNum, mesh->ntris, numBeams, xReject, areaReject);
//		if (triFile == NULL{
//			triFile = fopen("triFile.dat", "wb");
//		}
//		fwrite(&numBeams, sizeof(int), 1, triFile);
//		fwrite(bl, sizeof(Point), 3*numBeams, triFile);
	}
	int numBeams;
	
	BBox BoundObjectSpace() const;
	BBox BoundWorldSpace() const;

	bool IntersectClosest(const Ray & ray, Float mint, Float * maxt,
						  HitInfo * hit) const;

  	Spectrum getCaustic(HitInfo *) const;
	Point *bl;	// projected beam list for this triangle
	int *beaml;	// original beam list for this triangle
	int triNum;
	const TriangleMesh *mesh;

  private:


};

#endif // TRIMESH_H
