#include <sys/types.h>
#include <unistd.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include <GL/glut.h>

struct shmDB{
	int PickedUp;
	int imageW, imageH;
	pid_t lrtpid;
	pid_t viewerpid;
	float x, y;
	float r, g, b;
};

struct shmDB *shm_base;
int iW, iH;
float *pix=NULL;
float oldy=0;

void IdleDraw(void);
void setdraw(void);
void reshapeWin(int, int);

void cleanUp(int x){
	printf("cleaning up\n");
	shm_base->viewerpid = 0;	

	exit(0);
}

void updateWindow(int x){
	int nW, nH;

	nW = shm_base->imageW;
	nH = shm_base->imageH;
	if (((nW > 100)&&(nW != iW))||((nH > 100)&&(nH != iH))){
		printf("new image coming down the pipe.. resizing\n");
		iW = nW;
		iH = nH;
		oldy = 0;
		pix = (float *)realloc(pix, 3*iW*iH*sizeof(float));
		reshapeWin(iW, iH);
		setdraw();
	}
	if (shm_base->x < 0) return;
	if (shm_base->x >= iW) return;
	if (shm_base->y < 0) return;
	if (shm_base->y >= iH) return;

	pix[(int)(3*(iW*(shm_base->imageH-shm_base->y)+
		shm_base->x))] = shm_base->r;
	pix[(int)(3*(iW*(shm_base->imageH-shm_base->y)+
		shm_base->x)+1)] = shm_base->g;
	pix[(int)(3*(iW*(shm_base->imageH-shm_base->y)+
		shm_base->x)+2)] = shm_base->b;
	
	if (oldy <= shm_base->y){
		IdleDraw();
		oldy = shm_base->y+5;
	}
	shm_base->PickedUp = 1;
}

void IdleDraw(){
	int oldP = shm_base->PickedUp;

	oldy = 0;	
	shm_base->PickedUp = 0;
	glRasterPos3f(0, 0, 0);
	glDrawPixels(iW, iH, GL_RGB, GL_FLOAT, pix);
	glFlush();
	shm_base->PickedUp = oldP;
};

void reshapeWin(int x, int y){
	glutReshapeWindow(iW, iH);
	oldy = 0;
};

void kbhit(unsigned char key, int x, int y){
	oldy = 0;
	if ((key == 27)||(key == 'q'))
		cleanUp(1);
	else
		IdleDraw();
}

void setdraw(){
	glClearColor(0,0,0,1);
	glClear(GL_COLOR_BUFFER_BIT);

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	glOrtho(0, iW, 0, iH, -100, 100); 
	glViewport(0, 0, iW, iH);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();

	glDisable(GL_DEPTH_TEST);
};

void main(int argc, char **argv){
	int smemid = -1;

	printf("connecting to lrt...\n");
	while (smemid == -1)
		smemid = shmget(13482, 2048, 0666);
	printf("connection established on 13482\n\n");
	shm_base = NULL;
	shm_base = (struct shmDB *)shmat(smemid, NULL, 0);
	if (!shm_base){
		perror("shmat");
		printf("shared memory attach failed\n");
		exit(1);
	}
	iW = shm_base->imageW;
	iH = shm_base->imageH;
	pix = (float *)realloc(pix, 3*iW*iH*sizeof(float));
	shm_base->viewerpid = getpid();

	printf("         lrt pid: %d\n", shm_base->lrtpid);
	printf("      viewer pid: %d\n", shm_base->viewerpid);
	printf("Image Dimensions: %dx%d\n", shm_base->imageW, 
		shm_base->imageH);

	shm_base->PickedUp = 1;

	glutInit(&argc, argv);
	glutInitDisplayMode(GLUT_SINGLE|GLUT_RGBA);
	printf("glut initialized\n");
	if (iW < 100) iW = 100;
	if (iH < 100) iH = 100;

	glutInitWindowSize(iW, iH);
	printf("Window size initialized\n");
	glutCreateWindow("lrt viewer");
	printf("Window created\n");
	setdraw();
	glutReshapeFunc(reshapeWin);
	glutDisplayFunc(IdleDraw);
	printf("Callbacks set\n");

	signal(SIGUSR1, updateWindow);
	printf("\nInterrupts set\n");

	printf("Starting main loop\n");
	glutMainLoop();
}
