
#ifndef QUADRICS_H
#define QUADRICS_H
#include "primitives.h"

class Sphere:public Primitive {
  public:

	Sphere(Float rad, Float zmin, Float zmax, Float thetaMax,
		   PrimitiveAttributes * a, SurfaceFunction * sf);

	BBox BoundObjectSpace() const;

	bool IntersectClosest(const Ray & ray, Float mint, Float * maxt,
						  HitInfo * hit) const;

	Float Sample(Float u[2], HitInfo *) const {
		return 0.;
	} Float Pdf(const Ray & ray, Float * costhetao, Point * Plight) const {
		return 0.;
  } protected:

	 Float radius;
	Float zmin, zmax;
	Float thetaMax;

};

class Cylinder:public Primitive {
  public:

	Cylinder(Float rad, Float zmin, Float zmax, Float thetaMax,
			 PrimitiveAttributes * a, SurfaceFunction * sf);

	BBox BoundObjectSpace() const;

	bool IntersectClosest(const Ray & ray, Float mint,
						  Float * maxt, HitInfo * hit) const;

  protected:
	 Float radius;
	Float zmin, zmax;
	Float thetaMax;

};

class Cone:public Primitive { public:
	 Cone(Float height, Float rad, Float tm,
		  PrimitiveAttributes * a, SurfaceFunction * sf);

	BBox BoundObjectSpace() const;

	bool IntersectClosest(const Ray & ray, Float mint,
						  Float * maxt, HitInfo * hit) const;

  protected:
	 Float radius, height, thetaMax;

};

class Paraboloid:public Primitive { public:
	 Paraboloid(Float rad, Float z0, Float z1, Float tm,
				PrimitiveAttributes * a, SurfaceFunction * sf);

	BBox BoundObjectSpace() const;

	bool IntersectClosest(const Ray & ray, Float mint,
						  Float * maxt, HitInfo * hit) const;

  protected:
	 Float radius;
	Float zmin, zmax;
	Float thetaMax;

};

class Hyperboloid:public Primitive { public:
	 Hyperboloid(const Point & point1, const Point & point2, Float tm,
				 PrimitiveAttributes * a, SurfaceFunction * sf);

	BBox BoundObjectSpace() const;

	bool IntersectClosest(const Ray & ray, Float mint,
						  Float * maxt, HitInfo * hit) const;

  protected:
	 Point p1, p2;
	Float zmin, zmax;
	Float thetaMax;
	Float rmax;

};

class Disk:public Primitive { public:
	 Disk(Float Height, Float Radius, Float ThetaMax, PrimitiveAttributes * attr,
		  SurfaceFunction * sf);

	BBox BoundObjectSpace() const;

	bool IntersectClosest(const Ray & ray, Float mint, Float * maxt,
						  HitInfo * hit) const;

	Float Sample(Float u[2], HitInfo *) const;
	Float Pdf(const Ray & ray, Float * costhetao, Point * Plight) const;

  private:
	 Float Height, Radius, ThetaMax;

};

#endif // QUADRICS_H
