 );


  GenerateColors();

  textureMode = WingSurface::RandomRange( 0, 4 );
  
  
  fprintf(stderr, "In Butterfly constructor.\n");
  body = new Body;
  body->radius = 5.;
  


  float upperWidthFact = 1.6;
  float upperHeightFact = 1.2; 
  float lowerWidthFact = .7;
  float lowerHeightFact = 1.0;
  
  /*float upperWidthM = 1.+ 
    upperWidthFact/(float)RAND_MAX * (float) rand();
    float upperHeightM = .75 + 
    .5 * upperHeightFact/(float)RAND_MAX * (float) rand();
    float lowerHeightM = .75 + 
    .5 * lowerHeightFact/(float)RAND_MAX * (float) rand();
    float lowerWidthM = .25 +
    lowerWidthFact/(float)RAND_MAX * (float) rand();*/

  float upperWidthM = 1.7;
  float upperHeightM = 1.2;
  float lowerHeightM = .4;
  float lowerWidthM = 1.1;

  llWing = 
    new Wing(this, lowerLeft, wHeight* lowerHeightM, wWidth * lowerWidthM,
	     angle, roughness, a, sf);
  lrWing = 
  new Wing(this, lowerRight, wHeight * lowerHeightM, wWidth * lowerWidthM,
	   angle, roughness, a, sf);
  ulWing = 
    new Wing(this, upperLeft, wHeight*upperHeightM, upperWidthM * wWidth, 
	     angle, roughness, a, sf);
  urWing = 
    new Wing(this, upperRight, wHeight*upperHeightM, upperWidthM * wWidth, 
	     angle, roughness, a, sf);

  int i;
 
  llWing->GenerateWingGeometry();
  llWing->GenerateWingTransform();
  ulWing->GenerateWingGeometry();
  ulWing->GenerateWingTransform();
  
  lrWing->outline = new Outline(*(llWing->outline));  
  for(i=0; i<lrWing->outline->numSites; i++) {
    lrWing->outline->sites[i]->p.x = 1.0 - lrWing->outline->sites[i]->p.x;
  }
  lrWing->outline->pivot.x = 1.0 - lrWing->outline->pivot.x;
  lrWing->outline->polarO.x = 1.0 - lrWing->outline->polarO.x;
  
  lrWing->outline->InitSites();
  lrWing->outline->CalcPolarCoords();
  lrWing->outline->CreateControlPoints();
  lrWing->outline->CreatePolyOutline();
  lrWing->outline->SetupRegions();
  lrWing->outline->SetupVeins();
  lrWing->GenerateWingTransform();
  
  urWing->outline = new Outline(*(ulWing->outline));
  for(i=0; i<urWing->outline->numSites; i++) {
    urWing->outline->sites[i]->p.x = 1.0 - urWing->outline->sites[i]->p.x;
  }
  urWing->outline->pivot.x = 1.0 - urWing->outline->pivot.x;
  urWing->outline->polarO.x = 1.0 - urWing->outline->polarO.x;
  urWing->outline->InitSites();
  urWing->outline->CalcPolarCoords();
  urWing->outline->CreateControlPoints();
  urWing->outline->CreatePolyOutline();
  urWing->outline->SetupRegions();
  urWing->outline->SetupVeins();
  urWing->GenerateWingTransform();
  
  
  GenerateWingSurfaces(llWing, lrWing, ulWing, urWing);

 bodygeo = new TriangleMesh( new PrimitiveAttributes(*a),
			      new SurfaceFunction(*sf) );
  // bodygeo->WorldtoObject
  Transform ButterflyToBody = RotateY(180.) * Scale(.17,.17,.17);
  ButterflyToBody = Translate(0.,4.,0.) * ButterflyToBody;
  bodygeo->attributes->WorldToObject = 
    ButterflyToBody * bodygeo->attributes->WorldToObject;
  bodygeo->attributes->ObjectToWorld = bodygeo->attributes->WorldToObject.GetInverse();


  fprintf(stderr, "Finished with Butterfly constructor.\n");
}










void Butterfly::Refine(vector < Primitive * >*refined) const
{
  refined->reserve(4);
  refined->push_back(new Wing(*llWing));
  refined->push_back(new Wing(*lrWing));
  refined->push_back(new Wing(*ulWing));
  refined->push_back(new Wing(*urWing));

  refined->push_back(bodygeo);

	//for (int i = 0; i < ntris; ++i)
	//refined->push_back(new Triangle(this, i));
}



void Butterfly::GenerateWingSurfaces(Wing *ll, Wing *lr, 
				     Wing *ul, Wing *ur){
 
 
  
  
  WingSurface *lrS, *llS, *ulS, *urS;
  
  lrS = (WingSurface*) lr->attributes->Surface =
    new WingSurface( this, lr->surfaceFunction );

  llS = (WingSurface*) ll->attributes->Surface =
    new WingSurface( this, ll->surfaceFunction  );


  ulS = (WingSurface*) ul->attributes->Surface =
    new WingSurface( this, ul->surfaceFunction );

  
  urS = (WingSurface*) ur->attributes->Surface =
    new WingSurface( this, ur->surfaceFunction );
  
  lrS->Generate( (char*)"lr", NULL );
  llS->Generate( (char*)"ll", lrS );

  urS->Generate( (char*)"ur", NULL );
  ulS->Generate( (char*)"ul", urS );


  /* ll->attributes->Surface = new WingSurface( this, ll->surfaceFunction );
     lr->attributes->Surface = new WingSurface( this, lr->surfaceFunction );
     ul->attributes->Surface = new WingSurface( this, ul->surfaceFunction ); 
     ur->attributes->Surface = new WingSurface( this, ur->surfaceFunction );*/
 
  
  /*
  WingSurface* wsurf = (WingSurface*) attributes->Surface;
  wsurf->Generate( this );*/

  
  
  
  /*
  WingSurface* wsurf = (WingSurface*) attributes->Surface;
  wsurf->Generate( this );*/
}



BBox Butterfly::BoundObjectSpace() const
{
  // This isn't quite right, assumes wing angle is 180
  Point p1 = Point(-6.*ulWing->width, -6.*ulWing->height, -body->radius );
  Point p2 = Point(6.*lrWing->width, 6.*lrWing->height, body->radius);
  cout << p1 << endl << p2 << endl;
  return BBox(p1, p2);
}




bool Butterfly::IntersectClosest(const Ray & ray, Float mint,
			    Float * maxt, HitInfo * hit) const
{
  
   // Your code here :-)
  float hitt;
  Normal normal;
  Point vert[4];
  vert[0] = Point(0.,0.,0.);
  vert[2] = Point(0.,1.,0.);
  vert[1] = Point(1.,0.,0.);
  vert[3] = Point(1.,1.,0.);
  if(SquareIntersect(ray, mint, *maxt, &hitt, vert)) {
    Point ip = ray(hitt);
    if (lowerWingOutline.IntersectOutline(ip)) {
      if(ray.D.z < 0)
	normal = Normal(Vector(0.,0.,1.));
      else
	normal = Normal(Vector(0.,0.,-1.));
      Point ip = ray(hitt);
      hit->RecordHit(ip, normal, ip.x, ip.y, this); 
      *maxt = hitt;
      return true;
      
    }
  }
  
  return false;
  return false;
  }


bool Butterfly::SquareIntersect ( const Ray & ray, float mint, float maxt, float
		       *hit_t, Point vert[4] ) const {
  
  Point tri1v[3] = {vert[0],vert[2],vert[1]};
  Point tri2v[3] = {vert[1],vert[2],vert[3]};
  
  if ( TriIntersect(ray, mint, maxt, hit_t, tri1v) )
    return true;
  if ( TriIntersect(ray, mint, maxt, hit_t, tri2v) )
    return true;

  return false;
}


bool Butterfly::TriIntersect (const Ray & ray, float mint, float maxt, float *hitt, 
		   Point vert[3]) const {
  
	int vertexIndex0 = 0;
	int vertexIndex1 = 1;
	int vertexIndex2 = 2;

	const Point *p = vert;
	Vector E1 = p[vertexIndex1] - p[vertexIndex0];
	Vector E2 = p[vertexIndex2] - p[vertexIndex0];
	Vector S_1 = Cross(ray.D, E2);
	Float divisor = Dot(S_1, E1);
	if (divisor == 0.)
		return false;
	Float invDivisor = 1. / divisor;

	Vector T = ray.O - p[vertexIndex0];
	Float u = Dot(T, S_1) * invDivisor;
	if (u < 0. || u > 1.0)
		return false;

	Vector S_2 = Cross(T, E1);
	Float v = Dot(ray.D, S_2) * invDivisor;
	if (v < 0 || u + v > 1.0)
		return false;

	Float t = Dot(E2, S_2) * invDivisor;
	if (t < mint || t > maxt)
		return false;
	*hitt = t;

	
	return true;     
}
  






Point * InsertPoint(Point *array, Point newP, int index, int arraySize) {

  
  if(index>arraySize) exit(0);
  
  int i;

  Point *newArray = new Point[arraySize+1];
  for(i=0; i<index; i++) {
    newArray[i] = array[i];
  }
  newArray[index] = newP;
  for(i=index+1; i<arraySize+1; i++) 
    newArray[i] = array[i-1];
  
  return newArray;
  
}
