
#include "color.h"
#include "math.h"

#define H_UNDEFINED -1
#define MAX( a, b ) ( (a>b) ? a : b )
#define MIN( a, b ) ( (a<b) ? a : b )

ostream & operator << (ostream & os, const Spectrum & s) {
	os << s.s[0] << ", " << s.s[1] << ", " << s.s[2];
	return os;
}

void Spectrum::ConvertToRGB(Float * result) const
{
	result[0] = s[0];
	result[1] = s[1];
	result[2] = s[2];
}

void Spectrum::SetHSV( float h, float s, float v )
{
  float r, g, b;

  if( s == 0.0 ){
    if( h == H_UNDEFINED ){
      r = v;
      g = v;
      b = v;
    } else
      printf( "Color conversion error!]\n" );
  } else {
    float f, p, q, t;
    int i;

    if( h == 360.0)
      h = 0.0;
    h /= 60.0;
    i = floor(h);
    f = h-i;
    p = v * (1.0 - s );
    q = v * (1.0 - (s*f));
    t = v * (1.0 - (s * (1.0 -f)));
    switch(i){
       case 0: r = v; g = t; b = p; break;
       case 1: r = q; g = v; b = p; break;
       case 2: r = p; g = v; b = t; break;
       case 3: r = p; g = q; b = v; break;
       case 4: r = t; g = p; b = v; break;
       case 5: r = v; g = p; b = q; break;
    }
  }
}

void Spectrum::ConvertToHSV(Float * result ) const
{
  float r = s[0], g = s[1], b = s[2];
  float &h = result[0], &s = result[1], &v = result[2];

  float max = MAX( r, MAX( g, b ) );
  float min = MIN( r, MIN( g, b ) );
  v = max;
  s = (max != 0.0) ? ((max-min)/max):0.0;
  if( s == 0.0 )
    h = H_UNDEFINED;
  else{
    float delta = max - min;
    if( r == max )
      h = (g-b)/delta;
    else if( g == max )
      h = 2.0 + (b - r ) / delta;
    else if( b == max )
      h = 4.0 + (r - g ) / delta;
    h *= 60.0;
    if( h < 0.0 )
      h += 36.0;
  }
}
 
