
#ifndef _OUTLINE_H_
#define _OUTLINE_H_

//#include "lrt.h"
#include "site.h"
#include "geometry.h"

#define SITE_BLOCK 100
#define CURVE_SEGMENT 10
#define MAG_CONST .3


class Vein {
  
 public:
  Vein(Point p1, Point p2, float minu);
  
  Point GetVeinPoint(float u);

  
  float minu;
  Point *cp;
  int degree;
  
  int numCP;
  int numCurves;
  float totalVeinLength;
  float *curveLen;
  
  
};



class Outline {
  
 public:
  
  Site **sites;
  Site **regionS;
  Site **edgeS;
  
  int numSites;
  int numRegions;
  int numEdgeSites;
  int size;
  int numCurves;
  int numControlPoints;
  int numPolySegments;
  Point *controlP;
  Point *polyO;
  Point *regEP;
  Point *regOEP;
  float *segLen;
  float *curveLen;
  
  Point polarO;
  int numTweakableSites;
  Site **tweak;
  
  Point pivot;


  int numBodyEdgeVeins;
  int numOuterEdgeVeins;
  
  Vein **bodyEdgeVeins;
  Vein **outerEdgeVeins;
  
  
 public:
  Outline();
  Outline(const Outline & src);
  Outline(Point **pl, int *rp, int *wp, int numS, int numR, int numES,
	  Point polarO, Point pivot, int numBodyEdgeVeins, int numOEV);
  Outline(Site **sl, Site **rs, Site **es, int numS, int numR, int numES,
	  Point polarO, Point pivot, int numBodyEdgeVeins, int numOEV);
  ~Outline();
  void InsertSite(Site *site, int index);
  bool IntersectOutline(Point ip) const;  
  Site *GetS(int index);  
  void InitSite(int index);
  void InitSites();
  void CalcPolarCoords();
  Point *CreateControlPoints();
  Point *CreatePolyOutline();
  void SetupRegions();
  Point GetCurvePoint(int curve_num, float t);
  //float GetCurveLen(int curve_num);
  Point *RStoWS(int r, float u, float v);
  void RandPolarTweak(int index, float ThetaRangeMult, float RadialRange);
  void RandomSubdivide(int index, int totalsubdiv, int max, float threshold);
  void RandomCompress(float compressionFactor);
  void SetupVeins();
  
  
 
  
};









#endif
