
/*  A Bison parser, made from ribparse.y
    by GNU Bison version 1.28  */

#define YYBISON 1  /* Identify Bison output.  */

#define	STRING	257
#define	ID	258
#define	NUM	259
#define	LBRACK	260
#define	RBRACK	261
#define	DASH	262
#define	AREALIGHTSOURCE	263
#define	ATMOSPHERE	264
#define	ATTRIBUTE	265
#define	ATTRIBUTEBEGIN	266
#define	ATTRIBUTEEND	267
#define	BASIS	268
#define	BOUND	269
#define	CLIPPING	270
#define	COLOR	271
#define	COLORSAMPLES	272
#define	CONCATTRANSFORM	273
#define	CONE	274
#define	BUTTERFLY	275
#define	COORDINATESYSTEM	276
#define	CROPWINDOW	277
#define	CYLINDER	278
#define	DECLARE	279
#define	DEFORMATION	280
#define	DEPTHOFFIELD	281
#define	DETAIL	282
#define	DETAILRANGE	283
#define	DISK	284
#define	DISPLACEMENT	285
#define	DISPLAY	286
#define	EXPOSURE	287
#define	EXTERIOR	288
#define	FORMAT	289
#define	FRAMEASPECTRATIO	290
#define	FRAMEBEGIN	291
#define	FRAMEEND	292
#define	GENERALPOLYGON	293
#define	GEOMETRICAPPROXIMATION	294
#define	GEOMETRY	295
#define	HIDER	296
#define	HYPERBOLOID	297
#define	IDENTITY	298
#define	ILLUMINATE	299
#define	IMAGER	300
#define	INTERIOR	301
#define	LIGHTSOURCE	302
#define	MAKEBUMP	303
#define	MAKECUBEFACEENVIRONMENT	304
#define	MAKELATLONGENVIRONMENT	305
#define	MAKESHADOW	306
#define	MAKETEXTURE	307
#define	MATTE	308
#define	MOTIONBEGIN	309
#define	MOTIONEND	310
#define	NUPATCH	311
#define	OBJECTBEGIN	312
#define	OBJECTEND	313
#define	OBJECTINSTANCE	314
#define	OPACITY	315
#define	OPTION	316
#define	ORIENTATION	317
#define	PARABOLOID	318
#define	PATCH	319
#define	PATCHMESH	320
#define	PERSPECTIVE	321
#define	PIXELFILTER	322
#define	PIXELSAMPLES	323
#define	PIXELVARIANCE	324
#define	POINTSGENERALPOLYGONS	325
#define	POINTSPOLYGONS	326
#define	POLYGON	327
#define	PROJECTION	328
#define	QUANTIZE	329
#define	RELATIVEDETAIL	330
#define	REVERSEORIENTATION	331
#define	ROTATE	332
#define	SCALE	333
#define	SCREENWINDOW	334
#define	SHADINGINTERPOLATION	335
#define	SHADINGRATE	336
#define	SHUTTER	337
#define	SIDES	338
#define	SKEW	339
#define	SOLIDBEGIN	340
#define	SOLIDEND	341
#define	SPHERE	342
#define	SURFACE	343
#define	TEXTURECOORDINATES	344
#define	TORUS	345
#define	TRANSFORM	346
#define	TRANSFORMBEGIN	347
#define	TRANSFORMEND	348
#define	TRANSLATE	349
#define	TRIMCURVE	350
#define	VERSION	351
#define	WORLDBEGIN	352
#define	WORLDEND	353
#define	HIGH_PRECEDENCE	354

#line 1 "ribparse.y"

#include "ri.h"
#include "lrt.h"

#include <stdarg.h>

extern int yylex( void );
int line_num = 1;

#define YYMAXDEPTH 100000000

void yyerror( char *str ) {
	Error( "RIB parsing error on line %d\n\t%s", line_num,str );
}

void ParseError( const char *format, ... ) PRINTF_FORMAT;

void ParseError( const char *format, ... ) {
	char error[4096];
	va_list args;
	va_start( args, format );
	vsprintf( error, format, args );
	yyerror(error);
	va_end( args );
}

// RI says 64k is the maxiumum light handle number
#define MAX_LIGHT_HANDLE 65536
static RtLightHandle lights[MAX_LIGHT_HANDLE];

int cur_paramlist_allocated = 0;
int cur_paramlist_size = 0;
RtToken *cur_paramlist_tokens = NULL;
RtPointer *cur_paramlist_args = NULL;
RtInt *cur_paramlist_sizes = NULL;

#define CPS cur_paramlist_size
#define CPT cur_paramlist_tokens
#define CPA cur_paramlist_args
#define CPSZ cur_paramlist_sizes

typedef struct RIB_array {
	int element_size;
	int allocated;
	int nelems;
	RtVoid *array;
} RIB_array;

RIB_array *cur_array = NULL;

#define NA(r) ((RtFloat *) r->array)
#define SA(r) ((const char **) r->array)

void AddArrayElement( void *elem ) {
	if (cur_array->nelems >= cur_array->allocated) {
		cur_array->allocated = 2*cur_array->allocated + 1;
		cur_array->array = realloc( cur_array->array,
			cur_array->allocated*cur_array->element_size );
	}
	char *next = ((char *)cur_array->array) + cur_array->nelems *
		cur_array->element_size;
	memcpy( next, elem, cur_array->element_size );
	cur_array->nelems++;
}

RIB_array *ArrayDup( RIB_array *ra )
{
	RIB_array *ret = new RIB_array;
	ret->element_size = ra->element_size;
	ret->allocated = ra->allocated;
	ret->nelems = ra->nelems;
	ret->array = new char[ra->nelems * ra->element_size];
	memcpy( ret->array, ra->array, ra->nelems * ra->element_size );
	return ret;
}

void ArrayFree( RIB_array *ra )
{
	delete [] ((char *) ra->array);
	delete ra;
}

static RtFloat * FindBasis( const char *str )
{
	/*
	if (!strcmp( str, "bezier" )) return (RtFloat *) RiBezierBasis;
	else if (!strcmp( str, "b-spline" )) return (RtFloat *) RiBSplineBasis;
	else if (!strcmp( str, "catmull-rom" )) return (RtFloat *) RiCatmullRomBasis;
	else if (!strcmp( str, "hermite" )) return (RtFloat *) RiHermiteBasis;
	else if (!strcmp( str, "power" )) return (RtFloat *) RiPowerBasis;
	else ParseError( "Unknown basis: %s", str );
	*/

	Warning("Named bases aren't supported yet...");

	return NULL;
}
static bool VerifyArrayLength( RIB_array *arr, RtInt required,
	const char *command ) {
	if (arr->nelems != required) {
		ParseError( "%s requires a(n) %d element array!", command, required);
		return false;
	}
	return true;
}

static RtInt *MakeIntArray( RIB_array *arr )
{
	RtInt *ret = new RtInt[arr->nelems];
	for (int i = 0 ; i < arr->nelems ; i++)
		ret[i] = RtInt(NA(arr)[i]);
	return ret;
}

static RtFilterFunc FindFilterFunc( const char *name )
{
	if (!strcmp( name, "box" ))
		return RiBoxFilter;
	else if (!strcmp( name, "triangle" ))
		return RiTriangleFilter;
	else if (!strcmp( name, "catmull-rom" ))
		return RiCatmullRomFilter;
	else if (!strcmp( name, "sinc" ))
		return RiSincFilter;
	else if (!strcmp( name, "gaussian" ))
		return RiGaussianFilter;
	else
		ParseError( "Unknown filter function :%s", name );
	return RtFilterFunc(NULL);
}

#line 133 "ribparse.y"
typedef union {
char string[1024];
RtFloat num;
RIB_array *ribarray;
} YYSTYPE;
#ifndef YYDEBUG
#define YYDEBUG 1
#endif

#include <stdio.h>

#ifndef __cplusplus
#ifndef __STDC__
#define const
#endif
#endif



#define	YYFINAL		420
#define	YYFLAG		-32768
#define	YYNTBASE	101

#define YYTRANSLATE(x) ((unsigned)(x) <= 354 ? yytranslate[x] : 122)

static const char yytranslate[] = {     0,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     1,     3,     4,     5,     6,
     7,     8,     9,    10,    11,    12,    13,    14,    15,    16,
    17,    18,    19,    20,    21,    22,    23,    24,    25,    26,
    27,    28,    29,    30,    31,    32,    33,    34,    35,    36,
    37,    38,    39,    40,    41,    42,    43,    44,    45,    46,
    47,    48,    49,    50,    51,    52,    53,    54,    55,    56,
    57,    58,    59,    60,    61,    62,    63,    64,    65,    66,
    67,    68,    69,    70,    71,    72,    73,    74,    75,    76,
    77,    78,    79,    80,    81,    82,    83,    84,    85,    86,
    87,    88,    89,    90,    91,    92,    93,    94,    95,    96,
    97,    98,    99,   100
};

#if YYDEBUG != 0
static const short yyprhs[] = {     0,
     0,     2,     3,     4,     5,     7,     9,    11,    13,    18,
    21,    24,    26,    29,    31,    33,    38,    41,    44,    46,
    49,    52,    53,    56,    57,    60,    63,    65,    68,    73,
    77,    81,    83,    85,    91,    97,   103,   109,   117,   120,
   124,   129,   132,   136,   142,   149,   153,   157,   160,   163,
   169,   172,   179,   183,   187,   191,   196,   199,   207,   210,
   216,   219,   225,   229,   233,   239,   243,   247,   252,   255,
   258,   260,   264,   268,   272,   276,   286,   290,   292,   296,
   300,   304,   309,   319,   333,   341,   346,   356,   359,   362,
   364,   377,   380,   382,   385,   390,   393,   397,   400,   407,
   411,   415,   423,   426,   431,   435,   438,   444,   449,   452,
   456,   463,   466,   468,   474,   479,   485,   488,   491,   494,
   498,   501,   510,   513,   516,   518,   525,   529,   533,   543,
   546,   554,   558,   561,   563,   565,   570,   581,   583
};

static const short yyrhs[] = {   120,
     0,     0,     0,     0,   106,     0,   111,     0,   107,     0,
   108,     0,   102,     6,   109,     7,     0,   102,   110,     0,
   109,   110,     0,   110,     0,   103,     3,     0,   112,     0,
   113,     0,   102,     6,   114,     7,     0,   102,   115,     0,
   114,   115,     0,   115,     0,   104,     5,     0,   117,   118,
     0,     0,   119,   118,     0,     0,     3,   105,     0,   120,
   121,     0,   121,     0,    97,     5,     0,     9,     3,     5,
   116,     0,    10,     3,   116,     0,    11,     3,   116,     0,
    12,     0,    13,     0,    14,     3,     5,     3,     5,     0,
    14,     3,     5,   112,     5,     0,    14,   112,     5,     3,
     5,     0,    14,   112,     5,   112,     5,     0,    15,     5,
     5,     5,     5,     5,     5,     0,    15,   112,     0,    16,
     5,     5,     0,    17,     5,     5,     5,     0,    17,   112,
     0,    18,   112,   112,     0,    20,     5,     5,     5,   116,
     0,    21,     5,     5,     5,     5,   116,     0,    21,   112,
   116,     0,    20,   112,   116,     0,    19,   111,     0,    22,
     3,     0,    23,     5,     5,     5,     5,     0,    23,   112,
     0,    24,     5,     5,     5,     5,   116,     0,    24,   112,
   116,     0,    25,     3,     3,     0,    26,     3,   116,     0,
    27,     5,     5,     5,     0,    27,     8,     0,    28,     5,
     5,     5,     5,     5,     5,     0,    28,   112,     0,    29,
     5,     5,     5,     5,     0,    29,   112,     0,    30,     5,
     5,     5,   116,     0,    30,   112,   116,     0,    31,     3,
   116,     0,    32,     3,     3,     3,   116,     0,    33,     5,
     5,     0,    34,     3,   116,     0,    35,     5,     5,     5,
     0,    36,     5,     0,    37,     5,     0,    38,     0,    39,
   111,   116,     0,    40,     3,     5,     0,    41,     3,   116,
     0,    42,     3,   116,     0,    43,     5,     5,     5,     5,
     5,     5,     5,   116,     0,    43,   112,   116,     0,    44,
     0,    45,     5,     5,     0,    46,     3,   116,     0,    47,
     3,   116,     0,    48,     3,     5,   116,     0,    49,     3,
     3,     3,     3,     3,     5,     5,   116,     0,    50,     3,
     3,     3,     3,     3,     3,     3,     5,     3,     5,     5,
   116,     0,    51,     3,     3,     3,     5,     5,   116,     0,
    52,     3,     3,   116,     0,    53,     3,     3,     3,     3,
     3,     5,     5,   116,     0,    54,     5,     0,    55,   111,
     0,    56,     0,    57,     5,     5,   112,     5,     5,     5,
     5,   112,     5,     5,   116,     0,    58,     5,     0,    59,
     0,    60,     5,     0,    61,     5,     5,     5,     0,    61,
   112,     0,    62,     3,   116,     0,    63,     3,     0,    64,
     5,     5,     5,     5,   116,     0,    64,   112,   116,     0,
    65,     3,   116,     0,    66,     3,     5,     3,     5,     3,
   116,     0,    67,     5,     0,    68,     3,     5,     5,     0,
    69,     5,     5,     0,    70,     5,     0,    71,   111,   111,
   111,   116,     0,    72,   111,   111,   116,     0,    73,   116,
     0,    74,     3,   116,     0,    75,     3,     5,     5,     5,
     5,     0,    76,     5,     0,    77,     0,    78,     5,     5,
     5,     5,     0,    79,     5,     5,     5,     0,    80,     5,
     5,     5,     5,     0,    80,   112,     0,    81,     3,     0,
    82,     5,     0,    83,     5,     5,     0,    84,     5,     0,
    85,     5,     5,     5,     5,     5,     5,     5,     0,    85,
   112,     0,    86,     3,     0,    87,     0,    88,     5,     5,
     5,     5,   116,     0,    88,   112,   116,     0,    89,     3,
   116,     0,    90,     5,     5,     5,     5,     5,     5,     5,
     5,     0,    90,   112,     0,    91,     5,     5,     5,     5,
     5,   116,     0,    91,   112,   116,     0,    92,   112,     0,
    93,     0,    94,     0,    95,     5,     5,     5,     0,    96,
   111,   111,   111,   111,   111,   111,   111,   111,   111,     0,
    98,     0,    99,     0
};

#endif

#if YYDEBUG != 0
static const short yyrline[] = { 0,
   169,   171,   180,   185,   190,   194,   199,   203,   208,   212,
   214,   215,   217,   223,   227,   232,   236,   238,   239,   241,
   247,   249,   254,   255,   257,   273,   274,   276,   277,   285,
   289,   293,   297,   301,   307,   315,   323,   330,   337,   343,
   347,   353,   359,   374,   378,   382,   387,   392,   398,   402,
   406,   412,   416,   422,   426,   430,   434,   438,   445,   451,
   455,   461,   465,   471,   475,   479,   483,   487,   491,   495,
   499,   503,   510,   514,   518,   522,   529,   539,   543,   556,
   560,   564,   572,   577,   583,   588,   592,   597,   601,   606,
   610,   617,   621,   625,   629,   635,   641,   645,   649,   653,
   659,   663,   667,   671,   676,   680,   684,   701,   721,   743,
   747,   751,   755,   759,   763,   767,   771,   777,   781,   785,
   789,   793,   797,   804,   808,   812,   816,   822,   826,   831,
   838,   842,   849,   855,   859,   863,   867,   890,   894
};
#endif


#if YYDEBUG != 0 || defined (YYERROR_VERBOSE)

static const char * const yytname[] = {   "$","error","$undefined.","STRING",
"ID","NUM","LBRACK","RBRACK","DASH","AREALIGHTSOURCE","ATMOSPHERE","ATTRIBUTE",
"ATTRIBUTEBEGIN","ATTRIBUTEEND","BASIS","BOUND","CLIPPING","COLOR","COLORSAMPLES",
"CONCATTRANSFORM","CONE","BUTTERFLY","COORDINATESYSTEM","CROPWINDOW","CYLINDER",
"DECLARE","DEFORMATION","DEPTHOFFIELD","DETAIL","DETAILRANGE","DISK","DISPLACEMENT",
"DISPLAY","EXPOSURE","EXTERIOR","FORMAT","FRAMEASPECTRATIO","FRAMEBEGIN","FRAMEEND",
"GENERALPOLYGON","GEOMETRICAPPROXIMATION","GEOMETRY","HIDER","HYPERBOLOID","IDENTITY",
"ILLUMINATE","IMAGER","INTERIOR","LIGHTSOURCE","MAKEBUMP","MAKECUBEFACEENVIRONMENT",
"MAKELATLONGENVIRONMENT","MAKESHADOW","MAKETEXTURE","MATTE","MOTIONBEGIN","MOTIONEND",
"NUPATCH","OBJECTBEGIN","OBJECTEND","OBJECTINSTANCE","OPACITY","OPTION","ORIENTATION",
"PARABOLOID","PATCH","PATCHMESH","PERSPECTIVE","PIXELFILTER","PIXELSAMPLES",
"PIXELVARIANCE","POINTSGENERALPOLYGONS","POINTSPOLYGONS","POLYGON","PROJECTION",
"QUANTIZE","RELATIVEDETAIL","REVERSEORIENTATION","ROTATE","SCALE","SCREENWINDOW",
"SHADINGINTERPOLATION","SHADINGRATE","SHUTTER","SIDES","SKEW","SOLIDBEGIN","SOLIDEND",
"SPHERE","SURFACE","TEXTURECOORDINATES","TORUS","TRANSFORM","TRANSFORMBEGIN",
"TRANSFORMEND","TRANSLATE","TRIMCURVE","VERSION","WORLDBEGIN","WORLDEND","HIGH_PRECEDENCE",
"start","array_init","string_array_init","num_array_init","array","string_array",
"real_string_array","single_element_string_array","string_list","string_list_entry",
"num_array","real_num_array","single_element_num_array","num_list","num_list_entry",
"paramlist","paramlist_init","paramlist_contents","paramlist_entry","ri_stmt_list",
"ri_stmt", NULL
};
#endif

static const short yyr1[] = {     0,
   101,   102,   103,   104,   105,   105,   106,   106,   107,   108,
   109,   109,   110,   111,   111,   112,   113,   114,   114,   115,
   116,   117,   118,   118,   119,   120,   120,   121,   121,   121,
   121,   121,   121,   121,   121,   121,   121,   121,   121,   121,
   121,   121,   121,   121,   121,   121,   121,   121,   121,   121,
   121,   121,   121,   121,   121,   121,   121,   121,   121,   121,
   121,   121,   121,   121,   121,   121,   121,   121,   121,   121,
   121,   121,   121,   121,   121,   121,   121,   121,   121,   121,
   121,   121,   121,   121,   121,   121,   121,   121,   121,   121,
   121,   121,   121,   121,   121,   121,   121,   121,   121,   121,
   121,   121,   121,   121,   121,   121,   121,   121,   121,   121,
   121,   121,   121,   121,   121,   121,   121,   121,   121,   121,
   121,   121,   121,   121,   121,   121,   121,   121,   121,   121,
   121,   121,   121,   121,   121,   121,   121,   121,   121
};

static const short yyr2[] = {     0,
     1,     0,     0,     0,     1,     1,     1,     1,     4,     2,
     2,     1,     2,     1,     1,     4,     2,     2,     1,     2,
     2,     0,     2,     0,     2,     2,     1,     2,     4,     3,
     3,     1,     1,     5,     5,     5,     5,     7,     2,     3,
     4,     2,     3,     5,     6,     3,     3,     2,     2,     5,
     2,     6,     3,     3,     3,     4,     2,     7,     2,     5,
     2,     5,     3,     3,     5,     3,     3,     4,     2,     2,
     1,     3,     3,     3,     3,     9,     3,     1,     3,     3,
     3,     4,     9,    13,     7,     4,     9,     2,     2,     1,
    12,     2,     1,     2,     4,     2,     3,     2,     6,     3,
     3,     7,     2,     4,     3,     2,     5,     4,     2,     3,
     6,     2,     1,     5,     4,     5,     2,     2,     2,     3,
     2,     8,     2,     2,     1,     6,     3,     3,     9,     2,
     7,     3,     2,     1,     1,     4,    10,     1,     1
};

static const short yydefact[] = {     0,
     0,     0,     0,    32,    33,     2,     2,     0,     2,     2,
     2,     2,     2,     0,     2,     2,     0,     0,     0,     2,
     2,     2,     0,     0,     0,     0,     0,     0,     0,    71,
     2,     0,     0,     0,     2,    78,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     2,    90,     0,     0,
    93,     0,     2,     0,     0,     2,     0,     0,     0,     0,
     0,     0,     2,     2,    22,     0,     0,     0,   113,     0,
     0,     2,     0,     0,     0,     0,     2,     0,   125,     2,
     0,     2,     2,     2,   134,   135,     0,     2,     0,   138,
   139,     1,    27,     0,    22,    22,     0,     0,     0,     0,
    39,     0,     0,    42,     2,     4,    48,    14,    15,     0,
    22,     0,    22,    49,     0,    51,     0,    22,     0,    22,
     0,    57,     0,    59,     0,    61,     0,    22,    22,     0,
     0,    22,     0,    69,    70,    22,     0,    22,    22,     0,
    22,     0,    22,    22,     0,     0,     0,     0,     0,     0,
    88,    89,     0,    92,    94,     0,    96,    22,    98,     0,
    22,    22,     0,   103,     0,     0,   106,     2,     2,   109,
    24,    22,     0,   112,     0,     0,     0,   117,   118,   119,
     0,   121,     0,   123,   124,     0,    22,    22,     0,   130,
     0,    22,   133,     0,     2,    28,    26,    22,    30,    31,
     2,     4,     2,     0,    40,     0,    43,     0,    17,     0,
    47,     0,    46,     0,     0,    53,    54,    55,     0,     0,
     0,     0,    63,    64,     0,    66,    67,     0,    72,    73,
    74,    75,     0,    77,    79,    80,    81,    22,     0,     0,
     0,    22,     0,     2,     0,    97,     0,   100,   101,     0,
     0,   105,     2,    22,     2,    21,    24,   110,     0,     0,
     0,     0,   120,     0,     0,   127,   128,     0,     0,   132,
     0,     2,    29,     0,     0,     4,    19,     0,     0,     0,
    41,    20,    22,     0,     0,     0,    56,     0,     0,    22,
    22,    68,     0,    82,     0,     0,     0,    86,     0,     0,
    95,     0,     0,   104,    22,   108,     3,    25,     5,     7,
     8,     6,    23,     0,     0,   115,     0,     0,     0,     0,
     0,   136,     2,    34,    35,    16,    18,    36,    37,     0,
    44,    22,    50,    22,     0,    60,    62,    65,     0,     0,
     0,     0,     0,     0,    22,     0,   107,     3,     0,    10,
     0,   114,   116,     0,    22,     0,     0,     2,     0,    45,
    52,     0,     0,     0,     0,    22,     0,     0,    99,    22,
     3,    12,    13,   111,     0,   126,     0,    22,     2,    38,
    58,     0,     0,     0,    85,     0,     0,   102,     9,    11,
     0,     0,   131,     2,    22,    22,     0,    22,     2,   122,
     0,     2,    76,    83,     0,    87,     0,   129,     2,     0,
     0,   137,     0,    22,    22,    91,    84,     0,     0,     0
};

static const short yydefgoto[] = {   418,
    98,   349,   208,   308,   309,   310,   311,   371,   350,   107,
   108,   109,   276,   209,   170,   171,   256,   257,    92,    93
};

static const short yypact[] = {   408,
     4,    10,    13,-32768,-32768,    16,    -4,     0,    24,-32768,
-32768,    25,    26,    18,    27,    28,    31,    32,    -2,    33,
    34,    35,    38,    41,    40,    43,    42,    44,    45,-32768,
-32768,    48,    51,    53,    52,-32768,    54,    57,    58,    59,
    60,    61,    62,    63,    65,    64,-32768,-32768,    66,    67,
-32768,    68,    70,    73,    77,    76,    80,    84,    83,    86,
    85,    87,-32768,-32768,-32768,    88,    90,    89,-32768,    93,
    94,    95,    92,    96,    97,    98,    99,   102,-32768,   101,
   105,   104,   106,-32768,-32768,-32768,   108,-32768,   110,-32768,
-32768,   408,-32768,   111,-32768,-32768,   112,   114,   113,   117,
-32768,   118,   119,-32768,-32768,   114,-32768,-32768,-32768,   120,
-32768,   121,-32768,-32768,   122,-32768,   123,-32768,   107,-32768,
   126,-32768,   127,-32768,   129,-32768,   130,-32768,-32768,   133,
   136,-32768,   138,-32768,-32768,-32768,   141,-32768,-32768,   144,
-32768,   146,-32768,-32768,   147,   135,   150,   151,   152,   153,
-32768,-32768,   155,-32768,-32768,   156,-32768,-32768,-32768,   159,
-32768,-32768,   160,-32768,   161,   162,-32768,-32768,-32768,-32768,
   165,-32768,   164,-32768,   166,   167,   170,-32768,-32768,-32768,
   171,-32768,   172,-32768,-32768,   173,-32768,-32768,   174,-32768,
   175,-32768,-32768,   176,-32768,-32768,-32768,-32768,-32768,-32768,
   179,-32768,   180,   181,-32768,   182,-32768,   185,-32768,   186,
-32768,   187,-32768,   189,   190,-32768,-32768,-32768,   191,   192,
   193,   195,-32768,-32768,   198,-32768,-32768,   197,-32768,-32768,
-32768,-32768,   199,-32768,-32768,-32768,-32768,-32768,   203,   204,
   205,-32768,   206,-32768,   207,-32768,   208,-32768,-32768,   211,
   210,-32768,-32768,-32768,-32768,-32768,   165,-32768,   212,   213,
   214,   215,-32768,   216,   217,-32768,-32768,   218,   219,-32768,
   220,-32768,-32768,   221,   222,   163,-32768,   223,   224,   225,
-32768,-32768,-32768,   226,   228,   230,-32768,   231,   232,-32768,
-32768,-32768,   233,-32768,   237,   238,   240,-32768,   244,   243,
-32768,   245,   247,-32768,-32768,-32768,    22,-32768,-32768,-32768,
-32768,-32768,-32768,   248,   249,-32768,   251,   252,   253,   254,
   255,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,   257,
-32768,-32768,-32768,-32768,   258,-32768,-32768,-32768,   259,   246,
   262,   261,   264,   263,-32768,   266,-32768,   265,   268,-32768,
   267,-32768,-32768,   269,-32768,   270,   271,-32768,   272,-32768,
-32768,   273,   274,   275,   278,-32768,   277,   280,-32768,-32768,
   178,-32768,-32768,-32768,   281,-32768,   282,-32768,-32768,-32768,
-32768,   283,   284,   287,-32768,   288,   289,-32768,-32768,-32768,
   290,   291,-32768,-32768,-32768,-32768,   292,-32768,-32768,-32768,
   293,-32768,-32768,-32768,   296,-32768,   295,-32768,-32768,   298,
   299,-32768,   300,-32768,-32768,-32768,-32768,   301,   307,-32768
};

static const short yypgoto[] = {-32768,
   -11,-32768,-32768,-32768,-32768,-32768,-32768,-32768,  -346,   -21,
     2,-32768,-32768,  -198,     1,-32768,  -209,-32768,-32768,   -22
};


#define	YYLAST		507


static const short yytable[] = {   106,
   100,   372,   121,   277,   102,   122,    94,    99,   101,   136,
   104,   105,    95,   111,   113,    96,   116,   118,    97,   106,
   114,   124,   126,   128,   390,   152,    -4,   348,   103,   110,
   112,   115,   117,   119,   120,   106,   141,   123,   125,   127,
   129,   168,   169,   130,   131,   132,   133,   313,   134,   135,
   137,   106,   106,   138,   157,   139,   140,   161,   142,   143,
   144,   145,   146,   147,   148,   149,   195,   150,   151,   197,
   153,   154,   155,   178,   156,   158,   106,   327,   184,   159,
   160,   187,   162,   190,   192,   193,   163,   164,   165,   166,
   172,   167,   173,   174,   179,   199,   200,   175,   176,   177,
   180,   181,   182,   183,   185,   186,   207,   188,   189,   217,
   191,   211,   194,   213,   196,   198,   201,   203,   216,   202,
   218,   204,   205,   206,   210,   212,   214,   215,   223,   224,
   219,   220,   227,   221,   222,   225,   229,   239,   231,   232,
   226,   234,   228,   236,   237,   230,   253,   254,   233,   277,
   235,   238,   240,   241,   242,   243,   106,   106,   246,   244,
   245,   248,   249,   247,   250,   251,   252,   255,   259,   326,
   260,   261,   258,   272,   262,   263,   264,   265,   268,   269,
   271,   274,   278,   106,   389,   280,   281,   266,   267,   282,
   283,   284,   270,   285,   286,   287,   288,   289,   273,   290,
   291,   292,   275,   293,   279,   295,   296,   297,   299,     0,
     0,   301,   302,   303,   304,     0,   314,   315,   316,   317,
   318,   319,   320,   321,   322,   324,   325,   328,   329,   330,
   332,   305,   333,   312,   334,   335,   336,   339,   294,   340,
   341,   106,   298,   307,   342,   300,   343,   344,   364,   345,
   323,   346,   351,   352,   306,   353,   354,   355,   356,   357,
   106,   359,   362,   363,   365,   366,   367,   368,   370,    -4,
   373,   374,     0,   375,   377,   378,   380,   381,   382,   383,
   384,   386,     0,   331,   387,   391,   392,   395,   396,   397,
   337,   338,   398,   399,   400,   401,   405,   408,   410,   411,
   419,   358,   413,   414,   415,   347,   420,     0,     0,     0,
     0,   106,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,   360,     0,   361,     0,   379,     0,     0,     0,
     0,     0,     0,     0,     0,   369,   106,     0,     0,     0,
     0,     0,     0,     0,     0,   376,     0,   394,     0,     0,
     0,     0,     0,     0,     0,     0,   385,   106,     0,     0,
   388,     0,   402,     0,     0,     0,     0,     0,   393,     0,
   409,     0,   106,     0,     0,     0,     0,   412,     0,     0,
   106,     0,     0,     0,     0,   403,   404,   106,   406,     0,
   407,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,   416,   417,     1,     2,     3,     4,
     5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
    15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
    25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
    35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
    45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
    55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
    65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
    75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
    85,    86,    87,    88,    89,    90,    91
};

static const short yycheck[] = {    11,
     5,   348,     5,   202,     5,     8,     3,     6,     7,    31,
     9,    10,     3,    12,    13,     3,    15,    16,     3,    31,
     3,    20,    21,    22,   371,    47,     5,     6,     5,     5,
     5,     5,     5,     3,     3,    47,    35,     5,     5,     5,
     3,    63,    64,     3,     5,     3,     5,   257,     5,     5,
     3,    63,    64,     3,    53,     3,     5,    56,     5,     3,
     3,     3,     3,     3,     3,     3,    88,     3,     5,    92,
     5,     5,     5,    72,     5,     3,    88,   276,    77,     3,
     5,    80,     3,    82,    83,    84,     3,     5,     3,     5,
     3,     5,     3,     5,     3,    95,    96,     5,     5,     5,
     5,     5,     5,     5,     3,     5,   105,     3,     5,     3,
     5,   111,     5,   113,     5,     5,     5,     5,   118,     6,
   120,     5,     5,     5,     5,     5,     5,     5,   128,   129,
     5,     5,   132,     5,     5,     3,   136,     3,   138,   139,
     5,   141,     5,   143,   144,     5,   168,   169,     5,   348,
     5,     5,     3,     3,     3,     3,   168,   169,   158,     5,
     5,   161,   162,     5,     5,     5,     5,     3,     5,     7,
     5,     5,   172,   195,     5,     5,     5,     5,     5,     5,
     5,     3,     3,   195,     7,     5,     5,   187,   188,     5,
     5,     5,   192,     5,     5,     5,     5,     5,   198,     5,
     3,     5,   201,     5,   203,     3,     3,     3,     3,    -1,
    -1,     5,     5,     3,     5,    -1,     5,     5,     5,     5,
     5,     5,     5,     5,     5,     5,     5,     5,     5,     5,
     5,   253,     5,   255,     5,     5,     5,     5,   238,     3,
     3,   253,   242,   255,     5,   244,     3,     5,     3,     5,
   272,     5,     5,     5,   254,     5,     5,     5,     5,     5,
   272,     5,     5,     5,     3,     5,     3,     5,     3,     5,
     3,     5,    -1,     5,     5,     5,     5,     5,     5,     5,
     3,     5,    -1,   283,     5,     5,     5,     5,     5,     3,
   290,   291,     5,     5,     5,     5,     5,     5,     3,     5,
     0,   323,     5,     5,     5,   305,     0,    -1,    -1,    -1,
    -1,   323,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,   332,    -1,   334,    -1,   358,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,   345,   358,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,   355,    -1,   379,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,   366,   379,    -1,    -1,
   370,    -1,   394,    -1,    -1,    -1,    -1,    -1,   378,    -1,
   402,    -1,   394,    -1,    -1,    -1,    -1,   409,    -1,    -1,
   402,    -1,    -1,    -1,    -1,   395,   396,   409,   398,    -1,
   399,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,   414,   415,     9,    10,    11,    12,
    13,    14,    15,    16,    17,    18,    19,    20,    21,    22,
    23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
    33,    34,    35,    36,    37,    38,    39,    40,    41,    42,
    43,    44,    45,    46,    47,    48,    49,    50,    51,    52,
    53,    54,    55,    56,    57,    58,    59,    60,    61,    62,
    63,    64,    65,    66,    67,    68,    69,    70,    71,    72,
    73,    74,    75,    76,    77,    78,    79,    80,    81,    82,
    83,    84,    85,    86,    87,    88,    89,    90,    91,    92,
    93,    94,    95,    96,    97,    98,    99
};
/* -*-C-*-  Note some compilers choke on comments on `#line' lines.  */
#line 3 "/usr/pubsw/lib/bison.simple"
/* This file comes from bison-1.28.  */

/* Skeleton output parser for bison,
   Copyright (C) 1984, 1989, 1990 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* This is the parser code that is written into each bison parser
  when the %semantic_parser declaration is not specified in the grammar.
  It was written by Richard Stallman by simplifying the hairy parser
  used when %semantic_parser is specified.  */

#ifndef YYSTACK_USE_ALLOCA
#ifdef alloca
#define YYSTACK_USE_ALLOCA
#else /* alloca not defined */
#ifdef __GNUC__
#define YYSTACK_USE_ALLOCA
#define alloca __builtin_alloca
#else /* not GNU C.  */
#if (!defined (__STDC__) && defined (sparc)) || defined (__sparc__) || defined (__sparc) || defined (__sgi) || (defined (__sun) && defined (__i386))
#define YYSTACK_USE_ALLOCA
#include <alloca.h>
#else /* not sparc */
/* We think this test detects Watcom and Microsoft C.  */
/* This used to test MSDOS, but that is a bad idea
   since that symbol is in the user namespace.  */
#if (defined (_MSDOS) || defined (_MSDOS_)) && !defined (__TURBOC__)
#if 0 /* No need for malloc.h, which pollutes the namespace;
	 instead, just don't use alloca.  */
#include <malloc.h>
#endif
#else /* not MSDOS, or __TURBOC__ */
#if defined(_AIX)
/* I don't know what this was needed for, but it pollutes the namespace.
   So I turned it off.   rms, 2 May 1997.  */
/* #include <malloc.h>  */
 #pragma alloca
#define YYSTACK_USE_ALLOCA
#else /* not MSDOS, or __TURBOC__, or _AIX */
#if 0
#ifdef __hpux /* haible@ilog.fr says this works for HPUX 9.05 and up,
		 and on HPUX 10.  Eventually we can turn this on.  */
#define YYSTACK_USE_ALLOCA
#define alloca __builtin_alloca
#endif /* __hpux */
#endif
#endif /* not _AIX */
#endif /* not MSDOS, or __TURBOC__ */
#endif /* not sparc */
#endif /* not GNU C */
#endif /* alloca not defined */
#endif /* YYSTACK_USE_ALLOCA not defined */

#ifdef YYSTACK_USE_ALLOCA
#define YYSTACK_ALLOC alloca
#else
#define YYSTACK_ALLOC malloc
#endif

/* Note: there must be only one dollar sign in this file.
   It is replaced by the list of actions, each action
   as one case of the switch.  */

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		-2
#define YYEOF		0
#define YYACCEPT	goto yyacceptlab
#define YYABORT 	goto yyabortlab
#define YYERROR		goto yyerrlab1
/* Like YYERROR except do call yyerror.
   This remains here temporarily to ease the
   transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */
#define YYFAIL		goto yyerrlab
#define YYRECOVERING()  (!!yyerrstatus)
#define YYBACKUP(token, value) \
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    { yychar = (token), yylval = (value);			\
      yychar1 = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { yyerror ("syntax error: cannot back up"); YYERROR; }	\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

#ifndef YYPURE
#define YYLEX		yylex()
#endif

#ifdef YYPURE
#ifdef YYLSP_NEEDED
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, &yylloc, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval, &yylloc)
#endif
#else /* not YYLSP_NEEDED */
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval)
#endif
#endif /* not YYLSP_NEEDED */
#endif

/* If nonreentrant, generate the variables here */

#ifndef YYPURE

int	yychar;			/*  the lookahead symbol		*/
YYSTYPE	yylval;			/*  the semantic value of the		*/
				/*  lookahead symbol			*/

#ifdef YYLSP_NEEDED
YYLTYPE yylloc;			/*  location data for the lookahead	*/
				/*  symbol				*/
#endif

int yynerrs;			/*  number of parse errors so far       */
#endif  /* not YYPURE */

#if YYDEBUG != 0
int yydebug;			/*  nonzero means print parse trace	*/
/* Since this is uninitialized, it does not stop multiple parsers
   from coexisting.  */
#endif

/*  YYINITDEPTH indicates the initial size of the parser's stacks	*/

#ifndef	YYINITDEPTH
#define YYINITDEPTH 200
#endif

/*  YYMAXDEPTH is the maximum size the stacks can grow to
    (effective only if the built-in stack extension method is used).  */

#if YYMAXDEPTH == 0
#undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
#define YYMAXDEPTH 10000
#endif

/* Define __yy_memcpy.  Note that the size argument
   should be passed with type unsigned int, because that is what the non-GCC
   definitions require.  With GCC, __builtin_memcpy takes an arg
   of type size_t, but it can handle unsigned int.  */

#if __GNUC__ > 1		/* GNU C and GNU C++ define this.  */
#define __yy_memcpy(TO,FROM,COUNT)	__builtin_memcpy(TO,FROM,COUNT)
#else				/* not GNU C or C++ */
#ifndef __cplusplus

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (to, from, count)
     char *to;
     char *from;
     unsigned int count;
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#else /* __cplusplus */

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (char *to, char *from, unsigned int count)
{
  register char *t = to;
  register char *f = from;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#endif
#endif

#line 217 "/usr/pubsw/lib/bison.simple"

/* The user can define YYPARSE_PARAM as the name of an argument to be passed
   into yyparse.  The argument should have type void *.
   It should actually point to an object.
   Grammar actions can access the variable by casting it
   to the proper pointer type.  */

#ifdef YYPARSE_PARAM
#ifdef __cplusplus
#define YYPARSE_PARAM_ARG void *YYPARSE_PARAM
#define YYPARSE_PARAM_DECL
#else /* not __cplusplus */
#define YYPARSE_PARAM_ARG YYPARSE_PARAM
#define YYPARSE_PARAM_DECL void *YYPARSE_PARAM;
#endif /* not __cplusplus */
#else /* not YYPARSE_PARAM */
#define YYPARSE_PARAM_ARG
#define YYPARSE_PARAM_DECL
#endif /* not YYPARSE_PARAM */

/* Prevent warning if -Wstrict-prototypes.  */
#ifdef __GNUC__
#ifdef YYPARSE_PARAM
int yyparse (void *);
#else
int yyparse (void);
#endif
#endif

int
yyparse(YYPARSE_PARAM_ARG)
     YYPARSE_PARAM_DECL
{
  register int yystate;
  register int yyn;
  register short *yyssp;
  register YYSTYPE *yyvsp;
  int yyerrstatus;	/*  number of tokens to shift before error messages enabled */
  int yychar1 = 0;		/*  lookahead token as an internal (translated) token number */

  short	yyssa[YYINITDEPTH];	/*  the state stack			*/
  YYSTYPE yyvsa[YYINITDEPTH];	/*  the semantic value stack		*/

  short *yyss = yyssa;		/*  refer to the stacks thru separate pointers */
  YYSTYPE *yyvs = yyvsa;	/*  to allow yyoverflow to reallocate them elsewhere */

#ifdef YYLSP_NEEDED
  YYLTYPE yylsa[YYINITDEPTH];	/*  the location stack			*/
  YYLTYPE *yyls = yylsa;
  YYLTYPE *yylsp;

#define YYPOPSTACK   (yyvsp--, yyssp--, yylsp--)
#else
#define YYPOPSTACK   (yyvsp--, yyssp--)
#endif

  int yystacksize = YYINITDEPTH;
  int yyfree_stacks = 0;

#ifdef YYPURE
  int yychar;
  YYSTYPE yylval;
  int yynerrs;
#ifdef YYLSP_NEEDED
  YYLTYPE yylloc;
#endif
#endif

  YYSTYPE yyval;		/*  the variable used to return		*/
				/*  semantic values from the action	*/
				/*  routines				*/

  int yylen;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Starting parse\n");
#endif

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss - 1;
  yyvsp = yyvs;
#ifdef YYLSP_NEEDED
  yylsp = yyls;
#endif

/* Push a new state, which is found in  yystate  .  */
/* In all cases, when you get here, the value and location stacks
   have just been pushed. so pushing a state here evens the stacks.  */
yynewstate:

  *++yyssp = yystate;

  if (yyssp >= yyss + yystacksize - 1)
    {
      /* Give user a chance to reallocate the stack */
      /* Use copies of these so that the &'s don't force the real ones into memory. */
      YYSTYPE *yyvs1 = yyvs;
      short *yyss1 = yyss;
#ifdef YYLSP_NEEDED
      YYLTYPE *yyls1 = yyls;
#endif

      /* Get the current used size of the three stacks, in elements.  */
      int size = yyssp - yyss + 1;

#ifdef yyoverflow
      /* Each stack pointer address is followed by the size of
	 the data in use in that stack, in bytes.  */
#ifdef YYLSP_NEEDED
      /* This used to be a conditional around just the two extra args,
	 but that might be undefined if yyoverflow is a macro.  */
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yyls1, size * sizeof (*yylsp),
		 &yystacksize);
#else
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yystacksize);
#endif

      yyss = yyss1; yyvs = yyvs1;
#ifdef YYLSP_NEEDED
      yyls = yyls1;
#endif
#else /* no yyoverflow */
      /* Extend the stack our own way.  */
      if (yystacksize >= YYMAXDEPTH)
	{
	  yyerror("parser stack overflow");
	  if (yyfree_stacks)
	    {
	      free (yyss);
	      free (yyvs);
#ifdef YYLSP_NEEDED
	      free (yyls);
#endif
	    }
	  return 2;
	}
      yystacksize *= 2;
      if (yystacksize > YYMAXDEPTH)
	yystacksize = YYMAXDEPTH;
#ifndef YYSTACK_USE_ALLOCA
      yyfree_stacks = 1;
#endif
      yyss = (short *) YYSTACK_ALLOC (yystacksize * sizeof (*yyssp));
      __yy_memcpy ((char *)yyss, (char *)yyss1,
		   size * (unsigned int) sizeof (*yyssp));
      yyvs = (YYSTYPE *) YYSTACK_ALLOC (yystacksize * sizeof (*yyvsp));
      __yy_memcpy ((char *)yyvs, (char *)yyvs1,
		   size * (unsigned int) sizeof (*yyvsp));
#ifdef YYLSP_NEEDED
      yyls = (YYLTYPE *) YYSTACK_ALLOC (yystacksize * sizeof (*yylsp));
      __yy_memcpy ((char *)yyls, (char *)yyls1,
		   size * (unsigned int) sizeof (*yylsp));
#endif
#endif /* no yyoverflow */

      yyssp = yyss + size - 1;
      yyvsp = yyvs + size - 1;
#ifdef YYLSP_NEEDED
      yylsp = yyls + size - 1;
#endif

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Stack size increased to %d\n", yystacksize);
#endif

      if (yyssp >= yyss + yystacksize - 1)
	YYABORT;
    }

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Entering state %d\n", yystate);
#endif

  goto yybackup;
 yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* yychar is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (yychar == YYEMPTY)
    {
#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Reading a token: ");
#endif
      yychar = YYLEX;
    }

  /* Convert token to internal form (in yychar1) for indexing tables with */

  if (yychar <= 0)		/* This means end of input. */
    {
      yychar1 = 0;
      yychar = YYEOF;		/* Don't call YYLEX any more */

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Now at end of input.\n");
#endif
    }
  else
    {
      yychar1 = YYTRANSLATE(yychar);

#if YYDEBUG != 0
      if (yydebug)
	{
	  fprintf (stderr, "Next token is %d (%s", yychar, yytname[yychar1]);
	  /* Give the individual parser a way to print the precise meaning
	     of a token, for further debugging info.  */
#ifdef YYPRINT
	  YYPRINT (stderr, yychar, yylval);
#endif
	  fprintf (stderr, ")\n");
	}
#endif
    }

  yyn += yychar1;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != yychar1)
    goto yydefault;

  yyn = yytable[yyn];

  /* yyn is what to do for this token type in this state.
     Negative => reduce, -yyn is rule number.
     Positive => shift, yyn is new state.
       New state is final state => don't bother to shift,
       just return success.
     0, or most negative number => error.  */

  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrlab;

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting token %d (%s), ", yychar, yytname[yychar1]);
#endif

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  /* count tokens shifted since error; after three, turn off error status.  */
  if (yyerrstatus) yyerrstatus--;

  yystate = yyn;
  goto yynewstate;

/* Do the default action for the current state.  */
yydefault:

  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;

/* Do a reduction.  yyn is the number of a rule to reduce with.  */
yyreduce:
  yylen = yyr2[yyn];
  if (yylen > 0)
    yyval = yyvsp[1-yylen]; /* implement default value of the action */

#if YYDEBUG != 0
  if (yydebug)
    {
      int i;

      fprintf (stderr, "Reducing via rule %d (line %d), ",
	       yyn, yyrline[yyn]);

      /* Print the symbols being reduced, and their result.  */
      for (i = yyprhs[yyn]; yyrhs[i] > 0; i++)
	fprintf (stderr, "%s ", yytname[yyrhs[i]]);
      fprintf (stderr, " -> %s\n", yytname[yyr1[yyn]]);
    }
#endif


  switch (yyn) {

case 2:
#line 172 "ribparse.y"
{
	if (cur_array) ArrayFree( cur_array );
	cur_array = new RIB_array;
	cur_array->allocated = 0;
	cur_array->nelems = 0;
	cur_array->array = NULL;
;
    break;}
case 3:
#line 181 "ribparse.y"
{
	cur_array->element_size = sizeof( const char * );
;
    break;}
case 4:
#line 186 "ribparse.y"
{
	cur_array->element_size = sizeof( RtFloat );
;
    break;}
case 5:
#line 191 "ribparse.y"
{
	yyval.ribarray = yyvsp[0].ribarray;
;
    break;}
case 6:
#line 195 "ribparse.y"
{
	yyval.ribarray = yyvsp[0].ribarray;
;
    break;}
case 7:
#line 200 "ribparse.y"
{
	yyval.ribarray = yyvsp[0].ribarray;
;
    break;}
case 8:
#line 204 "ribparse.y"
{
	yyval.ribarray = ArrayDup(cur_array);
;
    break;}
case 9:
#line 209 "ribparse.y"
{
	yyval.ribarray = ArrayDup(cur_array);
;
    break;}
case 13:
#line 218 "ribparse.y"
{
	char *to_add = strdup(yyvsp[0].string);
	AddArrayElement( &to_add );
;
    break;}
case 14:
#line 224 "ribparse.y"
{
	yyval.ribarray = yyvsp[0].ribarray;
;
    break;}
case 15:
#line 228 "ribparse.y"
{
	yyval.ribarray = ArrayDup(cur_array);
;
    break;}
case 16:
#line 233 "ribparse.y"
{
	yyval.ribarray = ArrayDup(cur_array);
;
    break;}
case 20:
#line 242 "ribparse.y"
{
	RtFloat to_add = yyvsp[0].num;
	AddArrayElement( &to_add );
;
    break;}
case 22:
#line 250 "ribparse.y"
{
	cur_paramlist_size = 0;
;
    break;}
case 25:
#line 258 "ribparse.y"
{
	RtPointer arg = new char[ yyvsp[0].ribarray->nelems * yyvsp[0].ribarray->element_size ];
	memcpy( arg, yyvsp[0].ribarray->array, yyvsp[0].ribarray->nelems * yyvsp[0].ribarray->element_size );
	if (cur_paramlist_size >= cur_paramlist_allocated) {
		cur_paramlist_allocated = 2*cur_paramlist_allocated + 1;
		cur_paramlist_tokens = (RtToken *) realloc( cur_paramlist_tokens, cur_paramlist_allocated*sizeof(RtToken) );
		cur_paramlist_args = (RtPointer *) realloc( cur_paramlist_args, cur_paramlist_allocated*sizeof(RtPointer) );
		cur_paramlist_sizes = (RtInt *) realloc( cur_paramlist_sizes, cur_paramlist_allocated*sizeof(RtInt) );
	}
	cur_paramlist_tokens[cur_paramlist_size] = yyvsp[-1].string;
	cur_paramlist_sizes[cur_paramlist_size] = yyvsp[0].ribarray->nelems;
	cur_paramlist_args[cur_paramlist_size++] = arg;
	ArrayFree( yyvsp[0].ribarray );
;
    break;}
case 28:
#line 276 "ribparse.y"
{ printf ("RIB Version: %f\n", yyvsp[0].num ); ;
    break;}
case 29:
#line 278 "ribparse.y"
{
    int num = (int)yyvsp[-1].num;
	if (num < 0 || num >= MAX_LIGHT_HANDLE)
		Error("Invalid light handle %d passed to AreaLightSource. Ignoring.", num);
	else
		lights[num] = RiAreaLightSourceV( yyvsp[-2].string, CPS, CPT, CPA );
;
    break;}
case 30:
#line 286 "ribparse.y"
{
	RiAtmosphereV( yyvsp[-1].string, CPS, CPT, CPA );
;
    break;}
case 31:
#line 290 "ribparse.y"
{
	RiAttributeV( yyvsp[-1].string, CPS, CPT, CPA );
;
    break;}
case 32:
#line 294 "ribparse.y"
{
	RiAttributeBegin();
;
    break;}
case 33:
#line 298 "ribparse.y"
{
	RiAttributeEnd();
;
    break;}
case 34:
#line 302 "ribparse.y"
{
	RtFloat * basis1 = FindBasis( yyvsp[-3].string );
	RtFloat * basis2 = FindBasis( yyvsp[-1].string );
	RiBasis( basis1, RtInt(yyvsp[-2].num), basis2, RtInt(yyvsp[0].num) );
;
    break;}
case 35:
#line 308 "ribparse.y"
{
	if (VerifyArrayLength( yyvsp[-1].ribarray, 16, "Basis" )) {
		RtFloat * basis1 = FindBasis( yyvsp[-3].string );
		RiBasis( basis1, RtInt(yyvsp[-2].num), (RtFloat *) yyvsp[-1].ribarray->array, RtInt(yyvsp[0].num) );
	}
	ArrayFree( yyvsp[-1].ribarray );
;
    break;}
case 36:
#line 316 "ribparse.y"
{
	if (VerifyArrayLength( yyvsp[-3].ribarray, 16, "Basis" )) {
		RtFloat * basis2 = FindBasis( yyvsp[-1].string );
		RiBasis( (RtFloat *) yyvsp[-3].ribarray->array, RtInt(yyvsp[-2].num), basis2, RtInt(yyvsp[0].num) );
	}
	ArrayFree( yyvsp[-3].ribarray );
;
    break;}
case 37:
#line 324 "ribparse.y"
{
	if (VerifyArrayLength(yyvsp[-3].ribarray, 16, "Basis") && VerifyArrayLength(yyvsp[-1].ribarray, 16, "Basis"))
		RiBasis( (RtFloat *) yyvsp[-3].ribarray->array, RtInt(yyvsp[-2].num), (RtFloat *) yyvsp[-1].ribarray->array, RtInt(yyvsp[0].num) );
	ArrayFree( yyvsp[-3].ribarray );
	ArrayFree( yyvsp[-1].ribarray );
;
    break;}
case 38:
#line 331 "ribparse.y"
{
	RtBound bound;
	bound[0] = yyvsp[-5].num; bound[1] = yyvsp[-4].num; bound[2] = yyvsp[-3].num;
	bound[3] = yyvsp[-2].num; bound[4] = yyvsp[-1].num; bound[5] = yyvsp[0].num;
	RiBound( bound );
;
    break;}
case 39:
#line 338 "ribparse.y"
{
	if (VerifyArrayLength( yyvsp[0].ribarray, 6, "Bound" ))
		RiBound( (RtFloat *) yyvsp[0].ribarray->array );
	ArrayFree( yyvsp[0].ribarray );
;
    break;}
case 40:
#line 344 "ribparse.y"
{
	RiClipping( yyvsp[-1].num, yyvsp[0].num );
;
    break;}
case 41:
#line 348 "ribparse.y"
{
	RtBound color;
	color[0] = yyvsp[-2].num; color[1] = yyvsp[-1].num; color[2] = yyvsp[0].num;
	RiColor( color );
;
    break;}
case 42:
#line 354 "ribparse.y"
{
	if (VerifyArrayLength( yyvsp[0].ribarray, 3, "Color" ));
		RiColor( (RtFloat *) yyvsp[0].ribarray->array );
	ArrayFree( yyvsp[0].ribarray );
;
    break;}
case 43:
#line 360 "ribparse.y"
{
	if (yyvsp[-1].ribarray->nelems != yyvsp[0].ribarray->nelems) {
		ParseError( "The two arrays should be the same size in ColorSamples" );
		goto noGoodColor;
	}
	if (yyvsp[-1].ribarray->nelems % 3 != 0) {
		ParseError( "The two arrays should be the multiples of 3 in ColorSamples" );
		goto noGoodColor;
	}
	RiColorSamples( yyvsp[-1].ribarray->nelems / 3, NA(yyvsp[-1].ribarray), NA(yyvsp[0].ribarray) );
noGoodColor:
	ArrayFree( yyvsp[-1].ribarray );
	ArrayFree( yyvsp[0].ribarray );
;
    break;}
case 44:
#line 375 "ribparse.y"
{
	RiConeV( yyvsp[-3].num, yyvsp[-2].num, yyvsp[-1].num, CPS, CPT, CPA );
;
    break;}
case 45:
#line 379 "ribparse.y"
{
  RiButterflyV( yyvsp[-4].num, yyvsp[-3].num, yyvsp[-2].num, yyvsp[-1].num, CPS, CPT, CPA );
;
    break;}
case 46:
#line 383 "ribparse.y"
{
	VerifyArrayLength( yyvsp[-1].ribarray, 4, "Butterfly" );
	RiButterflyV( NA(yyvsp[-1].ribarray)[0], NA(yyvsp[-1].ribarray)[1], NA(yyvsp[-1].ribarray)[2], NA(yyvsp[-1].ribarray)[3], CPS, CPT, CPA );
;
    break;}
case 47:
#line 388 "ribparse.y"
{
	VerifyArrayLength( yyvsp[-1].ribarray, 3, "Cone" );
	RiConeV( NA(yyvsp[-1].ribarray)[0], NA(yyvsp[-1].ribarray)[1], NA(yyvsp[-1].ribarray)[2], CPS, CPT, CPA );
;
    break;}
case 48:
#line 393 "ribparse.y"
{
	if (VerifyArrayLength( yyvsp[0].ribarray, 16, "ConcatTransform" ));
		RiConcatTransform( (RtFloat *) yyvsp[0].ribarray->array );
	ArrayFree( yyvsp[0].ribarray );
;
    break;}
case 49:
#line 399 "ribparse.y"
{
	RiCoordinateSystem( yyvsp[0].string );
;
    break;}
case 50:
#line 403 "ribparse.y"
{
	RiCropWindow( yyvsp[-3].num, yyvsp[-2].num, yyvsp[-1].num, yyvsp[0].num );
;
    break;}
case 51:
#line 407 "ribparse.y"
{
	if (VerifyArrayLength( yyvsp[0].ribarray, 4, "CropWindow" ))
		RiCropWindow( NA(yyvsp[0].ribarray)[0], NA(yyvsp[0].ribarray)[1], NA(yyvsp[0].ribarray)[2], NA(yyvsp[0].ribarray)[3] );
	ArrayFree( yyvsp[0].ribarray );
;
    break;}
case 52:
#line 413 "ribparse.y"
{
	RiCylinderV( yyvsp[-4].num, yyvsp[-3].num, yyvsp[-2].num, yyvsp[-1].num, CPS, CPT, CPA );
;
    break;}
case 53:
#line 417 "ribparse.y"
{
	if (VerifyArrayLength( yyvsp[-1].ribarray, 4, "Cylinder" ))
		RiCylinderV( NA(yyvsp[-1].ribarray)[0], NA(yyvsp[-1].ribarray)[1], NA(yyvsp[-1].ribarray)[2], NA(yyvsp[-1].ribarray)[3], CPS, CPT, CPA );
	ArrayFree( yyvsp[-1].ribarray );
;
    break;}
case 54:
#line 423 "ribparse.y"
{
	RiDeclare( yyvsp[-1].string, yyvsp[0].string );
;
    break;}
case 55:
#line 427 "ribparse.y"
{
	RiDeformationV( yyvsp[-1].string, CPS, CPT, CPA );
;
    break;}
case 56:
#line 431 "ribparse.y"
{
	RiDepthOfField( yyvsp[-2].num, yyvsp[-1].num, yyvsp[0].num );
;
    break;}
case 57:
#line 435 "ribparse.y"
{
	RiDepthOfField( RI_INFINITY, 0, 0 );
;
    break;}
case 58:
#line 439 "ribparse.y"
{
	RtBound bound;
	bound[0] = yyvsp[-5].num; bound[1] = yyvsp[-4].num; bound[2] = yyvsp[-3].num;
	bound[3] = yyvsp[-2].num; bound[4] = yyvsp[-1].num; bound[5] = yyvsp[0].num;
	RiDetail( bound );
;
    break;}
case 59:
#line 446 "ribparse.y"
{
	if (VerifyArrayLength( yyvsp[0].ribarray, 6, "Detail" ))
		RiDetail( (RtFloat *) yyvsp[0].ribarray->array );
	ArrayFree( yyvsp[0].ribarray );
;
    break;}
case 60:
#line 452 "ribparse.y"
{
	RiDetailRange( yyvsp[-3].num, yyvsp[-2].num, yyvsp[-1].num, yyvsp[0].num );
;
    break;}
case 61:
#line 456 "ribparse.y"
{
	if (VerifyArrayLength( yyvsp[0].ribarray, 4, "DetailRange" ))
		RiDetailRange( NA(yyvsp[0].ribarray)[0], NA(yyvsp[0].ribarray)[1], NA(yyvsp[0].ribarray)[2], NA(yyvsp[0].ribarray)[3] );
	ArrayFree( yyvsp[0].ribarray );
;
    break;}
case 62:
#line 462 "ribparse.y"
{
	RiDiskV( yyvsp[-3].num, yyvsp[-2].num, yyvsp[-1].num, CPS, CPT, CPA );
;
    break;}
case 63:
#line 466 "ribparse.y"
{
	if (VerifyArrayLength( yyvsp[-1].ribarray, 3, "Disk" ))
		RiDiskV( NA(yyvsp[-1].ribarray)[0], NA(yyvsp[-1].ribarray)[1], NA(yyvsp[-1].ribarray)[2], CPS, CPT, CPA );
	ArrayFree( yyvsp[-1].ribarray );
;
    break;}
case 64:
#line 472 "ribparse.y"
{
	RiDisplacementV( yyvsp[-1].string, CPS, CPT, CPA );
;
    break;}
case 65:
#line 476 "ribparse.y"
{
	RiDisplayV( yyvsp[-3].string, yyvsp[-2].string, yyvsp[-1].string, CPS, CPT, CPA );
;
    break;}
case 66:
#line 480 "ribparse.y"
{
	RiExposure( yyvsp[-1].num, yyvsp[0].num );
;
    break;}
case 67:
#line 484 "ribparse.y"
{
	RiExteriorV( yyvsp[-1].string, CPS, CPT, CPA );
;
    break;}
case 68:
#line 488 "ribparse.y"
{
	RiFormat( RtInt(yyvsp[-2].num), RtInt(yyvsp[-1].num), yyvsp[0].num );
;
    break;}
case 69:
#line 492 "ribparse.y"
{
	RiFrameAspectRatio( yyvsp[0].num );
;
    break;}
case 70:
#line 496 "ribparse.y"
{
	RiFrameBegin( RtInt(yyvsp[0].num) );
;
    break;}
case 71:
#line 500 "ribparse.y"
{
	RiFrameEnd();
;
    break;}
case 72:
#line 504 "ribparse.y"
{
	RtInt *verts = MakeIntArray( yyvsp[-1].ribarray );
	RiGeneralPolygonV( yyvsp[-1].ribarray->nelems, verts, CPS, CPT, CPA );
	delete [] verts;
	ArrayFree( yyvsp[-1].ribarray );
;
    break;}
case 73:
#line 511 "ribparse.y"
{
	RiGeometricApproximation( yyvsp[-1].string, yyvsp[0].num );
;
    break;}
case 74:
#line 515 "ribparse.y"
{
	RiGeometryV( yyvsp[-1].string, CPS, CPT, CPA );
;
    break;}
case 75:
#line 519 "ribparse.y"
{
	RiHiderV( yyvsp[-1].string, CPS, CPT, CPA );
;
    break;}
case 76:
#line 523 "ribparse.y"
{
	RtPoint point1, point2;
	point1[0] = yyvsp[-7].num; point1[1] = yyvsp[-6].num; point1[2] = yyvsp[-5].num;
	point2[0] = yyvsp[-4].num; point2[1] = yyvsp[-3].num; point2[2] = yyvsp[-2].num;
	RiHyperboloidV( point1, point2, yyvsp[-1].num, CPS, CPT, CPA );
;
    break;}
case 77:
#line 530 "ribparse.y"
{
	RtBound point1, point2;
	if (VerifyArrayLength( yyvsp[-1].ribarray, 7, "Hyperboloid" )) {
		point1[0] = NA(yyvsp[-1].ribarray)[0]; point1[1] = NA(yyvsp[-1].ribarray)[1]; point1[2] = NA(yyvsp[-1].ribarray)[2];
		point2[0] = NA(yyvsp[-1].ribarray)[3]; point2[1] = NA(yyvsp[-1].ribarray)[4]; point2[2] = NA(yyvsp[-1].ribarray)[5];
		RiHyperboloidV( point1, point2, NA(yyvsp[-1].ribarray)[6], CPS, CPT, CPA );
	}
	ArrayFree( yyvsp[-1].ribarray );
;
    break;}
case 78:
#line 540 "ribparse.y"
{
	RiIdentity();
;
    break;}
case 79:
#line 544 "ribparse.y"
{
    int num = (int)yyvsp[-1].num;
	if (num < 0 || num >= MAX_LIGHT_HANDLE)
		Error("Invalid light handle %d passed to Illuminate. Ignoring.", num);
	else {
		RtLightHandle light = lights[num];
		if (light == (RtLightHandle)RI_NULL)
			ParseError( "Unknown light number: %d", num);
		else
			RiIlluminate( light, (RtBoolean) yyvsp[0].num );
	}
;
    break;}
case 80:
#line 557 "ribparse.y"
{
	RiImagerV( yyvsp[-1].string, CPS, CPT, CPA );
;
    break;}
case 81:
#line 561 "ribparse.y"
{
	RiInteriorV( yyvsp[-1].string, CPS, CPT, CPA );
;
    break;}
case 82:
#line 565 "ribparse.y"
{
    int num = (int)yyvsp[-1].num;
	if (num < 0 || num >= MAX_LIGHT_HANDLE)
		Error("Invalid light handle %d passed to LightSource. Ignoring.", num);
	else
		lights[num] = RiLightSourceV( yyvsp[-2].string, CPS, CPT, CPA );
;
    break;}
case 83:
#line 573 "ribparse.y"
{
	RtFilterFunc filterfunc = FindFilterFunc( yyvsp[-3].string );
	RiMakeBumpV( yyvsp[-7].string, yyvsp[-6].string, yyvsp[-5].string, yyvsp[-4].string, filterfunc, yyvsp[-2].num, yyvsp[-1].num, CPS, CPT, CPA );
;
    break;}
case 84:
#line 578 "ribparse.y"
{
	RtFilterFunc filterfunc = FindFilterFunc( yyvsp[-3].string );
	RiMakeCubeFaceEnvironmentV( yyvsp[-11].string, yyvsp[-10].string, yyvsp[-9].string, yyvsp[-8].string, yyvsp[-7].string, yyvsp[-6].string, yyvsp[-5].string, yyvsp[-4].num, filterfunc,
		yyvsp[-2].num, yyvsp[-1].num, CPS, CPT, CPA );
;
    break;}
case 85:
#line 584 "ribparse.y"
{
	RtFilterFunc filterfunc = FindFilterFunc( yyvsp[-3].string );
	RiMakeLatLongEnvironmentV( yyvsp[-5].string, yyvsp[-4].string, filterfunc, yyvsp[-2].num, yyvsp[-2].num, CPS, CPT, CPA );
;
    break;}
case 86:
#line 589 "ribparse.y"
{
	RiMakeShadowV( yyvsp[-2].string, yyvsp[-1].string, CPS, CPT, CPA );
;
    break;}
case 87:
#line 593 "ribparse.y"
{
	RtFilterFunc filterfunc = FindFilterFunc( yyvsp[-3].string );
	RiMakeTextureV( yyvsp[-7].string, yyvsp[-6].string, yyvsp[-5].string, yyvsp[-4].string, filterfunc, yyvsp[-2].num, yyvsp[-1].num, CPS, CPT, CPA );
;
    break;}
case 88:
#line 598 "ribparse.y"
{
	RiMatte( yyvsp[0].num != 0. );
;
    break;}
case 89:
#line 602 "ribparse.y"
{
	RiMotionBeginV( yyvsp[0].ribarray->nelems, NA(yyvsp[0].ribarray) );
	ArrayFree( yyvsp[0].ribarray );
;
    break;}
case 90:
#line 607 "ribparse.y"
{
	RiMotionEnd();
;
    break;}
case 91:
#line 611 "ribparse.y"
{
	RiNuPatchV( RtInt(yyvsp[-10].num), RtInt(yyvsp[-9].num), NA(yyvsp[-8].ribarray), yyvsp[-7].num, yyvsp[-6].num,
				RtInt(yyvsp[-5].num), RtInt(yyvsp[-4].num), NA(yyvsp[-3].ribarray), yyvsp[-2].num, yyvsp[-1].num, CPS, CPT, CPA );
	ArrayFree(yyvsp[-8].ribarray);
	ArrayFree(yyvsp[-3].ribarray);
;
    break;}
case 92:
#line 618 "ribparse.y"
{
	Warning( "Don't know how to parse ObjectInstance" );
;
    break;}
case 93:
#line 622 "ribparse.y"
{
	RiObjectEnd();
;
    break;}
case 94:
#line 626 "ribparse.y"
{
	Warning( "Don't know how to parse ObjectInstance" );
;
    break;}
case 95:
#line 630 "ribparse.y"
{
	RtColor color;
	color[0] = yyvsp[-2].num; color[1] = yyvsp[-1].num; color[2] = yyvsp[0].num;
	RiOpacity( color );
;
    break;}
case 96:
#line 636 "ribparse.y"
{
	if (VerifyArrayLength( yyvsp[0].ribarray, 3, "Opacity" ))
		RiOpacity( (RtFloat *) yyvsp[0].ribarray->array );
	ArrayFree( yyvsp[0].ribarray );
;
    break;}
case 97:
#line 642 "ribparse.y"
{
	RiOptionV( yyvsp[-1].string, CPS, CPT, CPA );
;
    break;}
case 98:
#line 646 "ribparse.y"
{
	RiOrientation( yyvsp[0].string );
;
    break;}
case 99:
#line 650 "ribparse.y"
{
	RiParaboloidV( yyvsp[-4].num, yyvsp[-3].num, yyvsp[-2].num, yyvsp[-1].num, CPS, CPT, CPA );
;
    break;}
case 100:
#line 654 "ribparse.y"
{
	if (VerifyArrayLength( yyvsp[-1].ribarray, 4, "Paraboloid" ))
		RiParaboloidV( NA(yyvsp[-1].ribarray)[0], NA(yyvsp[-1].ribarray)[1], NA(yyvsp[-1].ribarray)[2], NA(yyvsp[-1].ribarray)[3], CPS, CPT, CPA );
	ArrayFree( yyvsp[-1].ribarray );
;
    break;}
case 101:
#line 660 "ribparse.y"
{
	RiPatchV( yyvsp[-1].string, CPS, CPT, CPA );
;
    break;}
case 102:
#line 664 "ribparse.y"
{
	RiPatchMeshV( yyvsp[-5].string, RtInt(yyvsp[-4].num), yyvsp[-3].string, RtInt(yyvsp[-2].num), yyvsp[-1].string, CPS, CPT, CPA );
;
    break;}
case 103:
#line 668 "ribparse.y"
{
	RiPerspective( yyvsp[0].num );
;
    break;}
case 104:
#line 672 "ribparse.y"
{
	RtFilterFunc func = FindFilterFunc( yyvsp[-2].string );
	RiPixelFilter( func, yyvsp[-1].num, yyvsp[0].num );
;
    break;}
case 105:
#line 677 "ribparse.y"
{
	RiPixelSamples( yyvsp[-1].num, yyvsp[0].num );
;
    break;}
case 106:
#line 681 "ribparse.y"
{
	RiPixelVariance( yyvsp[0].num );
;
    break;}
case 107:
#line 685 "ribparse.y"
{
	RtInt *nloops, *nvertices, *vertices;

	nloops = MakeIntArray( yyvsp[-3].ribarray );
	nvertices = MakeIntArray( yyvsp[-2].ribarray );
	vertices = MakeIntArray( yyvsp[-1].ribarray );

	RiPointsGeneralPolygonsV( yyvsp[-3].ribarray->nelems, nloops, nvertices, vertices, CPS, CPT, CPA );

	delete [] nloops;
	delete [] nvertices;
	delete [] vertices;
	ArrayFree( yyvsp[-3].ribarray );
	ArrayFree( yyvsp[-2].ribarray );
	ArrayFree( yyvsp[-1].ribarray );
;
    break;}
case 108:
#line 702 "ribparse.y"
{
	// Gotta convert these bad boys to arrays of integers.  that sucks.
	RtInt *nverts, *verts;

	nverts = MakeIntArray( yyvsp[-2].ribarray );
	verts = MakeIntArray( yyvsp[-1].ribarray );
	int tot = 0;
	for (int i = 0 ; i < yyvsp[-2].ribarray->nelems ; i++)
		tot += nverts[i];
	if (tot != yyvsp[-1].ribarray->nelems)
		ParseError("Wrong number of vertex elements in PointsPolygons. Ignoring.");
	else
		RiPointsPolygonsV( yyvsp[-2].ribarray->nelems, nverts, verts, CPS, CPT, CPA );

	delete [] nverts;
	delete [] verts;
	ArrayFree( yyvsp[-2].ribarray );
	ArrayFree( yyvsp[-1].ribarray );
;
    break;}
case 109:
#line 722 "ribparse.y"
{
	RtInt num_verts = -1;

	for (int i = 0 ; i < CPS ; i++) {
		if (CPT[i] == RI_P || strcmp(CPT[i], RI_P) == 0) {
			num_verts = CPSZ[i];
			if (num_verts % 3 != 0) {
				ParseError( "RI_P array must be 3*n in length." );
				goto noGoodPolygon;
			}
			num_verts /= 3;
			break;
		}
	}
	if (num_verts == -1)
		ParseError( "Polygon without an RI_P parameter???" );
	else
		RiPolygonV( num_verts, CPS, CPT, CPA );
noGoodPolygon:
	;
;
    break;}
case 110:
#line 744 "ribparse.y"
{
	RiProjectionV( yyvsp[-1].string, CPS, CPT, CPA );
;
    break;}
case 111:
#line 748 "ribparse.y"
{
	RiQuantize( yyvsp[-4].string, RtInt(yyvsp[-3].num), RtInt(yyvsp[-2].num), RtInt(yyvsp[-1].num), yyvsp[0].num );
;
    break;}
case 112:
#line 752 "ribparse.y"
{
	RiRelativeDetail( yyvsp[0].num );
;
    break;}
case 113:
#line 756 "ribparse.y"
{
	RiReverseOrientation();
;
    break;}
case 114:
#line 760 "ribparse.y"
{
	RiRotate( yyvsp[-3].num, yyvsp[-2].num, yyvsp[-1].num, yyvsp[0].num );
;
    break;}
case 115:
#line 764 "ribparse.y"
{
	RiScale( yyvsp[-2].num, yyvsp[-1].num, yyvsp[0].num );
;
    break;}
case 116:
#line 768 "ribparse.y"
{
	RiScreenWindow( yyvsp[-3].num, yyvsp[-2].num, yyvsp[-1].num, yyvsp[0].num );
;
    break;}
case 117:
#line 772 "ribparse.y"
{
	if (VerifyArrayLength( yyvsp[0].ribarray, 4, "ScreenWindow" ))
		RiScreenWindow( NA(yyvsp[0].ribarray)[0], NA(yyvsp[0].ribarray)[1], NA(yyvsp[0].ribarray)[2], NA(yyvsp[0].ribarray)[3] );
	ArrayFree( yyvsp[0].ribarray );
;
    break;}
case 118:
#line 778 "ribparse.y"
{
	RiShadingInterpolation( yyvsp[0].string );
;
    break;}
case 119:
#line 782 "ribparse.y"
{
	RiShadingRate( yyvsp[0].num );
;
    break;}
case 120:
#line 786 "ribparse.y"
{
	RiShutter( yyvsp[-1].num, yyvsp[0].num );
;
    break;}
case 121:
#line 790 "ribparse.y"
{
	RiSides( RtInt(yyvsp[0].num) );
;
    break;}
case 122:
#line 794 "ribparse.y"
{
	RiSkew( yyvsp[-6].num, yyvsp[-5].num, yyvsp[-4].num, yyvsp[-3].num, yyvsp[-2].num, yyvsp[-1].num, yyvsp[0].num );
;
    break;}
case 123:
#line 798 "ribparse.y"
{
	if (VerifyArrayLength( yyvsp[0].ribarray, 7, "Skew" ))
		RiSkew( NA(yyvsp[0].ribarray)[0], NA(yyvsp[0].ribarray)[1], NA(yyvsp[0].ribarray)[2], NA(yyvsp[0].ribarray)[3],
				NA(yyvsp[0].ribarray)[4], NA(yyvsp[0].ribarray)[5], NA(yyvsp[0].ribarray)[6] );
	ArrayFree( yyvsp[0].ribarray );
;
    break;}
case 124:
#line 805 "ribparse.y"
{
	RiSolidBegin( yyvsp[0].string );
;
    break;}
case 125:
#line 809 "ribparse.y"
{
	RiSolidEnd();
;
    break;}
case 126:
#line 813 "ribparse.y"
{
	RiSphereV( yyvsp[-4].num, yyvsp[-3].num, yyvsp[-2].num, yyvsp[-1].num, CPS, CPT, CPA );
;
    break;}
case 127:
#line 817 "ribparse.y"
{
	if (VerifyArrayLength( yyvsp[-1].ribarray, 4, "Sphere" ))
		RiSphereV( NA(yyvsp[-1].ribarray)[0], NA(yyvsp[-1].ribarray)[1], NA(yyvsp[-1].ribarray)[2], NA(yyvsp[-1].ribarray)[3], CPS, CPT, CPA );
	ArrayFree( yyvsp[-1].ribarray );
;
    break;}
case 128:
#line 823 "ribparse.y"
{
	RiSurfaceV( yyvsp[-1].string, CPS, CPT, CPA );
;
    break;}
case 129:
#line 827 "ribparse.y"
{
	RiTextureCoordinates( yyvsp[-7].num, yyvsp[-6].num, yyvsp[-5].num, yyvsp[-4].num,
						  yyvsp[-3].num, yyvsp[-2].num, yyvsp[-1].num, yyvsp[0].num );
;
    break;}
case 130:
#line 832 "ribparse.y"
{
	if (VerifyArrayLength( yyvsp[0].ribarray, 8, "TextureCoordinates" ))
		RiTextureCoordinates( NA(yyvsp[0].ribarray)[0], NA(yyvsp[0].ribarray)[1], NA(yyvsp[0].ribarray)[2], NA(yyvsp[0].ribarray)[3],
							  NA(yyvsp[0].ribarray)[4], NA(yyvsp[0].ribarray)[5], NA(yyvsp[0].ribarray)[7], NA(yyvsp[0].ribarray)[8] );
	ArrayFree( yyvsp[0].ribarray );
;
    break;}
case 131:
#line 839 "ribparse.y"
{
	RiTorus( yyvsp[-5].num, yyvsp[-4].num, yyvsp[-3].num, yyvsp[-2].num, yyvsp[-1].num, CPS, CPT, CPA );
;
    break;}
case 132:
#line 843 "ribparse.y"
{
	if (VerifyArrayLength( yyvsp[-1].ribarray, 5, "Torus" ))
		RiTorus( NA(yyvsp[-1].ribarray)[0], NA(yyvsp[-1].ribarray)[1], NA(yyvsp[-1].ribarray)[2], NA(yyvsp[-1].ribarray)[3], NA(yyvsp[-1].ribarray)[4],
			CPS, CPT, CPA );
    ArrayFree(yyvsp[-1].ribarray);
;
    break;}
case 133:
#line 850 "ribparse.y"
{
	if (VerifyArrayLength( yyvsp[0].ribarray, 16, "Transform" ))
		RiTransform( (RtFloat *) yyvsp[0].ribarray->array );
	ArrayFree( yyvsp[0].ribarray );
;
    break;}
case 134:
#line 856 "ribparse.y"
{
	RiTransformBegin();
;
    break;}
case 135:
#line 860 "ribparse.y"
{
	RiTransformEnd();
;
    break;}
case 136:
#line 864 "ribparse.y"
{
	RiTranslate( yyvsp[-2].num, yyvsp[-1].num, yyvsp[0].num );
;
    break;}
case 137:
#line 868 "ribparse.y"
{
	RtInt *ncurves, *order, *n;

	ncurves = MakeIntArray( yyvsp[-8].ribarray );
	order = MakeIntArray( yyvsp[-7].ribarray );
	n = MakeIntArray( yyvsp[-3].ribarray );

	RiTrimCurve( yyvsp[-8].ribarray->nelems, ncurves, order, NA(yyvsp[-6].ribarray), NA(yyvsp[-5].ribarray), NA(yyvsp[-4].ribarray), n, NA(yyvsp[-2].ribarray), NA(yyvsp[-1].ribarray), NA(yyvsp[0].ribarray) );
	delete [] ncurves;
	delete [] order;
	delete [] n;

	ArrayFree( yyvsp[-8].ribarray );
	ArrayFree( yyvsp[-7].ribarray );
	ArrayFree( yyvsp[-6].ribarray );
	ArrayFree( yyvsp[-5].ribarray );
	ArrayFree( yyvsp[-4].ribarray );
	ArrayFree( yyvsp[-3].ribarray );
	ArrayFree( yyvsp[-2].ribarray );
	ArrayFree( yyvsp[-1].ribarray );
	ArrayFree( yyvsp[0].ribarray );
;
    break;}
case 138:
#line 891 "ribparse.y"
{
	RiWorldBegin();
;
    break;}
case 139:
#line 895 "ribparse.y"
{
	RiWorldEnd();
;
    break;}
}
   /* the action file gets copied in in place of this dollarsign */
#line 543 "/usr/pubsw/lib/bison.simple"

  yyvsp -= yylen;
  yyssp -= yylen;
#ifdef YYLSP_NEEDED
  yylsp -= yylen;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

  *++yyvsp = yyval;

#ifdef YYLSP_NEEDED
  yylsp++;
  if (yylen == 0)
    {
      yylsp->first_line = yylloc.first_line;
      yylsp->first_column = yylloc.first_column;
      yylsp->last_line = (yylsp-1)->last_line;
      yylsp->last_column = (yylsp-1)->last_column;
      yylsp->text = 0;
    }
  else
    {
      yylsp->last_line = (yylsp+yylen-1)->last_line;
      yylsp->last_column = (yylsp+yylen-1)->last_column;
    }
#endif

  /* Now "shift" the result of the reduction.
     Determine what state that goes to,
     based on the state we popped back to
     and the rule number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTBASE] + *yyssp;
  if (yystate >= 0 && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTBASE];

  goto yynewstate;

yyerrlab:   /* here on detecting error */

  if (! yyerrstatus)
    /* If not already recovering from an error, report this error.  */
    {
      ++yynerrs;

#ifdef YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (yyn > YYFLAG && yyn < YYLAST)
	{
	  int size = 0;
	  char *msg;
	  int x, count;

	  count = 0;
	  /* Start X at -yyn if nec to avoid negative indexes in yycheck.  */
	  for (x = (yyn < 0 ? -yyn : 0);
	       x < (sizeof(yytname) / sizeof(char *)); x++)
	    if (yycheck[x + yyn] == x)
	      size += strlen(yytname[x]) + 15, count++;
	  msg = (char *) malloc(size + 15);
	  if (msg != 0)
	    {
	      strcpy(msg, "parse error");

	      if (count < 5)
		{
		  count = 0;
		  for (x = (yyn < 0 ? -yyn : 0);
		       x < (sizeof(yytname) / sizeof(char *)); x++)
		    if (yycheck[x + yyn] == x)
		      {
			strcat(msg, count == 0 ? ", expecting `" : " or `");
			strcat(msg, yytname[x]);
			strcat(msg, "'");
			count++;
		      }
		}
	      yyerror(msg);
	      free(msg);
	    }
	  else
	    yyerror ("parse error; also virtual memory exceeded");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror("parse error");
    }

  goto yyerrlab1;
yyerrlab1:   /* here on error raised explicitly by an action */

  if (yyerrstatus == 3)
    {
      /* if just tried and failed to reuse lookahead token after an error, discard it.  */

      /* return failure if at end of input */
      if (yychar == YYEOF)
	YYABORT;

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Discarding token %d (%s).\n", yychar, yytname[yychar1]);
#endif

      yychar = YYEMPTY;
    }

  /* Else will try to reuse lookahead token
     after shifting the error token.  */

  yyerrstatus = 3;		/* Each real token shifted decrements this */

  goto yyerrhandle;

yyerrdefault:  /* current state does not do anything special for the error token. */

#if 0
  /* This is wrong; only states that explicitly want error tokens
     should shift them.  */
  yyn = yydefact[yystate];  /* If its default is to accept any token, ok.  Otherwise pop it.*/
  if (yyn) goto yydefault;
#endif

yyerrpop:   /* pop the current state because it cannot handle the error token */

  if (yyssp == yyss) YYABORT;
  yyvsp--;
  yystate = *--yyssp;
#ifdef YYLSP_NEEDED
  yylsp--;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "Error: state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

yyerrhandle:

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yyerrdefault;

  yyn += YYTERROR;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != YYTERROR)
    goto yyerrdefault;

  yyn = yytable[yyn];
  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrpop;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrpop;

  if (yyn == YYFINAL)
    YYACCEPT;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting error token, ");
#endif

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  yystate = yyn;
  goto yynewstate;

 yyacceptlab:
  /* YYACCEPT comes here.  */
  if (yyfree_stacks)
    {
      free (yyss);
      free (yyvs);
#ifdef YYLSP_NEEDED
      free (yyls);
#endif
    }
  return 0;

 yyabortlab:
  /* YYABORT comes here.  */
  if (yyfree_stacks)
    {
      free (yyss);
      free (yyvs);
#ifdef YYLSP_NEEDED
      free (yyls);
#endif
    }
  return 1;
}
#line 898 "ribparse.y"

