
#ifndef TEXTURE_H
#define TEXTURE_H
#include "lrt.h"

#include "color.h"

class MIPMap {
  public:

	MIPMap(const char *filename);

	int XResolution() const {
		return xResolution;
	} int YResolution() const {
		return yResolution;
	} Spectrum GetTexel(int x, int y, int level) const;

  private:
	 u_char * data;
	int xResolution, yResolution;

};

class TextureMap { public:
	 TextureMap(const char *filename);
	 TextureMap( int width, int height, Spectrum &color );

	~TextureMap();

	int GetWidth() { return width; }
	int GetHeight() { return height; }

	Spectrum Lookup(Float u, Float v, bool wrap ) const;

	Spectrum Lookup(Float u, Float v, Float width) const;

	Spectrum Lookup(Float u, Float v, Float dudx, Float dudy,
					Float dvdx, Float dvdy) const;

	Spectrum LookupScreen( int x, int y ){
	  y = height-1-y;
	  return Texture[ y * width + x];

	}

	float xStep() { return 1/width; }
	float yStep() { return 1/height; }

	void ToRasterCoords( int x, int y, float *outU, float *outV );


	void ToScreenCoords( float u, float v, int *outX, int *outY );
	 

	void SetRaster( float u, float v, Spectrum& color ){
	  int x, y;
	  ToScreenCoords( u, v, &x, &y );
	  Set( x, y,color );
	}

	void Set( int x, int y, Spectrum& color );

  private:
	 Spectrum * Texture;
	int width, height;

};

#endif // TEXTURE_H
