#include "butterfly.h"
#include "primitives.h"


Wing::Wing( const Butterfly * bfly, wingType type, float h, float w, float angel,
       float r, PrimitiveAttributes * a, SurfaceFunction * sf )
  : Primitive(new PrimitiveAttributes(*a), new SurfaceFunction(*sf)){

  //attributes = new PrimitiveAttributes(*a);
  //surfaceFunction = new SurfaceFunction(*sf);
  height = h;
  width = w;
  angle = angel;
  roughness = r;
  wingT = type;
  b = (Butterfly *)bfly;
  fprintf(stderr,"In Wing constructor.\n");
  //GenerateWingGeometry();
  
}




bool Wing::IntersectClosest(const Ray & ray, Float mint, Float * maxt,
		       HitInfo * hit) const{

   // Your code here :-)
  float hitt;
  Normal normal;
  Point vert[4];
  vert[0] = Point(0.,0.,0.);
  vert[2] = Point(0.,1.,0.);
  vert[1] = Point(1.,0.,0.);
  vert[3] = Point(1.,1.,0.);
  if(SquareIntersect(ray, mint, *maxt, &hitt, vert)) {
    Point ip = ray(hitt);
    if (outline->IntersectOutline(ip)) {
      if(ray.D.z < 0)
	normal = Normal(Vector(0.,0.,1.));
      else
	normal = Normal(Vector(0.,0.,-1.));
      Point ip = ray(hitt);
      hit->RecordHit(ip, normal, ip.x, ip.y, this); 
      *maxt = hitt;
      return true;
      
    }
  }
  
  return false;
}



bool Wing::SquareIntersect ( const Ray & ray, float mint, float maxt, float
		       *hit_t, Point vert[4] ) const {
  
  Point tri1v[3] = {vert[0],vert[2],vert[1]};
  Point tri2v[3] = {vert[1],vert[2],vert[3]};
  
  if ( TriIntersect(ray, mint, maxt, hit_t, tri1v) )
    return true;
  if ( TriIntersect(ray, mint, maxt, hit_t, tri2v) )
    return true;

  return false;
}


bool Wing::TriIntersect (const Ray & ray, float mint, float maxt, float *hitt, 
		   Point vert[3]) const {
  
	int vertexIndex0 = 0;
	int vertexIndex1 = 1;
	int vertexIndex2 = 2;

	const Point *p = vert;
	Vector E1 = p[vertexIndex1] - p[vertexIndex0];
	Vector E2 = p[vertexIndex2] - p[vertexIndex0];
	Vector S_1 = Cross(ray.D, E2);
	Float divisor = Dot(S_1, E1);
	if (divisor == 0.)
		return false;
	Float invDivisor = 1. / divisor;

	Vector T = ray.O - p[vertexIndex0];
	Float u = Dot(T, S_1) * invDivisor;
	if (u < 0. || u > 1.0)
		return false;

	Vector S_2 = Cross(T, E1);
	Float v = Dot(ray.D, S_2) * invDivisor;
	if (v < 0 || u + v > 1.0)
		return false;

	Float t = Dot(E2, S_2) * invDivisor;
	if (t < mint || t > maxt)
		return false;
	*hitt = t;

	
	return true;     
}




BBox Wing::BoundObjectSpace() const {
  
  return BBox(Point (0.0,0.0,-.01), Point(1.0,1.0,.01)); 
  
}



void Wing::GenerateWingGeometry(){
  // calc body geometry/wing nurbs here
   // calc body geometry/wing nurbs here
  fprintf(stderr, "in GenerateWingGeometry.\n");
  int numPoints;
  int numR;
  int numES;
  int numBodyEdgeVeins;
  Point **pl;
  int *rp;
  int *wp;
  
  switch(wingT) {
    
  case lowerLeft:
  case lowerRight:
    numPoints = 22;
    numR = 5;
    numES = 3;
    numBodyEdgeVeins = 4;
    fprintf(stderr, "In generate wing.\n");
    pl = new (Point*)[numPoints];
    rp = new (int)[numR+1];
    wp = new (int)[numES];
    
    pl[0] = new Point(.17,.95,0.);
    pl[1] = new Point(.125,.625, 0.);
    pl[2] = new Point(.01,.4, 0.);
    pl[3] = new Point(.02,.25, 0.);
    pl[4] = new Point(.01,.14, 0.);
    pl[5] = new Point(.06,.08, 0.);
    pl[6] = new Point(.15,.07, 0.);
    pl[7] = new Point(.2,.04, 0.);
    pl[8] = new Point(.375,.05, 0.);
    pl[9] = new Point(.6,0, 0.);
    pl[10] = new Point(.68,.125, 0.);
    pl[11] = new Point(.75,.13, 0.);
    pl[12] = new Point(.8,.18, 0.);
    pl[13] = new Point(.86,.2, 0.);
    pl[14] = new Point(.86,.25, 0.);
    pl[15] = new Point(.9,.3, 0.);
    pl[16] = new Point(.95,.35, 0.);
    pl[17] = new Point(.95,.4, 0.);
    pl[18] = new Point(.97,.5, 0.);
    pl[19] = new Point(.65,.83, 0.);
    pl[20] = new Point(.26,.97, 0.);
    pl[21] = new Point(.2,.97, 0.);
    
    rp[0]=5; rp[1]=7; rp[2]=8; rp[3]=11; rp[4]=15; rp[5]=18;
    wp[0] = 20; wp[1] = 21; wp[2] = 0;
  
    fprintf( stderr,"here3\n" );
    if(wingT == upperRight || wingT == lowerRight) {
      fprintf(stderr, "Reversing Points\n");
      for(int i=0; i<numPoints; i++) 
	pl[i]->x = 1.0 - pl[i]->x;
    }
  
    outline = new Outline(pl, rp, wp, numPoints, numR, numES, 
			  Point(0.0,1.0,0.0), Point(*(pl[21])), 
			  numBodyEdgeVeins);
    fprintf(stderr, "Created wing outline.\n");

    
    /* Here go the multiple passes */
    
    
    
    break;
  case upperLeft:
  case upperRight:
    
    numPoints = 9;
    numR = 3;
    numES = 2;
    numBodyEdgeVeins = 3;
    fprintf(stderr, "In generate wing.\n");
    pl = new (Point*)[numPoints];
    rp = new (int)[numR+1];
    wp = new (int)[numES];
    
    pl[0] = new Point(149.,194.,0.);
    pl[1] = new Point(194.,159.,0.);
    pl[2] = new Point(254.,129.,0.);
    pl[3] = new Point(262.,69.,0.);		      
    pl[4] = new Point(221.,29.,0.);
    pl[5] = new Point(133.,9.,0.);
    pl[6] = new Point(48.,3.,0.);
    pl[7] = new Point(2.,23.,0.);
    pl[8] = new Point(35.,108.,0.);
    
    rp[0] = 0; rp[1] = 1; rp[2] = 2; rp[3] = 3;
    wp[0] = 7; wp[1] = 8;
    
    float xmult = 1./265.;
    float ymult = 1./196.;
    
    for (int i=0; i<numPoints; i++) {
      pl[i]->x = xmult * (pl[i]->x);
      pl[i]->y = 1.0 - ymult * (pl[i]->y);
      if(wingT==upperRight)
	pl[i]->x = 1.0 - pl[i]->x;
    }
    
    Point polarO = Point(0.0,1.0-50.0*ymult,0.0);
    Point pivot = Point(18.0*xmult, 1.0-65.0*ymult, 0.0);
    if(wingT==upperRight) {
      polarO.x = 1.0 - polarO.x;
      pivot.x = 1.0 - pivot.x;
    }
    outline = new Outline(pl, rp, wp, numPoints, numR, numES, 
			  polarO, pivot, numBodyEdgeVeins); 
    fprintf(stderr, "Created wing outline.\n");
    
    
    
    
    
    
    
    
    break;
  }
    
  
  
  ////***Pass One***/////


  

  
  
  int i;
  for(i=0; i<outline->numSites; i++) {
    fprintf(stderr," Point: %f, %f, %f\n",pl[i]->x,pl[i]->y,pl[i]->z);
  }
  for(i=0; i<outline->numRegions+1; i++) 
    fprintf(stderr," Region Point: %f, %f, %f\n",pl[rp[i]]->x,
	    pl[rp[i]]->y,pl[rp[i]]->z);
  for(i=0; i<outline->numEdgeSites; i++) 
    fprintf(stderr," Wing Edge Point: %f, %f, %f\n",
    pl[wp[i]]->x,pl[wp[i]]->y,pl[wp[i]]->z);
  
  fprintf(stderr,"Done with CreateWingGeometry.\n");




 




  
}



void Wing::GenerateWingTransform() {

 
  Transform identity = Identity();
  Transform pivotInv = Translate(Vector(Point(0.,0.,0.) -
  outline->pivot));
  Transform pivot = Translate(Vector(outline->pivot - Point(0.,0.,0.)));
  
  Transform move;
  Transform rotate;
  
  if(wingT == upperLeft || wingT == upperRight) {
    angle += 20.;
    move = pivot * Scale(1./(width*1.5), 1./height,1.);
  }
  else {
    move = Translate(0.,0.,-.05) * pivot * Scale(1./width,1./height,1.);
  }

  
  if(wingT == upperLeft || wingT == lowerLeft) {
    move = move * Translate(-3*b->body->radius,0.,0.);
    rotate = RotateY(angle);
  }
  else {
    move = move * Translate(3*b->body->radius,0.,0.);
    rotate = RotateY(-angle);
  }    
  Transform ButterflyToWing;
  ButterflyToWing = move;
  //ButterflyToWing = Identity();
  //rotate = Identity();
  //attributes->ObjectToWorld = attributes->ObjectToWorld * pivot;
  //attributes->WorldToObject = attributes->ObjectToWorld.GetInverse();
  attributes->WorldToObject = ButterflyToWing * attributes->WorldToObject;
  //attributes->ObjectToWorld = attributes->WorldToObject.GetInverse();
  
  attributes->WorldToObject = 
    TransformCombo(pivotInv, identity, identity, rotate) * 
    attributes->WorldToObject ;
    attributes->ObjectToWorld = attributes->WorldToObject.GetInverse();
    //attributes->ObjectToWorld = attributes->WorldToObject * Translate(20,0,0);




}



Butterfly::Butterfly( Float wWidth, Float wHeight, Float angle, Float roughness,
		   PrimitiveAttributes * a, SurfaceFunction * sf)
:	Primitive(a, sf)
{
  /*wing.height = wHeight;
  wing.width = wWidth;
  wing.angle = angle;
  wing.roughness = roughness;

  body->radius = 5; // just hardcoded for now

  printf( "Butterfly\n\twing width: %.2f\n\twing height %.2f\n\twing angle: %.2f\n\twing roughness: %.2f\n", wing.width, wing.height, wing.angle,
  wing.roughness );*/
  
  fprintf(stderr, "In Butterfly constructor.\n");
  body = new Body;
  body->radius = 5.;
  llWing = 
    new Wing(this, lowerLeft, wHeight, wWidth, angle, roughness, a, sf);
  lrWing = 
  new Wing(this, lowerRight, wHeight, wWidth, angle, roughness, a, sf);
  ulWing = 
    new Wing(this, upperLeft, wHeight, wWidth, angle, roughness, a, sf);
  urWing = 
  new Wing(this, upperRight, wHeight, wWidth, angle, roughness, a, sf);

  int i;
 
  llWing->GenerateWingGeometry();
  llWing->GenerateWingTransform();
  ulWing->GenerateWingGeometry();
  ulWing->GenerateWingTransform();
  
  lrWing->outline = new Outline(*(llWing->outline));  
  for(i=0; i<lrWing->outline->numSites; i++) {
    lrWing->outline->sites[i]->p.x = 1.0 - lrWing->outline->sites[i]->p.x;
  }
  lrWing->outline->pivot.x = 1.0 - lrWing->outline->pivot.x;
  lrWing->outline->polarO.x = 1.0 - lrWing->outline->polarO.x;
  
  lrWing->outline->InitSites();
  lrWing->outline->CalcPolarCoords();
  lrWing->outline->CreateControlPoints();
  lrWing->outline->CreatePolyOutline();
  lrWing->outline->SetupRegions();
  lrWing->outline->SetupVeins();
  lrWing->GenerateWingTransform();
  
  urWing->outline = new Outline(*(ulWing->outline));
  for(i=0; i<urWing->outline->numSites; i++) {
    urWing->outline->sites[i]->p.x = 1.0 - urWing->outline->sites[i]->p.x;
  }
  urWing->outline->pivot.x = 1.0 - urWing->outline->pivot.x;
  urWing->outline->polarO.x = 1.0 - urWing->outline->polarO.x;
  urWing->outline->InitSites();
  urWing->outline->CalcPolarCoords();
  urWing->outline->CreateControlPoints();
  urWing->outline->CreatePolyOutline();
  urWing->outline->SetupRegions();
  urWing->outline->SetupVeins();
  urWing->GenerateWingTransform();
  
  
  GenerateWingSurfaces(llWing, lrWing, ulWing, urWing);
  fprintf(stderr, "Finished with Butterfly constructor.\n");
}

void Butterfly::Refine(vector < Primitive * >*refined) const
{
  refined->reserve(4);
  refined->push_back(new Wing(*llWing));
  refined->push_back(new Wing(*lrWing));
  refined->push_back(new Wing(*ulWing));
  refined->push_back(new Wing(*urWing));
	//for (int i = 0; i < ntris; ++i)
	//refined->push_back(new Triangle(this, i));
}



void Butterfly::GenerateWingSurfaces(Wing *ll, Wing *lr, 
				     Wing *ul, Wing *ur){


  
  WingSurface *lrS, *llS, *ulS, *urS;
  
  lrS = (WingSurface*) lr->attributes->Surface =
    new WingSurface( this, lr->surfaceFunction );

  llS = (WingSurface*) ll->attributes->Surface =
    new WingSurface( this, ll->surfaceFunction  );


  ulS = (WingSurface*) ul->attributes->Surface =
    new WingSurface( this, ul->surfaceFunction );

  
  urS = (WingSurface*) ur->attributes->Surface =
    new WingSurface( this, ur->surfaceFunction );
  
  lrS->Generate( (char*)"lr", NULL );
  llS->Generate( (char*)"ll", lrS );

  urS->Generate( (char*)"ur", NULL );
  ulS->Generate( (char*)"ul", urS );


  /* ll->attributes->Surface = new WingSurface( this, ll->surfaceFunction );
     lr->attributes->Surface = new WingSurface( this, lr->surfaceFunction );
     ul->attributes->Surface = new WingSurface( this, ul->surfaceFunction ); 
     ur->attributes->Surface = new WingSurface( this, ur->surfaceFunction );*/
 
  
  /*
  WingSurface* wsurf = (WingSurface*) attributes->Surface;
  wsurf->Generate( this );*/
}



BBox Butterfly::BoundObjectSpace() const
{
  // This isn't quite right, assumes wing angle is 180
  Point p1 = Point(-2.*llWing->width, -2.*llWing->height, -body->radius );
  Point p2 = Point(2.*llWing->width, 2.*llWing->height, body->radius);
  cout << p1 << endl << p2 << endl;
  return BBox(p1, p2);
}




bool Butterfly::IntersectClosest(const Ray & ray, Float mint,
			    Float * maxt, HitInfo * hit) const
{
  
   // Your code here :-)
  float hitt;
  Normal normal;
  Point vert[4];
  vert[0] = Point(0.,0.,0.);
  vert[2] = Point(0.,1.,0.);
  vert[1] = Point(1.,0.,0.);
  vert[3] = Point(1.,1.,0.);
  if(SquareIntersect(ray, mint, *maxt, &hitt, vert)) {
    Point ip = ray(hitt);
    if (lowerWingOutline.IntersectOutline(ip)) {
      if(ray.D.z < 0)
	normal = Normal(Vector(0.,0.,1.));
      else
	normal = Normal(Vector(0.,0.,-1.));
      Point ip = ray(hitt);
      hit->RecordHit(ip, normal, ip.x, ip.y, this); 
      *maxt = hitt;
      return true;
      
    }
  }
  
  return false;
  return false;
  }


bool Butterfly::SquareIntersect ( const Ray & ray, float mint, float maxt, float
		       *hit_t, Point vert[4] ) const {
  
  Point tri1v[3] = {vert[0],vert[2],vert[1]};
  Point tri2v[3] = {vert[1],vert[2],vert[3]};
  
  if ( TriIntersect(ray, mint, maxt, hit_t, tri1v) )
    return true;
  if ( TriIntersect(ray, mint, maxt, hit_t, tri2v) )
    return true;

  return false;
}


bool Butterfly::TriIntersect (const Ray & ray, float mint, float maxt, float *hitt, 
		   Point vert[3]) const {
  
	int vertexIndex0 = 0;
	int vertexIndex1 = 1;
	int vertexIndex2 = 2;

	const Point *p = vert;
	Vector E1 = p[vertexIndex1] - p[vertexIndex0];
	Vector E2 = p[vertexIndex2] - p[vertexIndex0];
	Vector S_1 = Cross(ray.D, E2);
	Float divisor = Dot(S_1, E1);
	if (divisor == 0.)
		return false;
	Float invDivisor = 1. / divisor;

	Vector T = ray.O - p[vertexIndex0];
	Float u = Dot(T, S_1) * invDivisor;
	if (u < 0. || u > 1.0)
		return false;

	Vector S_2 = Cross(T, E1);
	Float v = Dot(ray.D, S_2) * invDivisor;
	if (v < 0 || u + v > 1.0)
		return false;

	Float t = Dot(E2, S_2) * invDivisor;
	if (t < mint || t > maxt)
		return false;
	*hitt = t;

	
	return true;     
}
  
