
#ifndef NURBS_H
#define NURBS_H
#include "lrt.h"
#include "primitives.h"
#ifndef _WIN32
#include <alloca.h>
#endif

class NURBS:public Primitive {
  public:

	NURBS(int nu, int uorder, Float * uknot, Float umin, Float umax,
		  int nv, int vorder, Float * vknot, Float vmin, Float vmax,
		  Float * P, bool isHomogeneous, PrimitiveAttributes * attributes,
		  SurfaceFunction * surf);

	~NURBS();

	virtual BBox BoundObjectSpace() const;
	virtual BBox BoundWorldSpace() const;

	virtual bool CanIntersect() const {
		return false;
	} virtual void Refine(vector < Primitive * >*refined) const;

  private:
	 int nu, uorder, nv, vorder;
	Float umin, umax, vmin, vmax;
	Float *uknot, *vknot;
	bool isHomogeneous;
	Float *P;

};

#endif // NURBS_H
